/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupLunIdAndVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupSCSIMap;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupLunIdAndVolumeImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupMapImpl;
import java.util.Vector;

public class NIVolumeGroupSCSIMapImpl
extends NIVolumeGroupMapImpl
implements NIVolumeGroupSCSIMap {
    private static final long serialVersionUID = 4201819341160740508L;

    public NIVolumeGroupSCSIMapImpl() {
    }

    public NIVolumeGroupSCSIMapImpl(NIVolumeID[] nIVolumeIDArray) throws NIParameterInvalidServerException {
        super(nIVolumeIDArray);
    }

    public synchronized int add(NIVolumeID nIVolumeID, int n) {
        int n2 = 1;
        if (nIVolumeID != null) {
            if (n >= 0 && n < 256) {
                if (this.volumeList.get(n) == null) {
                    if (this.volumeList.indexOf(nIVolumeID) == -1) {
                        this.volumeList.setElementAt(nIVolumeID, n);
                    } else {
                        n2 = 6;
                    }
                } else {
                    n2 = 5;
                }
            } else {
                n2 = 4;
            }
        } else {
            n2 = 3;
        }
        return n2;
    }

    public synchronized int getLunID(NIVolumeID nIVolumeID) {
        int n = -1;
        if (nIVolumeID != null) {
            n = this.volumeList.indexOf(nIVolumeID);
        }
        return n;
    }

    public synchronized NIVolumeID getVolume(int n) {
        NIVolumeID nIVolumeID = null;
        if (n >= 0 && n < 256) {
            nIVolumeID = (NIVolumeID)this.volumeList.get(n);
        }
        return nIVolumeID;
    }

    public synchronized int[] getLunIDsOfVolsInGroup() {
        int[] nArray = new int[this.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.volumeList.size()) {
            if (this.volumeList.get(n2) != null) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        return nArray;
    }

    public synchronized Vector getVolsAndLunIDsInGroup() {
        Vector<NIVolumeGroupLunIdAndVolumeImpl> vector = new Vector<NIVolumeGroupLunIdAndVolumeImpl>(this.size());
        int n = 0;
        while (n < this.volumeList.size()) {
            NIVolumeID nIVolumeID = (NIVolumeID)this.volumeList.get(n);
            if (nIVolumeID != null) {
                vector.add(new NIVolumeGroupLunIdAndVolumeImpl(nIVolumeID, n));
            }
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIVolumeGroupSCSIMapImpl: [");
        Vector vector = this.getVolsAndLunIDsInGroup();
        if (vector.size() <= 8) {
            int n = 0;
            while (n < vector.size()) {
                NIVolumeGroupLunIdAndVolume nIVolumeGroupLunIdAndVolume = (NIVolumeGroupLunIdAndVolume)vector.elementAt(n);
                stringBuffer.append(nIVolumeGroupLunIdAndVolume.getVolumeID()).append(" at LUN ID ").append(nIVolumeGroupLunIdAndVolume.getLunID());
                if (n + 1 < vector.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(vector.size()).append(" volumes in list");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

