/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import java.util.Collections;
import java.util.Vector;

public class NIVolumeGroupVolumeListImpl
implements NIVolumeGroupVolumeList {
    private static final long serialVersionUID = -7364126687826470222L;
    protected Vector volumeList = null;

    public NIVolumeGroupVolumeListImpl() {
        this.volumeList = new Vector(256, 256);
    }

    public NIVolumeGroupVolumeListImpl(int n) {
        this.volumeList = new Vector(n, 256);
    }

    public NIVolumeGroupVolumeListImpl(NIVolumeID[] nIVolumeIDArray) {
        this.volumeList = new Vector(nIVolumeIDArray.length, 256);
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            if (nIVolumeIDArray[n] == null) {
                throw new NullPointerException("Null entry at array index " + n);
            }
            this.volumeList.add(nIVolumeIDArray[n]);
            ++n;
        }
        Collections.sort(this.volumeList);
        int n2 = 0;
        while (n2 < this.volumeList.size() - 1) {
            if (this.volumeList.get(n2).equals(this.volumeList.get(n2 + 1))) {
                this.volumeList.remove(n2);
                --n2;
            }
            ++n2;
        }
    }

    public synchronized int add(NIVolumeID nIVolumeID) {
        int n = 1;
        if (nIVolumeID != null) {
            int n2 = Collections.binarySearch(this.volumeList, nIVolumeID);
            if (n2 < 0) {
                int n3 = Math.abs(n2 + 1);
                this.volumeList.add(n3, nIVolumeID);
            }
        } else {
            n = 3;
        }
        return n;
    }

    public synchronized boolean remove(NIVolumeID nIVolumeID) {
        boolean bl = true;
        if (nIVolumeID != null) {
            int n = Collections.binarySearch(this.volumeList, nIVolumeID);
            if (n >= 0) {
                this.volumeList.remove(n);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean contains(NIVolumeID nIVolumeID) {
        boolean bl = false;
        if (nIVolumeID != null) {
            bl = Collections.binarySearch(this.volumeList, nIVolumeID) >= 0;
        }
        return bl;
    }

    public synchronized int size() {
        return this.volumeList.size();
    }

    public synchronized Vector getVolumesInVolumeGroup() {
        return (Vector)this.volumeList.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIVolumeGroupVolumeListImpl: [");
        int n = this.size();
        if (n <= 8) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.volumeList.elementAt(n2));
                if (n2 + 1 < n) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
        } else {
            stringBuffer.append(n).append(" volumes in list");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

