/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCCGFailureInfo;
import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCMasterInfo;
import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCMasterSubordinateInfo;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIResultImpl;
import com.ibm.storage.ess.ni.util.NISequenceNumberParser;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class NIAsyncPPRCMasterInfoImpl
extends NIResultImpl
implements NIAsyncPPRCMasterInfo,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterInfoImpl == null ? (class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterInfoImpl = NIAsyncPPRCMasterInfoImpl.class$("com.ibm.storage.ess.ni.results.NIAsyncPPRCMasterInfoImpl")) : class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterInfoImpl);
    private static final long serialVersionUID = 1L;
    private NISessionID sessionID;
    private int cgIntervalTime;
    private int xdcMaxCoordInterval;
    private int maxCGDrainTime;
    private int AXDCConsistencyState;
    private boolean inaccessibleData;
    private int fatalReason;
    private Date lastSuccessfulCGFormTime;
    private long flcSequenceNumber;
    private Calendar lastSuccessfulCGFormTimestamp;
    private int unsuccessfulCGFormAttemptsSinceLastSuccess;
    private int percentageCGFormSuccess;
    private int numSuccessfulCGs;
    private int numUnsuccessfulCGs;
    private String firstCGFailureSequence;
    private NIAsyncPPRCCGFailureInfo firstCGFailure;
    private NIAsyncPPRCCGFailureInfo previousCGFailure;
    private NIAsyncPPRCCGFailureInfo mostRecentCGFailure;
    private String masterSequence;
    private Vector subordinateAssociationsVector;
    private Date currentTime;
    private Calendar currentTimestamp;
    private int masterLSS;
    private String controlUnitType;
    private String plantOfManufacturing;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterInfoImpl;

    public NIAsyncPPRCMasterInfoImpl(long l, NISessionID nISessionID, int n, int n2, int n3, long l2, int n4, boolean bl, int n5, long l3, long l4, int n6, int n7, int n8, int n9, NIAsyncPPRCCGFailureInfo nIAsyncPPRCCGFailureInfo, NIAsyncPPRCCGFailureInfo nIAsyncPPRCCGFailureInfo2, NIAsyncPPRCCGFailureInfo nIAsyncPPRCCGFailureInfo3, String string, Vector vector, int n10) {
        super(l == 0L, l);
        this.sessionID = nISessionID;
        this.cgIntervalTime = n;
        this.xdcMaxCoordInterval = n2;
        this.maxCGDrainTime = n3;
        this.currentTime = new Date(l2);
        this.currentTimestamp = Calendar.getInstance();
        this.currentTimestamp.setTime(this.currentTime);
        this.AXDCConsistencyState = n4;
        this.inaccessibleData = bl;
        this.fatalReason = n5;
        this.lastSuccessfulCGFormTime = new Date(l3);
        this.flcSequenceNumber = l4;
        this.lastSuccessfulCGFormTimestamp = Calendar.getInstance();
        this.lastSuccessfulCGFormTimestamp.setTime(this.lastSuccessfulCGFormTime);
        this.unsuccessfulCGFormAttemptsSinceLastSuccess = n6;
        this.percentageCGFormSuccess = n7;
        this.numSuccessfulCGs = n8;
        this.numUnsuccessfulCGs = n9;
        this.firstCGFailure = nIAsyncPPRCCGFailureInfo;
        this.previousCGFailure = nIAsyncPPRCCGFailureInfo2;
        this.mostRecentCGFailure = nIAsyncPPRCCGFailureInfo3;
        this.masterSequence = NISequenceNumberParser.extractSerialFromSequence(string);
        this.plantOfManufacturing = NISequenceNumberParser.extractPlantFromSequence(string);
        this.controlUnitType = NISequenceNumberParser.extractCUTypeFromSequence(string);
        this.subordinateAssociationsVector = vector;
        this.masterLSS = n10;
    }

    public NISessionID getSessionID() {
        return this.sessionID;
    }

    public int getAXDCConsistencyState() {
        return this.AXDCConsistencyState;
    }

    public boolean isAXDCRunning() {
        return 1 == this.AXDCConsistencyState;
    }

    public boolean isAXDCPaused() {
        return 2 == this.AXDCConsistencyState;
    }

    public boolean isAXDCFatal() {
        return 3 == this.AXDCConsistencyState;
    }

    public boolean isAXDCPauseInProgress() {
        return 4 == this.AXDCConsistencyState;
    }

    public int getCGIntervalTime() {
        return this.cgIntervalTime;
    }

    public int getXDCMaxCoordInterval() {
        return this.xdcMaxCoordInterval;
    }

    public int getMaxCGDrainTime() {
        return this.maxCGDrainTime;
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public boolean masterDataNotValid() {
        return this.inaccessibleData;
    }

    public int getAXDCFatalReason() {
        return this.fatalReason;
    }

    public Date getLastSuccessfulCGFormTime() {
        return this.lastSuccessfulCGFormTime;
    }

    public int getUnsuccessfulCGFormAttemptsSinceLastSuccess() {
        return this.unsuccessfulCGFormAttemptsSinceLastSuccess;
    }

    public int getPercentageCGFormAttemptsSuccess() {
        return this.percentageCGFormSuccess;
    }

    public int getNumSuccessfulCGs() {
        return this.numSuccessfulCGs;
    }

    public int getNumUnsuccessfulCGs() {
        return this.numUnsuccessfulCGs;
    }

    public String getMasterCUSequenceNum() {
        if (!this.masterSequence.equalsIgnoreCase(NIESSID.SEQUENCE_UNKNOWN)) {
            return NISequenceNumberParser.trimLeadingZerosFromString(this.masterSequence, 5);
        }
        return this.masterSequence;
    }

    public int getNumSubordinateAssociatons() {
        return this.subordinateAssociationsVector.size();
    }

    public int getMasterLSS() {
        return this.masterLSS;
    }

    public Enumeration getSubordinateAssociations() {
        return this.subordinateAssociationsVector.elements();
    }

    public NIAsyncPPRCCGFailureInfo getFirstCGFailureInfo() {
        return this.firstCGFailure;
    }

    public NIAsyncPPRCCGFailureInfo getPreviousCGFailureInfo() {
        return this.previousCGFailure;
    }

    public NIAsyncPPRCCGFailureInfo getMostRecentCGFailureInfo() {
        return this.mostRecentCGFailure;
    }

    public Calendar getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public Calendar getLastSuccessfulCGFormTimestamp() {
        return this.lastSuccessfulCGFormTimestamp;
    }

    public String getPlantOfManufacture() {
        return this.plantOfManufacturing;
    }

    public String getControlUnitType() {
        return this.controlUnitType;
    }

    public long getFLCSequenceNumber() {
        return this.flcSequenceNumber;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nMaster ESS Information: \n");
            stringBuffer.append("Master ESS Data Valid: " + !this.inaccessibleData);
            if (!this.inaccessibleData) {
                stringBuffer.append("\n" + this.sessionID.toString() + "\n");
                stringBuffer.append("Consistency State: " + Integer.toHexString(this.AXDCConsistencyState) + "\n");
                stringBuffer.append("CG Interval Time(sec.): " + this.cgIntervalTime + "\n");
                stringBuffer.append("Maximum Coordination Interval Time(msec.): " + this.xdcMaxCoordInterval + "\n");
                stringBuffer.append("Maximum CG Drain Time(sec.): " + this.maxCGDrainTime + "\n");
                stringBuffer.append("Current Time: " + this.currentTime + "\n");
                stringBuffer.append("Fatal Reason Code: " + Integer.toHexString(this.fatalReason) + "\n");
                stringBuffer.append("Last CGFormTIme: " + this.lastSuccessfulCGFormTime + "\n");
                stringBuffer.append("Flash Copy Sequence Number: 0x:" + Long.toHexString(this.flcSequenceNumber) + "\n");
                stringBuffer.append("Unsuccessful CG form attempts since last success: " + this.unsuccessfulCGFormAttemptsSinceLastSuccess + "\n");
                stringBuffer.append("Percent CG Forms that were successful: " + this.percentageCGFormSuccess + "\n");
                stringBuffer.append("Number of successful CGs: " + this.numSuccessfulCGs + "\n");
                stringBuffer.append("Master CU Sequence Number: " + this.getMasterCUSequenceNum());
                stringBuffer.append(" Master Plant of Manfacture: " + this.plantOfManufacturing);
                stringBuffer.append(" Master Control Unit Type: " + this.controlUnitType + "\n");
                stringBuffer.append("Master LSS number: " + this.masterLSS + "\n\n");
                stringBuffer.append("Number of Subordinate Associations: " + this.subordinateAssociationsVector.size() + "\n");
                Enumeration enumeration = this.subordinateAssociationsVector.elements();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    NIAsyncPPRCMasterSubordinateInfo nIAsyncPPRCMasterSubordinateInfo = (NIAsyncPPRCMasterSubordinateInfo)enumeration.nextElement();
                    stringBuffer.append("Master Subordinate Association:[" + n++ + "] \n" + nIAsyncPPRCMasterSubordinateInfo);
                }
                stringBuffer.append("\nFirst CG Failure Info: " + this.firstCGFailure);
                stringBuffer.append("\nPrevious CG Failure Info: " + this.previousCGFailure);
                stringBuffer.append("\nMost Recent CG Failure Info: " + this.mostRecentCGFailure + "\n");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    public int getSize() {
        return this.subordinateAssociationsVector == null ? 0 : this.subordinateAssociationsVector.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

