/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NILogicalPPRCPath;
import com.ibm.storage.ess.ni.application.results.NILogicalPPRCPathData;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NILogicalPPRCPathStatusImpl;
import java.io.Serializable;

public class NILogicalPPRCPathImpl
implements NILogicalPPRCPath,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NILogicalPPRCPathImpl == null ? (class$com$ibm$storage$ess$ni$results$NILogicalPPRCPathImpl = NILogicalPPRCPathImpl.class$("com.ibm.storage.ess.ni.results.NILogicalPPRCPathImpl")) : class$com$ibm$storage$ess$ni$results$NILogicalPPRCPathImpl);
    private static final long serialVersionUID = 1L;
    private NILSSID sourceLSS = null;
    private int targetLSS = -1;
    private int targetSSID = -1;
    private String targetSequenceNumber = "Unknown";
    private int state = 65535;
    private NIHostPortID localPort = null;
    private NIResourceID destinationPort = null;
    private long targetWWNN;
    private NIResourceIDPair resourceIDPair = null;
    private NILogicalPPRCPathData[] PPRCPathData = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NILogicalPPRCPathImpl;

    public NILogicalPPRCPathImpl(NILSSID nILSSID, int n, int n2, String string, NIHostPortID nIHostPortID, NIResourceID nIResourceID, int n3, long l) {
        this.sourceLSS = nILSSID;
        this.targetLSS = n;
        this.targetSSID = n2;
        this.targetSequenceNumber = string;
        this.localPort = nIHostPortID;
        this.destinationPort = nIResourceID;
        this.state = n3;
        this.targetWWNN = l;
    }

    public NILogicalPPRCPathImpl(NIResourceIDPair nIResourceIDPair, NILogicalPPRCPathData[] nILogicalPPRCPathDataArray) {
        this.resourceIDPair = nIResourceIDPair;
        this.PPRCPathData = nILogicalPPRCPathDataArray;
    }

    public NILSSID getSourceLSS() {
        if (this.resourceIDPair != null) {
            return (NILSSID)this.resourceIDPair.getSource();
        }
        return this.sourceLSS;
    }

    public int getTargetLSSNumber() {
        if (this.resourceIDPair != null) {
            return ((NILSSID)this.resourceIDPair.getTarget()).getLSSNumber();
        }
        return this.targetLSS;
    }

    public int getTargetSSID() {
        if (this.resourceIDPair != null) {
            return ((NILSSID)this.resourceIDPair.getTarget()).getSSID();
        }
        return this.targetSSID;
    }

    public int getState() {
        if (this.PPRCPathData != null) {
            return ((NILogicalPPRCPathStatusImpl)this.PPRCPathData[0].getPPRCPathStatus()).get2105PathState();
        }
        return this.state;
    }

    public NIHostPortID getPort() {
        if (this.PPRCPathData != null) {
            return this.PPRCPathData[0].getPrimaryPortID();
        }
        return this.localPort;
    }

    public NIResourceID getDestinationPort() {
        if (this.PPRCPathData != null) {
            return this.PPRCPathData[0].getSecondaryPortID();
        }
        return this.destinationPort;
    }

    public String getTargetSequenceNumber() {
        if (this.resourceIDPair != null) {
            return this.resourceIDPair.getTarget().getESS().getSequence();
        }
        return this.targetSequenceNumber;
    }

    public long getTargetWWNN() {
        if (this.resourceIDPair != null) {
            return this.resourceIDPair.getTarget().getESS().getWWNN();
        }
        return this.targetWWNN;
    }

    public NIResourceIDPair getResourcePair() {
        return this.resourceIDPair;
    }

    public NILogicalPPRCPathData[] getPPRCPathData() {
        return this.PPRCPathData;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.resourceIDPair != null && this.PPRCPathData != null) {
                stringBuffer.append(":Local:");
                stringBuffer.append((NILSSID)this.resourceIDPair.getSource());
                stringBuffer.append(":Remote:");
                stringBuffer.append(this.resourceIDPair.getTarget().getESS().getSequence());
                stringBuffer.append(".");
                stringBuffer.append((NILSSID)this.resourceIDPair.getTarget());
                stringBuffer.append(".0x");
                stringBuffer.append(Long.toHexString(((NILSSID)this.resourceIDPair.getTarget()).getSSID()));
                stringBuffer.append(".0x");
                stringBuffer.append(Long.toHexString(this.resourceIDPair.getTarget().getESS().getWWNN()));
                int n = 0;
                while (n < this.PPRCPathData.length) {
                    stringBuffer.append(":Port: " + n + " - ");
                    stringBuffer.append(this.PPRCPathData[n].getPrimaryPortID());
                    stringBuffer.append(this.PPRCPathData[n].getSecondaryPortID());
                    stringBuffer.append(":State: " + n + " ");
                    stringBuffer.append(this.PPRCPathData[n].getPPRCPathStatus().getPathState());
                    ++n;
                }
            } else {
                stringBuffer.append(":Local:");
                stringBuffer.append(this.sourceLSS);
                stringBuffer.append(this.localPort);
                stringBuffer.append(":Remote:");
                stringBuffer.append(this.targetSequenceNumber);
                stringBuffer.append(".");
                stringBuffer.append(this.targetLSS);
                stringBuffer.append(".0x");
                stringBuffer.append(Long.toHexString(this.targetSSID));
                stringBuffer.append(this.destinationPort);
                stringBuffer.append(".0x");
                stringBuffer.append(Long.toHexString(this.targetWWNN));
                stringBuffer.append(":State:");
                stringBuffer.append(this.state);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

