/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIPPRCState;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.Serializable;

public class NIPPRCStateImpl
implements NIPPRCState,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIPPRCStateImpl == null ? (class$com$ibm$storage$ess$ni$results$NIPPRCStateImpl = NIPPRCStateImpl.class$("com.ibm.storage.ess.ni.results.NIPPRCStateImpl")) : class$com$ibm$storage$ess$ni$results$NIPPRCStateImpl);
    private int relationshipState = -1;
    private int suspendReason = -1;
    private static final int NOT_PART_OF_REMOTE_COPY_PAIR = 0;
    private static final int FULL_DUPLEX = 2;
    private static final int COPY_PENDING = 1;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIPPRCStateImpl;

    public NIPPRCStateImpl(int n, boolean bl) {
        this.suspendReason = -1;
        this.relationshipState = -1;
        if (n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10 || n == 11) {
            this.suspendReason = n;
            this.relationshipState = bl ? 4 : 32;
        } else {
            this.suspendReason = 1;
            switch (n) {
                case 2: {
                    if (bl) {
                        this.relationshipState = 1;
                        break;
                    }
                    this.relationshipState = 8;
                    break;
                }
                case 1: {
                    if (bl) {
                        this.relationshipState = 2;
                        break;
                    }
                    this.relationshipState = 16;
                    break;
                }
                case 0: {
                    this.relationshipState = 0;
                    this.suspendReason = 12;
                    break;
                }
                default: {
                    this.suspendReason = -1;
                    logger.warning("Unknown PPRC state -- " + n);
                }
            }
        }
    }

    public NIPPRCStateImpl(int n, int n2) {
        this.relationshipState = n;
        this.suspendReason = n2;
    }

    public int getSuspendReason() {
        return this.suspendReason;
    }

    public int getStateValue() {
        return this.relationshipState;
    }

    public boolean isFullDuplex() {
        return this.relationshipState == 1;
    }

    public boolean isCopyPending() {
        return this.relationshipState == 2;
    }

    public boolean isSuspended() {
        return this.relationshipState == 4;
    }

    public boolean isSecondaryFullDuplex() {
        return this.relationshipState == 8;
    }

    public boolean isSecondaryCopyPending() {
        return this.relationshipState == 16;
    }

    public boolean isSecondarySuspended() {
        return this.relationshipState == 32;
    }

    public Object clone() {
        try {
            NIPPRCStateImpl nIPPRCStateImpl = (NIPPRCStateImpl)super.clone();
            return nIPPRCStateImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.throwable((Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public String toString() {
        String string = this.getStateValue() == 0 ? "NOT_PART_OF_REMOTE_COPY_PAIR" : (this.isCopyPending() ? "COPY_PENDING" : (this.isFullDuplex() ? "FULL_DUPLEX" : (this.isSuspended() ? "SUSPENDED" : (this.isSecondaryCopyPending() ? "SECONDARY_COPY_PENDING" : (this.isSecondaryFullDuplex() ? "SECONDARY_FULL_DUPLEX" : (this.isSecondarySuspended() ? "SECONDARY_SUSPENDED" : "UNKNOWN STATE"))))));
        StringBuffer stringBuffer = new StringBuffer("NIPPRCStateImpl [");
        stringBuffer.append("state = " + string + ", ");
        stringBuffer.append("suspendReason = " + this.getSuspendReason() + "]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

