/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionInfo;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionVolumeInfo;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIResultImpl;
import com.ibm.storage.ess.ni.results.NIXDCSessionVolumeInfoImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class NIXDCSessionInfoImpl
extends NIResultImpl
implements NIXDCSessionInfo,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIXDCSessionInfoImpl == null ? (class$com$ibm$storage$ess$ni$results$NIXDCSessionInfoImpl = NIXDCSessionInfoImpl.class$("com.ibm.storage.ess.ni.results.NIXDCSessionInfoImpl")) : class$com$ibm$storage$ess$ni$results$NIXDCSessionInfoImpl);
    private static final long serialVersionUID = 1L;
    private NISessionID sessionID;
    private int status;
    private Hashtable volumeInfoTable;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIXDCSessionInfoImpl;

    public NIXDCSessionInfoImpl(boolean bl, long l, NISessionID nISessionID, int n, Hashtable hashtable) {
        super(bl, l);
        this.sessionID = nISessionID;
        this.status = n;
        this.volumeInfoTable = hashtable;
    }

    public NISessionID getSessionID() {
        return this.sessionID;
    }

    public boolean isXDCNormal() {
        return 0 == this.status;
    }

    public boolean isXDCIncrementPending() {
        return 1 == this.status;
    }

    public boolean isXDCInProgress() {
        return 2 == this.status;
    }

    public int getNumVolumes() {
        return this.volumeInfoTable.size();
    }

    public boolean hasNoActiveVolumes() {
        return 0 == this.getNumVolumes();
    }

    public Enumeration getXDCSessionVolumeInfoEnumeration() {
        return this.volumeInfoTable.elements();
    }

    public NIXDCSessionVolumeInfo getXDCSessionVolumeInfo(NIVolumeID nIVolumeID) {
        NIXDCSessionVolumeInfo nIXDCSessionVolumeInfo = null;
        if (this.volumeInfoTable.containsKey(nIVolumeID)) {
            nIXDCSessionVolumeInfo = (NIXDCSessionVolumeInfo)this.volumeInfoTable.get(nIVolumeID);
        }
        return nIXDCSessionVolumeInfo;
    }

    public int getSessionStatus() {
        return this.status;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("XDC Session and Device Info: \n");
            stringBuffer.append(super.toString() + "\n");
            stringBuffer.append(this.sessionID + "\n");
            stringBuffer.append("Session Status: 0x" + Integer.toHexString(0xFFFF & this.status) + "\n");
            stringBuffer.append("Number of Volumes in the Session: " + this.getNumVolumes() + "\n\n");
            Enumeration enumeration = this.getXDCSessionVolumeInfoEnumeration();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    NIXDCSessionVolumeInfoImpl nIXDCSessionVolumeInfoImpl = (NIXDCSessionVolumeInfoImpl)enumeration.nextElement();
                    NIVolumeID nIVolumeID = nIXDCSessionVolumeInfoImpl.getVolume();
                    stringBuffer.append((NIXDCSessionVolumeInfoImpl)this.getXDCSessionVolumeInfo(nIVolumeID) + "\n");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

