/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionInfo;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionStatus;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIXDCResultImpl;
import com.ibm.storage.ess.ni.results.NIXDCSessionInfoImpl;
import com.ibm.storage.ess.ni.results.NIXDCSessionVolumeInfoImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class NIXDCSessionStatusImpl
extends NIXDCResultImpl
implements NIXDCSessionStatus,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIXDCSessionStatusImpl == null ? (class$com$ibm$storage$ess$ni$results$NIXDCSessionStatusImpl = NIXDCSessionStatusImpl.class$("com.ibm.storage.ess.ni.results.NIXDCSessionStatusImpl")) : class$com$ibm$storage$ess$ni$results$NIXDCSessionStatusImpl);
    private static final long serialVersionUID = 1L;
    private static final int LOCATION_OF_NUMBER_OF_SESSIONS_ON_LSS = 2;
    private static final int NUMDEVICES_TO_DEVICEBLOCK_JUMP = 2;
    private static final int INIT_SESSION_ID_POSITION = 4;
    private static final int SESSION_ID_TO_SESSION_STATUS_JUMP = 3;
    private static final int SESSION_STATUS_TO_NUMDEVICES_JUMP = 1;
    private static final int DEVICEBLOCK_TO_PRIMARY_STATUS_JUMP = 3;
    private static final int BYTE_OFFSET_FOR_FLAGS = 3;
    private static final int BIT_OFFSET_FOR_INACCESSIBLE_FLAG = 4;
    private int[] rawData = null;
    private byte[] actualRawData;
    private NIByteArray byteArray;
    private boolean objectsPopulated;
    private Hashtable sessionInfoTable;
    private boolean success;
    private long code;
    private int byteDataLength = 0;
    private boolean dataAvailable = false;
    private NIESSID essID;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIXDCSessionStatusImpl;

    public NIXDCSessionStatusImpl(byte[] byArray, long l, NIESSID nIESSID) {
        super(l == 0L, l);
        this.success = l == 0L;
        this.code = l;
        this.actualRawData = byArray;
        this.essID = nIESSID;
        this.byteDataLength = this.actualRawData.length;
        if (this.byteDataLength > 0 && l == 0L) {
            this.dataAvailable = true;
            this.byteArray = new NIByteArray(this.actualRawData);
        }
        this.objectsPopulated = false;
    }

    private synchronized void populateObjects() {
        if (!this.objectsPopulated) {
            int n = this.getNumSessions();
            this.sessionInfoTable = new Hashtable();
            int n2 = 4;
            int n3 = 0;
            while (n3 < n) {
                try {
                    boolean bl;
                    int n4 = this.byteArray.getByteAsInt(n2 + 1);
                    NISessionID nISessionID = new NISessionID(64, n4);
                    boolean bl2 = !this.byteArray.bitIsSet(n2 += 3, 1) && !this.byteArray.bitIsSet(n2, 2);
                    boolean bl3 = !this.byteArray.bitIsSet(n2, 1) && this.byteArray.bitIsSet(n2, 2);
                    boolean bl4 = bl = this.byteArray.bitIsSet(n2, 1) && !this.byteArray.bitIsSet(n2, 2);
                    int n5 = bl3 ? 1 : (bl ? 2 : 0);
                    int n6 = this.byteArray.getIntValueFromBytes(++n2, n2 + 1);
                    n2 += 2;
                    Hashtable<NIVolumeID, NIXDCSessionVolumeInfoImpl> hashtable = new Hashtable<NIVolumeID, NIXDCSessionVolumeInfoImpl>();
                    int n7 = 0;
                    while (n7 < n6) {
                        int n8 = this.byteArray.getByteAsInt(n2);
                        NILSSID nILSSID = new NILSSID(this.essID, n8);
                        byte by = this.byteArray.extractByte(n2 + 2);
                        int n9 = this.byteArray.getByteAsInt(n2 + 1);
                        NIVolumeID nIVolumeID = new NIVolumeID(nILSSID, n9);
                        boolean bl5 = !this.byteArray.bitIsSet(n2 += 3, 6) && !this.byteArray.bitIsSet(n2, 7);
                        boolean bl6 = !this.byteArray.bitIsSet(n2, 6) && this.byteArray.bitIsSet(n2, 7);
                        boolean bl7 = this.byteArray.bitIsSet(n2, 6) && !this.byteArray.bitIsSet(n2, 7);
                        boolean bl8 = this.byteArray.bitIsSet(n2, 6) && this.byteArray.bitIsSet(n2, 7);
                        boolean bl9 = !this.byteArray.bitIsSet(n2 + 1, 6) && !this.byteArray.bitIsSet(n2 + 1, 7);
                        boolean bl10 = !this.byteArray.bitIsSet(n2 + 1, 6) && this.byteArray.bitIsSet(n2 + 1, 7);
                        boolean bl11 = this.byteArray.bitIsSet(n2 + 1, 6) && !this.byteArray.bitIsSet(n2 + 1, 7);
                        boolean bl12 = this.byteArray.bitIsSet(n2 + 1, 6) && this.byteArray.bitIsSet(n2 + 1, 7);
                        NIXDCSessionVolumeInfoImpl nIXDCSessionVolumeInfoImpl = new NIXDCSessionVolumeInfoImpl(this.success, this.code, nIVolumeID, nISessionID, by, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12);
                        hashtable.put(nIVolumeID, nIXDCSessionVolumeInfoImpl);
                        n2 += 3;
                        ++n7;
                    }
                    NIXDCSessionInfoImpl nIXDCSessionInfoImpl = new NIXDCSessionInfoImpl(this.success, this.code, nISessionID, n5, hashtable);
                    this.sessionInfoTable.put(nISessionID, nIXDCSessionInfoImpl);
                }
                catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
                    logger.throwable((Throwable)nIParameterInvalidServerException);
                    logger.error("this should never happen... XDC_SESSION is invalid");
                }
                ++n3;
            }
            this.objectsPopulated = true;
        }
    }

    public void updateFrom2105Data() {
        if (this.rawData != null) {
            this.actualRawData = new byte[this.rawData.length * 4];
            int n = 0;
            int n2 = 0;
            while (n < this.rawData.length) {
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF000000) >>> 24);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF0000) >>> 16);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF00) >>> 8);
                this.actualRawData[n2++] = (byte)(this.rawData[n] & 0xFF);
                ++n;
            }
            this.rawData = null;
            this.byteDataLength = this.actualRawData.length;
            if (this.byteDataLength > 0 && this.getCode() == 0) {
                this.byteArray = new NIByteArray(this.actualRawData);
                this.dataAvailable = true;
            }
            this.objectsPopulated = false;
        }
    }

    public byte[] getRawData() {
        return this.actualRawData;
    }

    public boolean inaccessibleData() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(3, 4);
        }
        return true;
    }

    public int getNumSessions() {
        if (this.actualRawData.length > 2) {
            return this.byteArray.getByteAsInt(2);
        }
        return 0;
    }

    public Enumeration getXDCSessionInfoEnumeration() {
        if (!this.objectsPopulated) {
            this.populateObjects();
        }
        return this.sessionInfoTable.elements();
    }

    public NIXDCSessionInfo getXDCSessionInfo(NISessionID nISessionID) {
        NIXDCSessionInfo nIXDCSessionInfo = null;
        if (!this.objectsPopulated) {
            this.populateObjects();
        }
        if (this.sessionInfoTable.containsKey(nISessionID)) {
            nIXDCSessionInfo = (NIXDCSessionInfo)this.sessionInfoTable.get(nISessionID);
        }
        return nIXDCSessionInfo;
    }

    public Enumeration getSessionIDs() {
        if (!this.objectsPopulated) {
            this.populateObjects();
        }
        return this.sessionInfoTable.keys();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("XDC Session and Device Status: \n");
            stringBuffer.append(super.toString() + "\n");
            if (this.dataAvailable) {
                if (!this.inaccessibleData()) {
                    stringBuffer.append("Number of Session in the LSS: " + this.getNumSessions() + "\n\n");
                    Enumeration enumeration = this.getSessionIDs();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            NISessionID nISessionID = (NISessionID)enumeration.nextElement();
                            stringBuffer.append((NIXDCSessionInfoImpl)this.getXDCSessionInfo(nISessionID) + "\n");
                        }
                    }
                }
            } else {
                stringBuffer.append("No rawData available or query is not successful");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    public NIESSID getEssID() {
        return this.essID;
    }

    public void setEssID(NIESSID nIESSID) {
        this.essID = nIESSID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

