/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NINetworkPort;
import com.ibm.storage.ess.ni.application.resource.NIStorageServer;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIESSDomainResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageServerID;
import com.ibm.storage.ess.ni.resource.NIESSDomainElementImpl;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAStreamHandler;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class NISAUtilities {
    protected static final int KONA0 = 0;
    protected static final int KONA1 = 1;
    private static String homeDirVarName;
    private static int initialError;
    protected static String md5JarEntry;
    private static ResourceBundle props;
    private static int copyToKona0RetCode;
    private static int copyToKona1RetCode;
    private static Logger log;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$sa$NISAUtilities;

    private static void readLogProperties(LogManager logManager) throws Exception {
        String string;
        FileHandler fileHandler = null;
        ConsoleHandler consoleHandler = null;
        try {
            string = NISAUtilities.getEnvVariable(NISAUtilities.getProperty(homeDirVarName));
            if (null == string) {
                initialError = -1098383330;
                throw new Exception("SA failed to find variable - " + NISAUtilities.getProperty(homeDirVarName));
            }
        }
        catch (IOException iOException) {
            initialError = -1098383330;
            throw iOException;
        }
        String string2 = NISAUtilities.getProperty("SA_LOG_NAME");
        String string3 = NISAUtilities.getProperty("SA_LOGS_DIR");
        String string4 = string + File.separator + string3 + File.separator + string2;
        int n = NISAUtilities.getIntProperty("LOG_FILE_LIMIT");
        int n2 = NISAUtilities.getIntProperty("LOG_FILES_COUNT");
        boolean bl = "true" == NISAUtilities.getProperty("LOG_APPEND");
        String string5 = NISAUtilities.getProperty("LOG_FILE_FORMATER");
        String string6 = NISAUtilities.getProperty("LOG_FILE_LEVEL");
        String string7 = NISAUtilities.getProperty("CONSOLE_LOG_LEVEL");
        try {
            consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(0 == string7.compareTo("OFF") ? Level.OFF : (0 == string7.compareTo("ALL") ? Level.ALL : (0 == string7.compareTo("INFO") ? Level.INFO : (0 == string7.compareTo("SEVERE") ? Level.SEVERE : (0 == string7.compareTo("WARNING") ? Level.WARNING : (0 == string7.compareTo("CONFIG") ? Level.CONFIG : (0 == string7.compareTo("FINE") ? Level.FINE : (0 == string7.compareTo("FINER") ? Level.FINER : Level.FINEST))))))));
        }
        catch (Exception exception) {
            initialError = -1098383315;
            throw exception;
        }
        try {
            fileHandler = new FileHandler(string4, n, n2, bl);
            if (string5.equals("xml")) {
                fileHandler.setFormatter(new XMLFormatter());
            } else {
                fileHandler.setFormatter(new SimpleFormatter());
            }
            fileHandler.setLevel(0 == string6.compareTo("INFO") ? Level.INFO : (0 == string6.compareTo("ALL") ? Level.ALL : (0 == string6.compareTo("OFF") ? Level.OFF : (0 == string6.compareTo("SEVERE") ? Level.SEVERE : (0 == string6.compareTo("WARNING") ? Level.WARNING : (0 == string6.compareTo("CONFIG") ? Level.CONFIG : (0 == string6.compareTo("FINE") ? Level.FINE : (0 == string6.compareTo("FINER") ? Level.FINER : Level.FINEST))))))));
        }
        catch (Exception exception) {
            initialError = -1098383315;
            throw exception;
        }
        try {
            log.setUseParentHandlers(false);
            log.addHandler(consoleHandler);
            log.addHandler(fileHandler);
        }
        catch (Exception exception) {
            initialError = -1098383315;
            throw exception;
        }
        NISAUtilities.getLog().info("NISAUtilities.readLogProperties() - New NISA Log Started \n");
    }

    public static Logger getLog() {
        return log;
    }

    public static NISAResult testConnection(NIESSID nIESSID, NIServices nIServices, int n) {
        NISAUtilities.getLog().info("testConnection() - strat essId=" + nIESSID + " timeout=" + n);
        long l = 60000L;
        NIESSDomainElementImpl nIESSDomainElementImpl = new NIESSDomainElementImpl(nIESSID);
        NIESSDomainResult nIESSDomainResult = null;
        int n2 = 2;
        int n3 = 0;
        try {
            nIESSDomainResult = nIServices.getInitialConfigurationService().testConnection(nIESSDomainElementImpl);
            n2 = nIESSDomainResult.getCode();
            NISAUtilities.getLog().info("testConnection() - itr=" + n3 + " current timeout=" + n + " rc=" + n2);
        }
        catch (NIServerException nIServerException) {
            NISAUtilities.getLog().warning("testConnection() - NIServerException:\n" + NISAUtilities.getExceptionStackTrace(nIServerException));
        }
        while (n > 0 && 2 == n2) {
            try {
                Thread.sleep(l);
                nIESSDomainResult = nIServices.getInitialConfigurationService().testConnection(nIESSDomainElementImpl);
                n2 = nIESSDomainResult.getCode();
                NISAUtilities.getLog().info("testConnection() - itr=" + ++n3 + " current timeout=" + --n + " rc=" + n2);
            }
            catch (NIServerException nIServerException) {
                NISAUtilities.getLog().warning("testConnection() - NIServerException:\n" + NISAUtilities.getExceptionStackTrace(nIServerException));
            }
            catch (InterruptedException interruptedException) {
                NISAUtilities.getLog().warning("testConnection() - InterruptedException:\n" + NISAUtilities.getExceptionStackTrace(interruptedException));
            }
        }
        int n4 = 2 == n2 ? -1098383293 : 0;
        NISAUtilities.getLog().info("testConnection() - finish RC=" + Integer.toHexString(n4));
        return new NISAResult(0 == n4, n4);
    }

    protected static boolean linuxOs() {
        return System.getProperty("os.name").toLowerCase().indexOf("linux") > -1;
    }

    protected static boolean winOs() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") > -1;
    }

    protected static int sysExec(String string, String string2, String string3, File file, File file2) {
        int n;
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2;
        NISAUtilities.getLog().info("sysExec() - start cmd=" + string);
        try {
            fileOutputStream2 = null == file ? null : new FileOutputStream(file);
            fileOutputStream = null == file2 ? null : new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            NISAUtilities.getLog().warning("sysExec() - redirect file not found. the exception is: \n" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            return -1098383339;
        }
        String string4 = string + " " + string2;
        Process process = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(string4);
            NISAStreamHandler nISAStreamHandler = new NISAStreamHandler(process.getErrorStream(), "ERROR from " + string, fileOutputStream);
            NISAStreamHandler nISAStreamHandler2 = new NISAStreamHandler(process.getInputStream(), "OUTPUT from " + string, fileOutputStream2);
            nISAStreamHandler.start();
            nISAStreamHandler2.start();
            if (null != string3) {
                NISAUtilities.getLog().info("sysExec() - response=" + string3);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                bufferedWriter.write(string3);
                bufferedWriter.close();
            }
            nISAStreamHandler2.join();
            nISAStreamHandler.join();
            n = process.waitFor();
            NISAUtilities.getLog().info("sysExec() exitValue=" + n);
        }
        catch (Throwable throwable) {
            NISAUtilities.getLog().warning("sysExec() - Failed - intrupted - the exception is: \n " + NISAUtilities.getExceptionStackTrace((Exception)throwable));
            if (null != process) {
                NISAUtilities.getLog().warning("sysExec() - kill the failed process ");
                process.destroy();
            }
            n = -1098383344;
        }
        NISAUtilities.getLog().info("sysExec() - finish - rc=" + n);
        return n;
    }

    public static int ourExec(String string, String string2, String string3, String string4) throws FileNotFoundException {
        int n;
        FileOutputStream fileOutputStream = null;
        String string5 = string + " " + string2;
        NISAUtilities.getLog().info("NISAUtility.ourExec() start - the command is " + string);
        if (null != string4) {
            fileOutputStream = new FileOutputStream(string4);
        }
        Process process = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(string5);
            NISAStreamHandler nISAStreamHandler = new NISAStreamHandler(process.getErrorStream(), "ERROR from " + string);
            NISAStreamHandler nISAStreamHandler2 = new NISAStreamHandler(process.getInputStream(), "OUTPUT from " + string, fileOutputStream);
            nISAStreamHandler.start();
            nISAStreamHandler2.start();
            if (null != string3) {
                NISAUtilities.getLog().info("NISAUtilities.ourExec() - interactive mode - the answer = " + string3);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                bufferedWriter.write(string3);
                bufferedWriter.close();
            }
            nISAStreamHandler2.join();
            n = process.waitFor();
            NISAUtilities.getLog().info("ExitValue: " + n);
        }
        catch (Throwable throwable) {
            NISAUtilities.getLog().warning("NISAUtility.ourExec() - Failed - intrupted - the exception is: \n " + NISAUtilities.getExceptionStackTrace((Exception)throwable));
            if (null != process) {
                NISAUtilities.getLog().warning("NISAUtilities.ourExec() - kill the failed process ");
                process.destroy();
            }
            int n2 = -1098383344;
            return n2;
        }
        NISAUtilities.getLog().info("NISAUtility.ourExec() - finish - return code = " + n);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getExecOutput(String string, String string2, String string3, String string4) {
        int n;
        Process process = null;
        InputStream inputStream = null;
        String string5 = null;
        String string6 = string + " " + string2;
        NISAUtilities.getLog().info("getExecOutput() - start cmd= " + string6 + " header=" + string4);
        try {
            Closeable closeable;
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(string6);
            NISAStreamHandler nISAStreamHandler = new NISAStreamHandler(process.getErrorStream(), "ERROR from " + string);
            inputStream = process.getInputStream();
            NISAStreamHandler nISAStreamHandler2 = new NISAStreamHandler(inputStream, "OUTPUT from " + string);
            nISAStreamHandler.start();
            if (null != string3) {
                NISAUtilities.getLog().info("getExecOutput() - interactive mode - the answer = " + string3);
                closeable = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                ((Writer)closeable).write(string3);
                ((BufferedWriter)closeable).close();
            }
            closeable = new BufferedReader(new InputStreamReader(inputStream));
            if (null == string4) {
                string5 = ((BufferedReader)closeable).readLine();
                NISAUtilities.getLog().info("getExecOutput(): no header, output=" + string5);
            } else {
                String string7;
                while (null != (string7 = ((BufferedReader)closeable).readLine())) {
                    NISAUtilities.getLog().info("getExecOutput(): header=" + string4 + "; line=" + string7);
                    if (!string7.matches(".*" + string4 + ".*")) continue;
                    string5 = string7;
                    break;
                }
            }
            nISAStreamHandler2.start();
            nISAStreamHandler2.join();
            nISAStreamHandler.join();
            n = process.waitFor();
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("getExecOutput() - Failed - intrupted " + exception.getMessage() + "\n the exeption is:\n" + NISAUtilities.getExceptionStackTrace(exception));
            n = -1098383344;
        }
        if (0 == n) {
            NISAUtilities.getLog().info("getExecOutput() - rc=0 output=" + string5);
            return string5;
        }
        NISAUtilities.getLog().warning("getExecOutput() - fail rc= " + n);
        return string5;
    }

    public static String getProperty(String string) {
        return props.getString(string).trim();
    }

    protected static int getIntProperty(String string) {
        String string2 = props.getString(string);
        string2 = string2.trim();
        return Integer.parseInt(string2);
    }

    protected static int getCopyToKona0RetCode() {
        return copyToKona0RetCode;
    }

    protected static int getCopyToKona1RetCode() {
        return copyToKona1RetCode;
    }

    protected static void setCopyToKona0RetCode(int n) {
        copyToKona0RetCode = n;
    }

    protected static void setCopyToKona1RetCode(int n) {
        copyToKona1RetCode = n;
    }

    public static boolean extractJarEntry(JarEntry jarEntry, JarFile jarFile, String string) {
        NISAUtilities.getLog().info("NISAUtility.extractJarEntry() start: jarEntry = " + jarEntry.getName() + " jarFile - " + jarFile.getName() + " to destFile = " + string);
        try {
            int n;
            if (jarEntry.isDirectory()) {
                NISAUtilities.getLog().warning("finish extractJarEntry - the JarEntry " + jarEntry.getName() + "is a directory - Fail");
                return false;
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[1024];
            while (-1 != (n = inputStream.read(byArray))) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                messageDigest.update(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)bufferedOutputStream).close();
            md5JarEntry = NISAUtilities.byte2HexStr(messageDigest.digest());
            NISAUtilities.getLog().info("md5sum() - md5= " + md5JarEntry + " name=" + jarEntry.getName());
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISAUtility.extractJarEntry finish - Exception :");
            NISAUtilities.getExceptionStackTrace(exception);
            return false;
        }
        NISAUtilities.getLog().info("NISAUtility.extractJarEntry  finish - OK ");
        return true;
    }

    public static File getBundleTar(JarFile jarFile, String string, String string2) {
        File file;
        NISAUtilities.getLog().info("NISAUtility.getBundleTar() start: bundleFile = " + String.valueOf(jarFile) + " tarEntry = " + string + " the destFile = " + string2);
        JarEntry jarEntry = jarFile.getJarEntry(string);
        if (null == jarEntry) {
            NISAUtilities.getLog().warning("NISAUtility.getBundleTar() - Fail, tarFile " + string + " not found");
            return null;
        }
        if (NISAUtilities.extractJarEntry(jarEntry, jarFile, string2) && (file = new File(string2)).isFile()) {
            NISAUtilities.getLog().info("NISAUtility.getBundleTar() finish - tarFile = " + file.getAbsolutePath());
            return file;
        }
        NISAUtilities.getLog().warning("NISAUtility.getBundleTar() finish - Fail, tarFile " + string + " not found");
        return null;
    }

    public static String getExceptionStackTrace(Exception exception) {
        NISAUtilities.getLog().info("NISAUtility.getExceptionStackTrace() start ");
        String string = exception.toString();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            int n = 0;
            while (n < stackTraceElementArray.length - 1) {
                string = string + stackTraceElementArray[n].toString() + System.getProperty("line.separator");
                ++n;
            }
        }
        if (stackTraceElementArray.length > 0) {
            string = string + stackTraceElementArray[stackTraceElementArray.length - 1].toString();
        }
        NISAUtilities.getLog().info("NISAUtility.getExceptionStackTrace() finish");
        return string;
    }

    public static String getEnvVariable(String string) throws IOException {
        String string2;
        Handler[] handlerArray = log.getHandlers();
        boolean bl = true;
        if (0 == handlerArray.length) {
            bl = false;
        }
        if (bl) {
            NISAUtilities.getLog().info("NISAUtility.getEnvVariable() start - looking for the env var - " + string);
        }
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        Properties properties = new Properties();
        String string3 = null;
        if (NISAUtilities.linuxOs()) {
            string3 = "env";
        } else if (NISAUtilities.winOs()) {
            string3 = "cmd.exe /c set";
        } else {
            if (bl) {
                NISAUtilities.getLog().warning("NISAUtility.getEnvVariable() Fail - unknow OS");
            }
            return null;
        }
        process = runtime.exec(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(61);
            String string4 = string2.substring(0, n);
            String string5 = string2.substring(n + 1);
            properties.setProperty(string4, string5);
        }
        String string6 = (String)properties.get(string);
        if (null == string6) {
            if (bl) {
                NISAUtilities.getLog().warning("NISAUtility.getEnvVariable() finish - Fail - can not found the environment variable " + string);
            }
        } else if (bl) {
            NISAUtilities.getLog().info("NISAUtility.getEnvVariable() finish - OK - the value for " + string + " = " + string6);
        }
        return string6;
    }

    public static File getSentDir() {
        log.info("NISAUtility.getSentDir() start");
        String string = NISAUtilities.getProperty("FTP2IBM_SENT_DIR_NAME");
        File file = NISAUtilities.getSend2IBMDir();
        File file2 = new File(file, string);
        if (null == file2 || !file2.isDirectory()) {
            log.info("creating sent dir " + file2.getAbsolutePath());
            if (!file2.mkdir()) {
                log.warning("Fail to create dir " + file2.getAbsolutePath());
                return null;
            }
        }
        log.info(".getSentDir sentDir path: " + file2.getAbsolutePath());
        log.info("NISAUtilities.getSentDir Finish - OK");
        return file2;
    }

    public static boolean isValidDir(String string) {
        NISAUtilities.getLog().info("NISAUtility.isValidDir() start - check " + string);
        if (null == string) {
            NISAUtilities.getLog().warning("NISAUtility.isValidDir() Fail - the input dir name is NULL");
            return false;
        }
        if (!new File(string).isDirectory()) {
            NISAUtilities.getLog().warning("NISAUtility.isValidDir() Fail - the " + string + " is not a directory");
            return false;
        }
        NISAUtilities.getLog().info("NISAUtility.isValidDir() finish - OK - " + string + " is valid dir");
        return true;
    }

    protected static NIStorageServer[] getKonasServers(NIESSID nIESSID, NIServices nIServices) {
        NIStorageServer nIStorageServer;
        NIStorageServer nIStorageServer2;
        NISAUtilities.getLog().info("NISAUtilities.getKonasServers() start");
        NIPhysicalConfigurationService nIPhysicalConfigurationService = nIServices.getPhysicalConfigurationService();
        try {
            NIConfigQueryResult nIConfigQueryResult = nIPhysicalConfigurationService.getStorageServers(nIESSID);
            if (!nIConfigQueryResult.isSuccessful()) {
                NISAUtilities.getLog().warning("NISAUtilities.getKonasServers() finish  - Failed in Essni getStorageServers ");
                return null;
            }
            nIStorageServer2 = (NIStorageServer)nIConfigQueryResult.getResourceList().get(0);
            nIStorageServer = (NIStorageServer)nIConfigQueryResult.getResourceList().get(1);
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISAUtilities.getKonasServers() - Failed - the Exception is : \n" + NISAUtilities.getExceptionStackTrace(exception));
            return null;
        }
        NIStorageServer[] nIStorageServerArray = null;
        int n = nIStorageServer2.getServer();
        int n2 = nIStorageServer.getServer();
        if (n == 0 && n2 == 1) {
            nIStorageServerArray = new NIStorageServer[]{nIStorageServer2, nIStorageServer};
        } else if (n == 1 && n2 == 0) {
            nIStorageServerArray = new NIStorageServer[]{nIStorageServer, nIStorageServer2};
        } else {
            NISAUtilities.getLog().warning("NISAUtilities.getKonasServers() - Fail - At least one of the server value in the DB isnt correct: \n line0 =  " + n + " & line1 = " + n2);
            return null;
        }
        NISAUtilities.getLog().info("NISAUtilities.getKonasServers() finish  - OK - the values are \n for kona 0: " + nIStorageServerArray[0].getServer() + "\nand for kona 1: " + nIStorageServerArray[1].getServer());
        return nIStorageServerArray;
    }

    protected static String getPassword(NIESSID nIESSID, NIServices nIServices, int n) {
        String string;
        NISAUtilities.getLog().info("NISAUtilities.getPassword() start for kona " + n);
        NIStorageServer[] nIStorageServerArray = NISAUtilities.getKonasServers(nIESSID, nIServices);
        if (null == nIStorageServerArray) {
            NISAUtilities.getLog().warning("NISAUtilities.getPassword() finish  - Failed in getKonasServers (Essni getStorageServers) for kona -" + n);
            return null;
        }
        try {
            NIPhysicalConfigurationService nIPhysicalConfigurationService = nIServices.getPhysicalConfigurationService();
            NIStorageServerID nIStorageServerID = (NIStorageServerID)nIStorageServerArray[n].getID();
            NIConfigQueryResult nIConfigQueryResult = nIPhysicalConfigurationService.getPassword(nIStorageServerID);
            NISAUtilities.getLog().info("NISAUtilities.getPassword() - finish get the pswd from the kona  - now verify the results:");
            if (!nIConfigQueryResult.isSuccessful()) {
                NISAUtilities.getLog().warning("NISAUtilities.getPassword() finish  - Failed in Essni getPassword for kona " + n);
                return null;
            }
            NISAUtilities.getLog().info("NISAUtilities.getPassword() - essni - success ");
            string = nIConfigQueryResult.getResourceList().get(0).toString();
        }
        catch (Throwable throwable) {
            NISAUtilities.getLog().warning("NISAUtilities.getPassword() - Failed - in Essni physical.getPassword the Exception is : \n" + NISAUtilities.getExceptionStackTrace((Exception)throwable));
            return null;
        }
        if (null == string) {
            NISAUtilities.getLog().warning("NISAUtilities.getPassword() finish  - Failed the password is null for kona " + n);
            return null;
        }
        NISAUtilities.getLog().info("NISAUtilities.getPassword() finish - OK  for kona " + n);
        return string;
    }

    protected static String[] getKonasIP(NIESSID nIESSID, NIServices nIServices) {
        NISAUtilities.getLog().info("NISAUtilities.getKonasIP() - start");
        String[] stringArray = new String[2];
        boolean bl = NISAUtilities.getKonasExternalIP(nIESSID, stringArray);
        if (!bl) {
            NIPhysicalConfigurationService nIPhysicalConfigurationService = nIServices.getPhysicalConfigurationService();
            try {
                NIConfigQueryResult nIConfigQueryResult = nIPhysicalConfigurationService.getNetworkPorts(nIESSID);
                if (!nIConfigQueryResult.isSuccessful()) {
                    NISAUtilities.getLog().warning("NISAUtilities.getKonasIP() - finish - fail in ESSNI command getNetworkPorts ");
                    return null;
                }
                List list = nIConfigQueryResult.getResourceList();
                NINetworkPort[] nINetworkPortArray = list.toArray(new NINetworkPort[0]);
                int n = 0;
                while (n < nINetworkPortArray.length) {
                    int n2 = ((NIIOPortID)nINetworkPortArray[n].getID()).getInterfaceIdentifier() >> 8 & 0x1F;
                    if (n2 == 0) {
                        stringArray[0] = nINetworkPortArray[n].getIPAddress().getHostAddress();
                        log.info("getKonasIP() - kona 0 = " + stringArray[0]);
                    }
                    if (n2 == 1) {
                        stringArray[1] = nINetworkPortArray[n].getIPAddress().getHostAddress();
                        log.info("getKonasIP() - kona 1 = " + stringArray[1]);
                    }
                    ++n;
                }
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (null == stringArray[n3]) {
                        log.warning("getKonasIP() - kona " + n3 + " = " + stringArray[0] + " exit with null");
                        return null;
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("NISAUtilities.getKonasIP() - Failed - in Essni getIPAddress the Exception is : \n" + NISAUtilities.getExceptionStackTrace(exception));
                return null;
            }
        }
        NISAUtilities.getLog().info("NISAUtilities.getKonasIP() - finish - OK");
        return stringArray;
    }

    private static boolean getKonasExternalIP(NIESSID nIESSID, String[] stringArray) {
        String string;
        NISAUtilities.getLog().info("NISAUtilities.getKonasExternalIP() - start");
        if (stringArray.length < 2) {
            log.warning("NISAUtilities.getKonasExternalIP - Fail, konasIPOut length < 2, length= " + stringArray.length);
            return false;
        }
        String string2 = NISAUtilities.getProperty("REEF_HOME_DIR_ENV_NAME");
        String string3 = NISAUtilities.getProperty("EXTERNAL_IP_LOCATION");
        String string4 = NISAUtilities.getProperty("EXTERNAL_IP_PROPERTIES");
        try {
            string = NISAUtilities.getEnvVariable(string2);
        }
        catch (IOException iOException) {
            log.warning("NISAUtilities.getKonasExternalIP - Fail to get the environment variable, the Exception is :\n" + NISAUtilities.getExceptionStackTrace(iOException));
            return false;
        }
        if (null == string) {
            log.warning("NISAUtilities.getKonasExternalIP - Fail, can't find the directory name " + string + " in the system variables list");
            return false;
        }
        string4 = string + File.separator + string3 + File.separator + string4;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string4));
            properties.load(fileInputStream);
            String string5 = nIESSID.toString() + "-0";
            String string6 = nIESSID.toString() + "-1";
            stringArray[0] = properties.getProperty(string5);
            stringArray[1] = properties.getProperty(string6);
            if (stringArray[0] != null && stringArray[1] != null) {
                stringArray[0] = stringArray[0].trim();
                stringArray[1] = stringArray[1].trim();
                log.info("NISAUtilities.getKonasExternalIP - Finish - external IPs found c0=" + stringArray[0] + " c1=" + stringArray[1]);
                return true;
            }
            log.warning("NISAUtilities.getKonasExternalIP - Finish - No corresponding external ips found for essId=" + nIESSID);
            return false;
        }
        catch (IOException iOException) {
            log.warning("NISAUtilities.getKonasExternalIP - No properties file found or could not be opened, exiting");
            return false;
        }
    }

    public static String getLogFileName() {
        return NISAUtilities.getProperty("java.util.logging.FileHandler.pattern");
    }

    /*
     * Unable to fully structure code
     */
    public static int addFromFile(LinkedList var0, String var1_1) throws IOException {
        NISAUtilities.log.info("NISAUtilities.addFromFile() - start - read from file : " + var1_1);
        var2_2 = new BufferedReader(new FileReader(var1_1));
        if (null != var2_2) ** GOTO lbl8
        NISAUtilities.log.info("NISAUtilities.addFromFile() - finish - Fail to open the file " + var1_1);
        return 1;
lbl-1000:
        // 1 sources

        {
            var0.add(var3_3);
lbl8:
            // 2 sources

            ** while (null != (var3_3 = var2_2.readLine()))
        }
lbl9:
        // 1 sources

        NISAUtilities.log.info("NISAUtilities.addFromFile() - finish - OK");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String[] fileList2array(File file) {
        log.info("fileList2array() - start. fileList=" + file);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            if (null == bufferedReader) {
                log.warning("fileList2array() - Fail to open the file " + file);
                return null;
            }
            while (true) {
                String string;
                if (null == (string = bufferedReader.readLine())) {
                    bufferedReader.close();
                    return NISAUtilities.arrayList2Arry(arrayList);
                }
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            log.warning("fileList2array() - Fail. The Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            return null;
        }
    }

    public static int createZip(String string, File file) throws IOException {
        log.info("NISAUtilities.createZip() - start write to zip: " + string + ", srcDir = " + file.getAbsolutePath());
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        if (0 != NISAUtilities.zipDir(zipOutputStream, file, file)) {
            log.warning("createZip() - fail to zip " + file);
            zipOutputStream.close();
            return -1098383332;
        }
        zipOutputStream.close();
        log.info("NISAUtilities.createZip() - finish write to zip: " + string);
        return 0;
    }

    private static int zipDir(ZipOutputStream zipOutputStream, File file, File file2) {
        log.info("zipDir start - Dir= " + file);
        byte[] byArray = new byte[1024];
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                NISAUtilities.zipDir(zipOutputStream, fileArray[n], file2);
            } else {
                try {
                    int n2;
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(fileArray[n]));
                    zipOutputStream.putNextEntry(new ZipEntry(fileArray[n].getAbsolutePath().substring(file2.getAbsolutePath().length() + 1)));
                    while ((n2 = dataInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    log.warning("zipDir() - Fail to zip " + fileArray[n] + " the Exception is:\n" + NISAUtilities.getExceptionStackTrace(exception));
                    return -1;
                }
                log.info("zipDir() - zipped " + fileArray[n]);
            }
            ++n;
        }
        log.info("zipDir() - finish dir " + file);
        return 0;
    }

    protected static int delFiles(File file, List list) {
        log.info("NISAUtilities.delFiles() - start delete from dir: " + file);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file2 = new File(file, new File(iterator.next().toString()).getName());
            if (!file2.exists()) continue;
            if (file2.delete()) {
                log.info("NISAUtilities.delFiles() - Success to delete file: " + file2.getName());
                continue;
            }
            log.info("NISAUtilities.delFiles() - Fail to delete file: " + file2.getName());
        }
        log.info("NISAUtilities.delFiles() - finish OK");
        return 0;
    }

    protected static int editFilesList(String string, String string2, String string3) throws IOException {
        String string4;
        log.info("NISAUtilities.editFilesList() Strat args = " + string + " " + string2 + " " + string3);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        if (null == bufferedReader) {
            log.info("NISAUtilities.editFilesList() - finish - Fail to open the file " + string);
            return -1098383335;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
        if (null == bufferedWriter) {
            log.info("NISAUtilities.editFilesList() - finish - Fail to open the file " + string2);
            return -1098383335;
        }
        boolean bl = true;
        while (null != (string4 = bufferedReader.readLine())) {
            if (0 == string4.length()) continue;
            int n = string4.indexOf(46);
            string4 = string4.substring(0, n) + string3;
            if (bl) {
                bl = false;
            } else {
                bufferedWriter.newLine();
            }
            bufferedWriter.write(string4);
        }
        bufferedWriter.close();
        bufferedReader.close();
        log.info("NISAUtilities.editFilesList() - finish - OK");
        return 0;
    }

    protected static boolean delDir(File file) {
        log.info("NISAUtilities.delDir Start - for dir = " + file.getAbsolutePath());
        if (file.isDirectory()) {
            log.info("NISAUtilities.delDir - the " + file.getAbsolutePath() + " is a directory - try to delete its sons");
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    log.info("NISAUtilities.delDir - son num " + n + " is a directory " + fileArray[n].getName() + " call to delDir()");
                    NISAUtilities.delDir(fileArray[n]);
                } else {
                    if (!fileArray[n].delete()) {
                        log.warning("NISAUtilities.delDir Fail to delete the file " + fileArray[n].getAbsolutePath());
                        return false;
                    }
                    log.info("NISAUtilities.delDir - file - " + fileArray[n].getName() + " deleted - Ok");
                }
                ++n;
            }
        }
        if (!file.delete()) {
            log.warning("NISAUtilities.delDir Fail to delete the in put dir " + file.getAbsolutePath());
            return false;
        }
        log.info("NISAUtilities.delDir - Finish to delete directory - " + file.getAbsolutePath());
        return true;
    }

    public static NISAResult ftpFile2ibm(File file) {
        if (0 != initialError) {
            return new NISAResult(false, initialError);
        }
        log.info("ftpFile2ibm(srcFile=" + file.getAbsolutePath() + ") - Start");
        NISAResult nISAResult = new NISAResult();
        if (!file.isFile()) {
            log.warning("ftpFile2ibm() - Failed " + file.getName() + " not a regular file - can not FTP");
            nISAResult.setCode(-1098383358);
            return nISAResult;
        }
        nISAResult = NISAUtilities.ftp2ibm(file);
        if (!nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("ftpFile2ibm(f) - fail in ftp2ibm(..)");
            return nISAResult;
        }
        if (null == nISAResult.getCopiedFiles() || 0 == nISAResult.getCopiedFiles().length) {
            NISAUtilities.getLog().warning("ftpFile2ibm(f) - no file was copied ");
            return new NISAResult(false, -1098383331);
        }
        int n = NISAUtilities.manageSentDir();
        if (0 != n) {
            log.warning("ftpFile2ibm(f) - fail to manage the sentDir. RC - " + n);
        } else {
            log.info("ftpFile2ibm(f) - finish OK");
        }
        return nISAResult;
    }

    public static NISAResult ftpFile2ibm(File file, int n) {
        NISAResult nISAResult;
        if (0 != initialError) {
            return new NISAResult(false, initialError);
        }
        log.info("ftpFile2ibm(srcFile=" + file.getAbsolutePath() + " retry=" + n + ") - start");
        int n2 = 1;
        do {
            NISAUtilities.getLog().info("ftpFile2ibm() - tryNum=" + n2);
            nISAResult = NISAUtilities.ftpFile2ibm(file);
            ++n2;
        } while (!nISAResult.isSuccessful() && n-- > 0);
        log.info("ftpFile2ibm(srcFile=" + file.getName() + " retry) RC=" + Integer.toHexString(nISAResult.getCode()));
        return nISAResult;
    }

    private static NISAResult ftp2ibm(File file) {
        Object object;
        File[] fileArray;
        boolean bl;
        File file2;
        log.info("NISAUtilities.ftp2ibm - Start, the srcDir = " + file.getAbsolutePath());
        String string = NISAUtilities.getProperty("FTP2IBM_DEST_URL");
        String string2 = NISAUtilities.getProperty("FTP2IBM_DEST_LOCATION");
        NISAResult nISAResult = new NISAResult();
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            file2 = NISAUtilities.getTmpFile();
        }
        catch (Exception exception) {
            log.warning("NISAUtilities.ftp2ibm - Fail - " + exception.getMessage());
            nISAResult.setCode(1);
            return nISAResult;
        }
        String string3 = NISAUtilities.getSend2IBMDir().getPath() + File.separator + NISAUtilities.getProperty("FTP2IBM_SENT_DIR_NAME");
        boolean bl2 = bl = string3 == file.getPath();
        if (!bl) {
            fileArray = NISAUtilities.getSentDir();
            if (null == fileArray) {
                log.warning("ftp2ibm() - fail to get the sentDir= " + fileArray);
                nISAResult.setCode(-1098383326);
                return nISAResult;
            }
            log.info("sent dir = " + fileArray.getAbsolutePath());
        }
        fileArray = null;
        if (!file.isDirectory()) {
            fileArray = new File[]{file};
        } else {
            log.info("Input is a directory, not a file \n");
            fileArray = file.listFiles();
        }
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].isFile()) {
                log.warning("NISAUtilities.ftp2ibm() - the file " + fileArray[n].getName() + " not a regular file - can not FTP");
            } else {
                object = new File(NISAUtilities.getSendingDir(), fileArray[n].getName());
                if (NISAUtilities.renameFile(fileArray[n], (File)object)) {
                    fileArray[n] = object;
                }
                if (0 == NISAUtilities.ftpFile(fileArray[n], string, string2, file2)) {
                    log.info("NISAUtilities.ftp2ibm() - success ftp of " + fileArray[n]);
                    if (linkedList.add(fileArray[n].getName())) {
                        log.info("NISAUtilities.ftp2ibm() - add " + fileArray[n].getName() + " to transferred list");
                        NISAUtilities.renameFile(fileArray[n], new File(NISAUtilities.getSentDir(), fileArray[n].getName()));
                    } else {
                        log.warning("NISAUtilities.ftp2ibm() - Fail to add to the transferred list " + fileArray[n]);
                    }
                } else {
                    log.warning("NISAUtilities.ftp2ibm() - Fail ftp of " + fileArray[n]);
                    NISAUtilities.renameFile(fileArray[n], new File(NISAUtilities.getSend2IBMDir(), fileArray[n].getName()));
                }
            }
            ++n;
        }
        if (linkedList.isEmpty()) {
            log.warning("NISAUtilities.ftp2ibm() - No files are transferred to the destination ");
        } else {
            object = new String[linkedList.size()];
            linkedList.toArray((T[])object);
            nISAResult.setCopiedFiles((String[])object);
        }
        if (file2.delete()) {
            log.info("NISAUtilities.ftp2ibm() - delete the ftpCmdFile " + file2.getAbsolutePath());
        } else {
            log.warning("NISAUtilities.ftp2ibm() - fail to delete the ftpCmdFile " + file2.getAbsolutePath());
        }
        nISAResult.setSuccessful(true);
        log.info("NISAUtilities.ftp2ibm - Finish - OK ");
        return nISAResult;
    }

    public static File getTmpFile() throws Exception {
        String string = null;
        try {
            string = NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME"));
        }
        catch (IOException iOException) {
            throw new Exception("exception: \n" + NISAUtilities.getExceptionStackTrace(iOException));
        }
        if (null == string) {
            throw new Exception("can't find the environment variable " + NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME"));
        }
        String string2 = Long.toString(Calendar.getInstance().getTimeInMillis());
        return new File(string + File.separator + string2);
    }

    public static NISAResult ftp2ibm() {
        if (0 != initialError) {
            return new NISAResult(false, initialError);
        }
        NISAResult nISAResult = new NISAResult();
        String string = NISAUtilities.getProperty("FTP2IBM_DEST_URL");
        String string2 = null;
        try {
            string2 = NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME"));
        }
        catch (IOException iOException) {
            log.warning("getEnvVariable - Fail - exception : \n" + NISAUtilities.getExceptionStackTrace(iOException));
            nISAResult.setCode(1);
            return nISAResult;
        }
        if (null == string2) {
            log.warning("ftp2ibm - Fail - cann't find the environment variable " + NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME"));
            nISAResult.setCode(-1098383330);
            return nISAResult;
        }
        String string3 = Long.toString(Calendar.getInstance().getTimeInMillis());
        File file = new File(string2 + File.separator + string3);
        log.info("ftp2ibm() - Start: ftp from send2IBM dir ");
        File file2 = NISAUtilities.getSend2IBMDir();
        if (null == file2) {
            log.warning("ftp2ibm() - Fail to get the send2IBMDir");
            nISAResult.setCode(-1098383325);
            return nISAResult;
        }
        if (0 != NISAUtilities.ftpFile(null, string, null, file)) {
            log.warning("ftp2ibm() - Fail chkConnect to ftp server \n");
            if (file.delete()) {
                log.info("ftp2ibm() - delete the ftpCmdFile " + file.getAbsolutePath());
            } else {
                log.warning("ftp2ibm() - fail to delete the ftpCmdFile " + file.getAbsolutePath());
            }
            nISAResult.setCode(-1098383323);
            return nISAResult;
        }
        log.info("ftp2ibm() - Success chkConnect to ftp server \n");
        if (file.delete()) {
            log.info("ftp2ibm() - delete the ftpCmdFile " + file.getAbsolutePath());
        } else {
            log.warning("ftp2ibm() - fail to delete the ftpCmdFile " + file.getAbsolutePath());
        }
        nISAResult = NISAUtilities.ftp2ibm(file2);
        if (!nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("ftp2ibm() - fail");
            return nISAResult;
        }
        int n = NISAUtilities.manageSentDir();
        if (0 != n) {
            log.warning("ftp2ibm() - fail to manage the sentDir. RC - " + n);
        } else {
            log.info("ftp2ibm() - finish OK");
        }
        return nISAResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ftpFile(File file, String string, String string2, File file2) {
        int n;
        File file3;
        String string3;
        String string4;
        block46: {
            String string5;
            String string6;
            block45: {
                string6 = NISAUtilities.getProperty("FTP2IBM_LINUX_SCRIPT");
                string5 = NISAUtilities.getProperty("FTP2IBM_WINDOWS_SCRIPT");
                PrintWriter printWriter = null;
                if (NISAUtilities.winOs() || NISAUtilities.linuxOs()) {
                    try {
                        try {
                            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
                            printWriter.println("open " + string);
                            if (NISAUtilities.linuxOs()) {
                                printWriter.println("user anonymous anonymous");
                            }
                            if (null != string2) {
                                printWriter.println("cd \"" + string2 + "\"");
                            }
                            printWriter.println("binary");
                            if (null != file) {
                                printWriter.println("mput \"" + file.getAbsolutePath() + "\"");
                                printWriter.println("quote xcrc " + file.getName());
                            }
                            printWriter.println("bye");
                        }
                        catch (Exception exception) {
                            NISAUtilities.getLog().warning("ftpFile() - Failed, create ftp cmd file, Exception\n" + NISAUtilities.getExceptionStackTrace(exception));
                            int n2 = -1098383331;
                            Object var10_8 = null;
                            if (null != printWriter) {
                                printWriter.close();
                            }
                            return n2;
                        }
                        Object var10_7 = null;
                        if (null != printWriter) {
                            printWriter.close();
                        }
                        break block45;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (null != printWriter) {
                            printWriter.close();
                        }
                        throw throwable;
                    }
                }
                NISAUtilities.getLog().warning("NISAUtilities.ftpFile() - Fail - no OS found ");
                return -1098383350;
            }
            if (null == file) {
                string4 = "chkConnect";
                string3 = "";
            } else {
                string4 = file.getName();
                string3 = file.getAbsolutePath();
            }
            NISAUtilities.getLog().info("ftpFile() - finish create the ftp commands file " + file2.getAbsolutePath());
            file3 = new File(file2.getAbsoluteFile() + string4);
            n = -1;
            try {
                if (NISAUtilities.linuxOs()) {
                    n = NISAUtilities.ourExec(string6, string4, null, file3.getAbsolutePath());
                    break block46;
                }
                if (NISAUtilities.winOs()) {
                    n = NISAUtilities.ourExec(string5, "-A -i -v -s:\"" + file2.getAbsolutePath() + "\"", null, file3.getAbsolutePath());
                    break block46;
                }
                NISAUtilities.getLog().warning("NISAUtilities.ftpFile() - Fail - no OS found ");
                return -1098383350;
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("ftpFile() - Fail to execute FTP cmd. Exception:\n" + NISAUtilities.getExceptionStackTrace(exception));
                return -1098383339;
            }
        }
        if (0 != n) {
            NISAUtilities.getLog().warning("ftpFile() - Fail to execute FTP cmd, file=" + string4);
            return -1098383331;
        }
        FileReader fileReader = null;
        int n3 = 0;
        BufferedReader bufferedReader = null;
        boolean bl = false;
        log.warning("Parsing ftp output...");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            String string7;
            fileReader = new FileReader(file3);
            bufferedReader = new BufferedReader(fileReader);
            while (null != (string7 = bufferedReader.readLine())) {
                if (string7.matches("quote xcrc " + string4)) {
                    bl = true;
                }
                if (string7.startsWith("250 ") && bl) {
                    int n4;
                    String[] stringArray = string7.split(" ");
                    long l = Long.parseLong(stringArray[1], 16);
                    log.info("dest xcrc = " + stringArray[1] + " = " + l);
                    byte[] byArray = new byte[1024];
                    CRC32 cRC32 = new CRC32();
                    FileInputStream fileInputStream = new FileInputStream(string3);
                    while ((n4 = fileInputStream.read(byArray)) > -1) {
                        cRC32.update(byArray, 0, n4);
                    }
                    fileInputStream.close();
                    log.info("local CRC = " + cRC32.getValue());
                    if (cRC32.getValue() != l) {
                        log.warning("xcrc check failed ");
                        log.warning("ftpFile() - Failed to ftp " + string4);
                        int n5 = -1098383331;
                        return n5;
                    }
                }
                if (string7.equals("open " + string)) {
                    log.warning("open was found in result file");
                    bl4 = true;
                    ++n3;
                    continue;
                }
                if (string7.matches(".*CWD command successful.*")) {
                    log.warning("cd was found in result file");
                    bl2 = true;
                    ++n3;
                    continue;
                }
                if (!string7.equals("bye")) continue;
                log.warning("bye was found in result file");
                bl3 = true;
                ++n3;
            }
            if (!(bl4 && bl2 && bl3)) {
                log.warning("ftpFile() - either open,cd or bye messages are missing in result file");
                log.warning("ftpFile() - Failed to ftp " + string4);
                int n6 = -1098383331;
                return n6;
            }
        }
        catch (Exception exception) {
            log.warning("ftpFile() - Failed to ftp " + string4 + " Exceprtion:\n" + NISAUtilities.getExceptionStackTrace(exception));
            int n7 = -1098383331;
            return n7;
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                log.warning("ftpFile() - failed to close file. Exception:\n " + NISAUtilities.getExceptionStackTrace(iOException));
            }
        }
        NISAUtilities.getLog().info("ftpFile() - Success to execute the FTP command for file " + string4);
        if (file3.delete()) {
            NISAUtilities.getLog().info("ftpFile() - success to delete " + file3.getName());
        } else {
            NISAUtilities.getLog().warning("NISAUtilities.ftpFile() - fail to delete " + file3.getName());
        }
        return 0;
    }

    public static NISAResult connect2ibm(String string, String string2, String string3, InetAddress inetAddress, InetAddress inetAddress2) {
        if (0 != initialError) {
            return new NISAResult(false, initialError);
        }
        log.info("connect2ibm Start - type = " + string + " model = " + string2 + " serial = " + string3 + " IP1 = " + inetAddress + " IP2 = " + inetAddress2);
        NISAResult nISAResult = new NISAResult();
        String string4 = NISAUtilities.getProperty("CONNECT2IBM_WIN_SCRIPT");
        String string5 = null == string ? "" : " -t " + string;
        String string6 = null == string2 ? "" : " -m " + string2;
        String string7 = null == string3 ? "" : " -s " + string3.replaceAll("-", "");
        String string8 = null == inetAddress ? "" : " -IP1 " + inetAddress.getHostAddress();
        String string9 = null == inetAddress2 ? "" : " -IP2 " + inetAddress2.getHostAddress();
        String string10 = string5 + string6 + string7 + string8 + string9;
        int n = 0;
        try {
            if (NISAUtilities.linuxOs()) {
                n = 1;
            } else if (NISAUtilities.winOs()) {
                n = NISAUtilities.ourExec(string4, string10, null, null);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warning("NISAUtilities.connect2ibm Fail - interupted - script file not founded" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            nISAResult.setCode(-1098383339);
            return nISAResult;
        }
        if (0 != n) {
            log.warning("NISAUtilities.connect2ibm Fail - running the script the exit value = " + n);
            nISAResult.setCode(n);
            return nISAResult;
        }
        nISAResult.setSuccessful(true);
        log.info("NISAUtilities.connect2ibm - Finish - OK");
        return nISAResult;
    }

    public static File getSend2IBMDir() {
        log.info("NISAUtilities.getSend2IBMDir Started");
        String string = NISAUtilities.getProperty("SEND_2_IBM_DIR_NAME");
        String string2 = NISAUtilities.getProperty("REEF_HOME_DIR_ENV_NAME");
        String string3 = null;
        try {
            string3 = NISAUtilities.getEnvVariable(string2);
        }
        catch (IOException iOException) {
            log.warning("NISAUtilities.getSend2IBMDir - Fail to get the environment variable, the Exception is :\n" + NISAUtilities.getExceptionStackTrace(iOException));
            return null;
        }
        if (null == string3) {
            log.warning("NISAUtilities.getSend2IBMDir - Fail, can't find the directory name " + string3 + " in the system variables list");
            return null;
        }
        File file = new File(string3 = string3 + File.separator + string);
        if (null == file || !file.isDirectory()) {
            log.warning("NISAUtilities.getSend2IBMDir - Fail, the destination directory " + string3 + " is invalid");
            return null;
        }
        log.info("Send2IBMDIR is: " + file.getAbsolutePath());
        log.info("NISAUtilities.getSend2IBMDir Finish - OK");
        return file;
    }

    public static File getSendingDir() {
        log.info("NISAUtilities.getSendingDir Started");
        String string = NISAUtilities.getProperty("SENDING_DIR_NAME");
        File file = NISAUtilities.getSend2IBMDir();
        File file2 = new File(file, string);
        if (null == file2 || !file2.isDirectory()) {
            log.info("creating sent dir " + file2.getAbsolutePath());
            if (!file2.mkdir()) {
                log.warning("Fail to create dir " + file2.getAbsolutePath());
                return null;
            }
        }
        log.info("sendingDir path: " + file2.getAbsolutePath() + "\n NISAUtilities.getSendingDir Finish - OK");
        return file2;
    }

    public static File getCopyFrom0Dir() {
        log.info("NISAUtilities.getCopyFrom0Dir Started");
        String string = NISAUtilities.getProperty("COPYING_FROM_0_DIR_NAME");
        File file = NISAUtilities.getSend2IBMDir();
        File file2 = new File(file, string);
        if (null == file2 || !file2.isDirectory()) {
            log.info("creating copyingFrom0 dir " + file2.getAbsolutePath());
            if (!file2.mkdir()) {
                log.warning("Fail to create dir " + file2.getAbsolutePath());
                return null;
            }
        }
        log.info(".getCopyFrom0Dir sendingDir path: " + file2.getAbsolutePath());
        log.info("NISAUtilities.getCopyFrom0Dir Finish - OK");
        return file2;
    }

    public static File getCopyFrom1Dir() {
        log.info("NISAUtilities.getCopyFrom1Dir Started");
        String string = NISAUtilities.getProperty("COPYING_FROM_1_DIR_NAME");
        File file = NISAUtilities.getSend2IBMDir();
        File file2 = new File(file, string);
        if (null == file2 || !file2.isDirectory()) {
            log.info("creating copyingFrom1 dir " + file2.getAbsolutePath());
            if (!file2.mkdir()) {
                log.warning("Fail to create dir " + file2.getAbsolutePath());
                return null;
            }
        }
        log.info(".getCopyFrom1Dir sendingDir path: " + file2.getAbsolutePath());
        log.info("NISAUtilities.getCopyFrom0Dir Finish - OK");
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int copyFile(File file, File file2) {
        log.info("copyFile() - Start - src=" + file + " dest=" + file2.getAbsolutePath());
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warning("copyFile() - Fail open the buffers. the Exeption:\n" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            return -1098383335;
        }
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            log.warning("copyFile() - Fail. the Exeption:\n" + NISAUtilities.getExceptionStackTrace(iOException));
            int n = -1098383338;
            return n;
        }
        finally {
            try {
                if (null != bufferedInputStream) {
                    bufferedInputStream.close();
                }
                if (null != bufferedOutputStream) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warning("copyFile() - fail to close the file. the Exception is:\n " + NISAUtilities.getExceptionStackTrace(iOException));
                return -1098383324;
            }
        }
        return 0;
    }

    protected static NISAResult preCond(NIServices nIServices, NIESSID nIESSID, File file) {
        String string;
        if (0 != initialError) {
            return new NISAResult(false, initialError);
        }
        log.info("preCond() - Start. initiallError = 0");
        if (null == nIServices || null == nIESSID || null == file) {
            log.warning("preCond() - Fail. invalid parameters. essniServis = " + nIServices + " essID = " + nIESSID + " smDir = " + file);
            return new NISAResult(false, -1099694077);
        }
        if (!nIServices.checkConnection()) {
            log.warning("preCond() - Fail. no Essni connection");
            return new NISAResult(false, -1098383359);
        }
        String[] stringArray = NISAUtilities.getKonasIP(nIESSID, nIServices);
        if (null == stringArray) {
            log.warning("preCond() - Fail. Essni get reef ips");
            return new NISAResult(false, -1098383340);
        }
        Object object = new NISAResult(true, 0);
        ((NISAResult)object).setCopiedFiles(stringArray);
        object = new File(file, Long.toString(Calendar.getInstance().getTimeInMillis()));
        if (!((File)object).mkdir()) {
            log.warning("preCond() -  Fail, smDir no write permissions");
            return new NISAResult(false, -1098383325);
        }
        ((File)object).delete();
        if (NISAUtilities.winOs()) {
            string = NISAUtilities.getProperty("COPY_TO_REEF_WIN_CMD");
        } else if (NISAUtilities.linuxOs()) {
            string = "which " + NISAUtilities.getProperty("COPY_TO_REEF_LNX_CMD");
        } else {
            log.warning("preCond() - Fail. unknown OS");
            return new NISAResult(false, -1098383350);
        }
        try {
            if (-1098383344 == NISAUtilities.ourExec(string, "", null, null)) {
                log.warning("preCond() - Fail. pscp/scp ");
                return new NISAResult(false, -1098383344);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warning("preCond() - Fail. Exception:" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            return new NISAResult(false, 2);
        }
        NISAResult nISAResult = new NISAResult(true, 0);
        nISAResult.setArray(stringArray);
        log.info("preCond() - Finish OK");
        return nISAResult;
    }

    protected static void concatFiles(File file, File[] fileArray) throws IOException {
        log.info("concatFiles() - Start. destFile = " + file);
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[1024];
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n = 0;
            while (n < fileArray.length) {
                if (!fileArray[n].isFile()) {
                    log.warning("concatFiles() - " + fileArray[n] + " not regular file");
                } else {
                    int n2;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(fileArray[n]));
                    while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                    }
                    bufferedInputStream.close();
                    log.info("concatFiles() - " + fileArray[n] + " coppied");
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            log.warning("concatFiles() - fail. \n the Exception is: " + NISAUtilities.getExceptionStackTrace(iOException));
            throw iOException;
        }
        finally {
            if (null != filterOutputStream) {
                filterOutputStream.close();
            }
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
    }

    protected static int manageSentDir() {
        log.info("manageSentDir() - Start");
        int n = NISAUtilities.getIntProperty("MAX_KEEP_PEP_FILES");
        int n2 = NISAUtilities.getIntProperty("MAX_KEEP_SS_FILES");
        int n3 = NISAUtilities.getIntProperty("MAX_KEEP_SMC_FILES");
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = NISAUtilities.getProperty("PE_PACKAGE_FILTER");
                return string.matches(".*." + string2);
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = NISAUtilities.getProperty("STATESAVE_FILES_FILTER");
                String string3 = NISAUtilities.getProperty("AH_SS_FILES_FILTER");
                String string4 = NISAUtilities.getProperty("CPSS_SS_FILES_FILTER");
                return string.matches(".*" + string2 + ".*") || string.matches(".*" + string3 + ".*") || string.matches(".*" + string4 + ".*");
            }
        };
        FilenameFilter filenameFilter3 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = NISAUtilities.getProperty("SMC_PACKAGE_SUFFIX");
                return string.matches(".*." + string2);
            }
        };
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (((File)object).lastModified() > ((File)object2).lastModified()) {
                    return -1;
                }
                if (((File)object).lastModified() < ((File)object2).lastModified()) {
                    return 1;
                }
                return 0;
            }
        };
        File file = NISAUtilities.getSentDir();
        if (file == null) {
            log.warning("manageSentDir() - Fail: " + file + " invalid dir");
            return -1098383326;
        }
        log.info("manageSentDir() - got sentDir = " + file.getAbsolutePath());
        File[] fileArray = file.listFiles(filenameFilter);
        File[] fileArray2 = file.listFiles(filenameFilter2);
        File[] fileArray3 = file.listFiles(filenameFilter3);
        log.info("manageSentDir() - before manage sentDir: \nPEP=" + fileArray.length + " SS=" + fileArray2.length + " SMC=" + fileArray3.length);
        Arrays.sort(fileArray, comparator);
        int n4 = n < fileArray.length ? n : fileArray.length;
        while (n4 < fileArray.length) {
            if (fileArray[n4].delete()) {
                log.info("manageSentDir() - delete " + fileArray[n4]);
            } else {
                log.warning("manageSentDir() - fail to delete " + fileArray[n4]);
            }
            ++n4;
        }
        Arrays.sort(fileArray2, comparator);
        int n5 = n2 < fileArray2.length ? n2 : fileArray2.length;
        while (n5 < fileArray2.length) {
            if (fileArray2[n5].delete()) {
                log.info("manageSentDir() - delete " + fileArray2[n5]);
            } else {
                log.warning("manageSentDir() - fail to delete " + fileArray2[n5]);
            }
            ++n5;
        }
        Arrays.sort(fileArray3, comparator);
        int n6 = n3 < fileArray3.length ? n3 : fileArray3.length;
        while (n6 < fileArray3.length) {
            if (fileArray3[n6].delete()) {
                log.info("manageSentDir() - delete " + fileArray3[n6]);
            } else {
                log.warning("manageSentDir() - fail to delete " + fileArray3[n6]);
            }
            ++n6;
        }
        log.info("manageSentDir() - Finish OK .sentDir containes:\nPEP " + file.listFiles(filenameFilter).length + "\nSS " + file.listFiles(filenameFilter2).length + "\nSMC " + file.listFiles(filenameFilter3).length);
        return 0;
    }

    protected static String[] arrayList2Arry(ArrayList arrayList) {
        if (null == arrayList) {
            log.warning("arrayList2Arry() - Fail arrayList = null");
            return null;
        }
        int n = arrayList.size();
        log.info("arrayList2Arry() - start size=" + n);
        String[] stringArray = new String[n];
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        log.info("arrayList2Arry() - Finish OK");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File zipFiles(File file, String string, File[] fileArray) {
        log.info("zipFiles() - Start. destDir-" + file + " zipName-" + string);
        byte[] byArray = new byte[1024];
        File file2 = new File(file, string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warning("zipDir() - Fail to open FileOutputStream " + file2 + "the Exception is:\n" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            return null;
        }
        FilterInputStream filterInputStream = null;
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        int n = 0;
        while (n < fileArray.length) {
            block22: {
                if (null == fileArray[n]) {
                    log.warning("zipFiles() - null file2zip " + fileArray[n]);
                } else {
                    try {
                        int n2;
                        filterInputStream = new DataInputStream(new FileInputStream(fileArray[n]));
                        zipOutputStream.putNextEntry(new ZipEntry(fileArray[n].getName()));
                        while ((n2 = ((DataInputStream)filterInputStream).read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (Exception exception) {
                        log.warning("zipDir() - Fail to zip " + fileArray[n] + " the Exception is:\n" + NISAUtilities.getExceptionStackTrace(exception));
                        break block22;
                    }
                    finally {
                        if (null != filterInputStream) {
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException) {
                                log.warning("zipDir() - Fail to close file-" + fileArray[n] + " the Exception is:\n" + NISAUtilities.getExceptionStackTrace(iOException));
                            }
                        }
                    }
                    log.info("zipDir() - zipped " + fileArray[n]);
                }
            }
            ++n;
        }
        if (null != zipOutputStream) {
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                log.warning("zipDir() - Fail to close zipFile-" + file2 + " the Exception is:\n" + NISAUtilities.getExceptionStackTrace(iOException));
                return null;
            }
        }
        log.info("zipDir() - Finish. the zipfile-" + file2.getName());
        return file2;
    }

    protected static int getInitialError() {
        return initialError;
    }

    protected static void setInitialError(int n) {
        initialError = n;
    }

    protected static int scpFile(String string, String string2, String string3, String string4, String string5) {
        String string6;
        NISAUtilities.getLog().info("scpFile() - start ip=" + string + " un=" + string2 + " destFile=" + string4 + " sourceFile=" + string5);
        if (null == string || null == string2 || null == string3 || null == string4 || null == string5) {
            NISAUtilities.getLog().warning("scpFile() - failed, at least one paramete null");
            return -1098383330;
        }
        String string7 = string3 + " " + string2 + "@" + string + ":" + string5;
        if (NISAUtilities.winOs()) {
            string6 = NISAUtilities.getProperty("COPY_TO_REEF_WIN_CMD");
            string7 = "-pw " + string7 + " \"" + string4 + "\"";
        } else if (NISAUtilities.linuxOs()) {
            string6 = NISAUtilities.getProperty("COPY_TO_REEF_LNX_CMD");
            string7 = string7 + " " + string4;
        } else {
            NISAUtilities.getLog().warning("scpFile() - failes unknown OS");
            return -1098383350;
        }
        String string8 = NISAUtilities.getProperty("SCP_RESPONSE");
        int n = 0;
        try {
            NISAUtilities.getLog().info("scpFile() - parms=" + string7);
            n = NISAUtilities.ourExec(string6, string7, string8, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            NISAUtilities.getLog().warning("scpFile() - failed - exception: " + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            n = -1098383344;
        }
        if (0 != n) {
            NISAUtilities.getLog().warning("scpFile() - failed script rc=" + n);
            return -1098383344;
        }
        NISAUtilities.getLog().info("scpFile() - finish success");
        return n;
    }

    protected static String md5sum(File file) throws Exception {
        if (!file.exists()) {
            NISAUtilities.getLog().warning("md5sum() - file not found " + file.getAbsolutePath());
            return null;
        }
        NISAUtilities.getLog().info("md5sum() - start for file " + file.getAbsolutePath());
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray, 0, 1024)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        String string = NISAUtilities.byte2HexStr(messageDigest.digest());
        NISAUtilities.getLog().info("md5sum() - md5= " + string);
        return string;
    }

    private static String byte2HexStr(byte[] byArray) {
        if (byArray.length != 16) {
            NISAUtilities.getLog().warning("toHexStr() - incorect input");
            return null;
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[32];
        int n = 0;
        while (n < 16) {
            int n2 = byArray[n] & 0xF;
            int n3 = (byArray[n] & 0xF0) >> 4;
            cArray2[n * 2] = cArray[n3];
            cArray2[n * 2 + 1] = cArray[n2];
            ++n;
        }
        return new String(cArray2);
    }

    protected static boolean isMatchIpId(NIESSID nIESSID, InetAddress inetAddress) {
        String string = new NISAMonitor().getSerialNum(inetAddress);
        if (null != string && null != nIESSID && nIESSID.toString().matches(".*" + string)) {
            return true;
        }
        NISAUtilities.getLog().warning("isMatchIpId() - unMatch boxSerial=" + string + " cmdSerial=" + nIESSID);
        return false;
    }

    protected static boolean renameFile(File file, File file2) {
        log.info("renameFile(): Start, src=" + file + " target=" + file2);
        int n = 0;
        while (n < 10) {
            try {
                if (file.renameTo(file2)) {
                    log.info("renameFile(): Finish, success, try #" + n);
                    return true;
                }
                log.warning("renameFile(): try #" + n + " failed ");
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                log.warning("renameFile(): Finish, failed, Exception:\n" + NISAUtilities.getExceptionStackTrace(exception));
                return false;
            }
            ++n;
        }
        log.info("renameFile(): Finish, failed");
        return false;
    }

    public static NISAResult checkInitialError() {
        return new NISAResult(0 == initialError, initialError);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block2: {
            homeDirVarName = "REEF_HOME_DIR_ENV_NAME";
            initialError = 0;
            md5JarEntry = null;
            String string = (class$com$ibm$storage$ess$ni$sa$NISAUtilities == null ? (class$com$ibm$storage$ess$ni$sa$NISAUtilities = NISAUtilities.class$("com.ibm.storage.ess.ni.sa.NISAUtilities")) : class$com$ibm$storage$ess$ni$sa$NISAUtilities).getPackage().getName() + ".NISA";
            props = ResourceBundle.getBundle(string);
            LogManager logManager = LogManager.getLogManager();
            String string2 = (class$com$ibm$storage$ess$ni$sa$NISAUtilities == null ? (class$com$ibm$storage$ess$ni$sa$NISAUtilities = NISAUtilities.class$("com.ibm.storage.ess.ni.sa.NISAUtilities")) : class$com$ibm$storage$ess$ni$sa$NISAUtilities).getName();
            log = Logger.getLogger(string2);
            logManager.addLogger(log);
            try {
                NISAUtilities.readLogProperties(logManager);
            }
            catch (Exception exception) {
                if (0 != initialError) break block2;
                initialError = -1098383315;
            }
        }
    }
}

