/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa.remotevpn;

import com.ibm.storage.ess.ni.sa.remotevpn.ConnectionStatusResult;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteClient;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteClientDialingCredentials;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteException;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Random;

public class IBMRemoteClientImpl
implements IBMRemoteClient {
    private static final String INSERT_SEPERATOR = "::";
    private static final int NUM_DIALERS = 4;
    private static final char PREFIX_SEPERATOR = ',';
    private static final String PROPERTY_PHONE_NUMBER_ = "PROPERTY_PHONE_NUMBER_";
    private static final String EMPTY_NUMBER = "";
    public static final String MSG_UNSATISFIED_LINK = "IRC0100E";
    public static final String MSG_NO_MESSAGE = "IRC0000I";
    public static final int SEND_CALL_HOME_SUCCESS = 0;
    public static final int SEND_CALL_HOME_FAILED_NO_CFG = -1;
    public static final int SEND_CALL_HOME_FAILED_ERROR = -2;
    private static final String RS_CALL_HOME_COMMAND = "rsTCPSendPMH.exe";
    private static final String RS_CALL_HOME_ENC_SUFFIX = "E0.";
    public static final String RS_CALL_HOME_KEY_TYPEMODEL = "Product Machine type and model number.";
    public static final String RS_CALL_HOME_KEY_SERIAL = "Product serial number.";
    public static final String RS_CALL_HOME_KEY_RECORD_TYPE = "Record type.";
    public static final String RS_CALL_HOME_SEVERE_ERROR = "DI";
    public static final String RS_CALL_HOME_LESS_SEVERE_ERROR = "OQ";
    public static final String RS_CALL_HOME_NOT_SEVERE_ERROR = "HB";
    private static Random random = new Random();
    private static boolean LINK_ERROR;

    private native String _getPhoneNumber(int var1);

    private native int _setPhoneNumber(int var1, String var2);

    private native int _testPhoneNumber(String var1);

    private native int _connectToIBMRemoteSupport(String var1, String var2, String var3, String var4, String var5);

    private native int _setForcedVPN(boolean var1);

    private native int _setModemCredentials(String var1, String var2, String var3);

    private native boolean _isVPNAvailable();

    private native boolean _isModemAvailable();

    private native int _disconnect();

    private native int _removeDialer(int var1);

    private native String _getVPNStatus();

    private native String _getTestStatus(String var1);

    private native int _createModemConnection();

    private native int _updateModemConnection(int var1);

    private native int _expireModemConnection(int var1);

    private native int _modemAddRoute(String var1);

    public void connectToIBMRemoteSupport(String string, String string2, String string3, InetAddress inetAddress, InetAddress inetAddress2) throws IBMRemoteException {
        this.connectToIBMRemoteSupport(string, string2, string3, inetAddress, inetAddress2, false);
    }

    public void connectToIBMRemoteSupport(String string, String string2, String string3, InetAddress inetAddress, InetAddress inetAddress2, boolean bl) throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        try {
            this._setForcedVPN(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            IBMRemoteUtilities.getLog().warning("UnsatisfiedLinkError caught when setting forced VPN");
        }
        this._connectToIBMRemoteSupport(string, string2, string3, inetAddress.getHostAddress(), inetAddress2.getHostAddress());
    }

    public void disconnect() throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        this._disconnect();
    }

    public Properties getModemProperties() throws IBMRemoteException {
        int n;
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        Properties properties = new Properties();
        String[] stringArray = new String[4];
        String string = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < 4) {
            stringArray[n2] = this._getPhoneNumber(n2);
            if (stringArray[n2] != null && !stringArray[n2].equals(EMPTY_NUMBER) && !bl) {
                n = stringArray[n2].indexOf(44);
                if (n != -1) {
                    String string2 = stringArray[n2].substring(0, n);
                    if (string == null) {
                        string = string2;
                    } else if (!string.equals(string2)) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            properties.setProperty("PROPERTY_DIAL_PREFIX", EMPTY_NUMBER);
        } else {
            string = string == null ? EMPTY_NUMBER : string;
            properties.setProperty("PROPERTY_DIAL_PREFIX", string);
        }
        n = 0;
        while (n < 4) {
            if (stringArray[n] == null) {
                stringArray[n] = EMPTY_NUMBER;
            }
            if (!bl && stringArray[n] != null && !stringArray[n].equals(EMPTY_NUMBER)) {
                stringArray[n] = stringArray[n].substring(string.length() + 1);
            }
            properties.setProperty(PROPERTY_PHONE_NUMBER_ + (n + 1), stringArray[n]);
            ++n;
        }
        if (string != null && string.startsWith("P")) {
            string = string.substring("P".length());
            properties.setProperty("PROPERTY_DIAL_TYPE", "P");
            properties.setProperty("PROPERTY_DIAL_PREFIX", string);
        } else if (string != null && string.startsWith("T")) {
            string = string.substring("T".length());
            properties.setProperty("PROPERTY_DIAL_TYPE", "T");
            properties.setProperty("PROPERTY_DIAL_PREFIX", string);
        } else {
            properties.setProperty("PROPERTY_DIAL_TYPE", "T");
        }
        return properties;
    }

    public ConnectionStatusResult getRemoteSupportConnectionStatus() throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        String string = this._getVPNStatus();
        ConnectionStatusResult connectionStatusResult = this.parseStatus(string);
        connectionStatusResult.setModemAvailable(this._isModemAvailable());
        connectionStatusResult.setVpnAvailable(this._isVPNAvailable());
        return connectionStatusResult;
    }

    public ConnectionStatusResult getTestConnectionStatus(String string, String string2) throws IBMRemoteException {
        Properties properties = new Properties();
        properties.setProperty("PROPERTY_DIAL_PREFIX", string == null ? EMPTY_NUMBER : string);
        properties.setProperty("PROPERTY_PHONE_NUMBER_TEST", string2 == null ? EMPTY_NUMBER : string2);
        return this.getTestConnectionStatus(properties);
    }

    public void setModemProperties(Properties properties) throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        String string = properties.getProperty("PROPERTY_DIAL_PREFIX");
        String string2 = properties.getProperty("PROPERTY_DIAL_TYPE");
        String[] stringArray = new String[4];
        int n = 0;
        while (n < 4) {
            stringArray[n] = properties.getProperty(PROPERTY_PHONE_NUMBER_ + (n + 1));
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            if (stringArray[n3] != null && !stringArray[n3].equals(EMPTY_NUMBER)) {
                this._setPhoneNumber(n2++, this.formatNumber(string2, string, stringArray[n3]));
            }
            ++n3;
        }
        while (n2 < 4) {
            this._removeDialer(n2);
            ++n2;
        }
        IBMRemoteClientDialingCredentials.updateSystemDialingCredentials();
        IBMRemoteClientDialingCredentials iBMRemoteClientDialingCredentials = IBMRemoteClientDialingCredentials.getSystemDialingCredentials();
        this._setModemCredentials(iBMRemoteClientDialingCredentials.getAccountName(), iBMRemoteClientDialingCredentials.getUserID(), iBMRemoteClientDialingCredentials.getPassword());
    }

    public void testPhoneNumber(String string, String string2) throws IBMRemoteException {
        Properties properties = new Properties();
        properties.setProperty("PROPERTY_DIAL_PREFIX", string == null ? EMPTY_NUMBER : string);
        properties.setProperty("PROPERTY_PHONE_NUMBER_TEST", string2 == null ? EMPTY_NUMBER : string2);
        this.testPhoneNumber(properties);
    }

    public void testPhoneNumber(Properties properties) throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        String string = properties.getProperty("PROPERTY_DIAL_TYPE", "T");
        String string2 = properties.getProperty("PROPERTY_DIAL_PREFIX", EMPTY_NUMBER);
        String string3 = properties.getProperty("PROPERTY_PHONE_NUMBER_TEST", "9");
        String string4 = this.formatNumber(string, string2, string3);
        this._testPhoneNumber(string4);
    }

    public ConnectionStatusResult getTestConnectionStatus(Properties properties) throws IBMRemoteException {
        String string;
        String string2;
        String string3;
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        if (properties == null) {
            string3 = "T";
            string2 = EMPTY_NUMBER;
            string = EMPTY_NUMBER;
        } else {
            string3 = properties.getProperty("PROPERTY_DIAL_TYPE", "T");
            string2 = properties.getProperty("PROPERTY_DIAL_PREFIX", EMPTY_NUMBER);
            string = properties.getProperty("PROPERTY_PHONE_NUMBER_TEST", EMPTY_NUMBER);
        }
        String string4 = this.formatNumber(string3, string2, string);
        String string5 = this._getTestStatus(string4);
        ConnectionStatusResult connectionStatusResult = this.parseStatus(string5);
        connectionStatusResult.setModemAvailable(this._isModemAvailable());
        connectionStatusResult.setVpnAvailable(this._isVPNAvailable());
        return connectionStatusResult;
    }

    public boolean isModemConfigured() throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        int n = 0;
        while (n < 4) {
            String string = this._getPhoneNumber(n);
            if (string != null && !string.equals(EMPTY_NUMBER)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public long modemCreateConnection() throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        int n = this._createModemConnection();
        IBMRemoteUtilities.getLog().info("modemCreateConnection returned with ret " + n);
        return n;
    }

    public int modemUpdateConnection(long l) throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        int n = this._updateModemConnection((int)l);
        IBMRemoteUtilities.getLog().info("modemUpdateConnection returned with ret " + n);
        return n;
    }

    public int modemExpireConnection(long l) throws IBMRemoteException {
        if (LINK_ERROR) {
            throw new IBMRemoteException(MSG_UNSATISFIED_LINK);
        }
        int n = this._expireModemConnection((int)l);
        IBMRemoteUtilities.getLog().info("modemExpireConnection returned with ret " + n);
        return n;
    }

    public int sendCallHomeModem(String string) {
        Object object;
        if (LINK_ERROR) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - Link error");
            return -2;
        }
        IBMRemoteClientDialingCredentials iBMRemoteClientDialingCredentials = IBMRemoteClientDialingCredentials.getSystemDialingCredentials();
        CallHomeModemThread callHomeModemThread = null;
        IBMRemoteUtilities.getLog().warning("sendCallHomeModem() enter");
        try {
            if (!this.isModemConfigured()) {
                IBMRemoteUtilities.getLog().warning("sendCallHome exit - modems not configured");
                return -1;
            }
        }
        catch (Exception exception) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - modems config threw exception\n" + IBMRemoteUtilities.getExceptionStackTrace(exception));
            return -1;
        }
        try {
            long l = this.modemCreateConnection();
            if (l <= 0L) {
                IBMRemoteUtilities.getLog().warning("sendCallHome exit - modemCreateConnection() did not connect successfully");
                return -2;
            }
            callHomeModemThread = new CallHomeModemThread(this, l);
            callHomeModemThread.start();
        }
        catch (Exception exception) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - modemCreateConnection() threw an exception\n" + IBMRemoteUtilities.getExceptionStackTrace(exception));
        }
        String string2 = IBMRemoteUtilities.getBinDirectoryName() + File.separator + IBMRemoteClientImpl.parseValueWithAttribute(string, RS_CALL_HOME_KEY_TYPEMODEL) + IBMRemoteClientImpl.parseValueWithAttribute(string, RS_CALL_HOME_KEY_SERIAL) + RS_CALL_HOME_ENC_SUFFIX + IBMRemoteClientImpl.parseValueWithAttribute(string, RS_CALL_HOME_KEY_RECORD_TYPE) + this.randomString();
        File file = new File(string2);
        try {
            IBMRemoteUtilities.getLog().finest("About to Write Record contents to file " + string2 + ":\n " + string);
            object = new FileWriter(file);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - Writing call home contents threw an exception\n" + IBMRemoteUtilities.getExceptionStackTrace(iOException));
            file.delete();
            if (callHomeModemThread != null) {
                callHomeModemThread.shutdownModem();
            }
            return -2;
        }
        IBMRemoteUtilities.getLog().finest("Invoking RETAIN command");
        object = new File(IBMRemoteUtilities.getBinDirectoryName());
        String string3 = EMPTY_NUMBER;
        try {
            string3 = this.getModemProperties().getProperty("PROPERTY_PHONE_NUMBER_1");
        }
        catch (IBMRemoteException iBMRemoteException) {
            // empty catch block
        }
        if (string3.trim().length() == 0) {
            string3 = "1";
        }
        boolean bl = this._modemAddRoute(iBMRemoteClientDialingCredentials.getIpAddress1()) == 0;
        if (!(bl |= this._modemAddRoute(iBMRemoteClientDialingCredentials.getIpAddress2()) == 0)) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - Failed to add route to " + iBMRemoteClientDialingCredentials.getIpAddress1() + " or " + iBMRemoteClientDialingCredentials.getIpAddress2());
            file.delete();
            if (callHomeModemThread != null) {
                callHomeModemThread.shutdownModem();
            }
            return -2;
        }
        String[] stringArray = new String[]{RS_CALL_HOME_COMMAND, "-v", "-c", file.getName(), iBMRemoteClientDialingCredentials.getIpAddress1(), iBMRemoteClientDialingCredentials.getPort1(), iBMRemoteClientDialingCredentials.getIpAddress2(), iBMRemoteClientDialingCredentials.getPort2(), string3, iBMRemoteClientDialingCredentials.getAccountName(), iBMRemoteClientDialingCredentials.getUserID()};
        int n = IBMRemoteUtilities.windowsExec(stringArray, (File)object);
        file.delete();
        if (callHomeModemThread != null) {
            callHomeModemThread.shutdownModem();
        }
        if (n != 0) {
            IBMRemoteUtilities.getLog().warning("sendCallHome exit - Calling retain failed with return code " + n);
            return -2;
        }
        IBMRemoteUtilities.getLog().info("sendCallHome exit successful");
        return 0;
    }

    private ConnectionStatusResult parseStatus(String string) {
        ConnectionStatusResult connectionStatusResult = new ConnectionStatusResult();
        if (string != null) {
            String[] stringArray = string.split(INSERT_SEPERATOR);
            connectionStatusResult.setMsgKey(stringArray[0]);
            if (stringArray.length > 1) {
                int n = 0;
                int n2 = 1;
                while (n2 < stringArray.length) {
                    if (stringArray[n2] != null && stringArray[n2].length() > 0) {
                        ++n;
                    }
                    ++n2;
                }
                String[] stringArray2 = new String[n];
                int n3 = 1;
                int n4 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                        stringArray2[n4++] = stringArray[n3];
                    }
                    ++n3;
                }
                connectionStatusResult.setInserts(stringArray2);
            }
        } else {
            connectionStatusResult.setMsgKey(MSG_NO_MESSAGE);
        }
        return connectionStatusResult;
    }

    private String formatNumber(String string, String string2, String string3) {
        if (string == null) {
            string = "T";
        }
        if (string2 == null) {
            string2 = EMPTY_NUMBER;
        }
        return string + string2 + ',' + string3;
    }

    private String randomString() {
        return new String(EMPTY_NUMBER + random.nextInt(9) + EMPTY_NUMBER + random.nextInt(9) + EMPTY_NUMBER + random.nextInt(9) + EMPTY_NUMBER + random.nextInt(9) + EMPTY_NUMBER + random.nextInt(9) + EMPTY_NUMBER + random.nextInt(9));
    }

    public static String parseValueWithAttribute(String string, String string2) {
        String[] stringArray = string.split("\n");
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(string2) > 0) {
                string3 = stringArray[n];
                break;
            }
            ++n;
        }
        if (string3 == null) {
            return null;
        }
        String string4 = string3.substring(string3.indexOf(61) + 1);
        string4 = string4.trim();
        if (string2 == RS_CALL_HOME_KEY_RECORD_TYPE) {
            string4 = IBMRemoteClientImpl.getCallHomeRecord(string4);
        }
        return string4;
    }

    private static String getCallHomeRecord(String string) {
        String string2;
        Integer n = new Integer(string);
        switch (n) {
            case 1: {
                string2 = RS_CALL_HOME_SEVERE_ERROR;
                break;
            }
            case 4: {
                string2 = RS_CALL_HOME_LESS_SEVERE_ERROR;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string2 = RS_CALL_HOME_NOT_SEVERE_ERROR;
                break;
            }
            default: {
                string2 = RS_CALL_HOME_SEVERE_ERROR;
            }
        }
        return string2;
    }

    static {
        try {
            System.loadLibrary("IBMRemote");
        }
        catch (Throwable throwable) {
            IBMRemoteUtilities.getLog().warning("Error loading IBMRemote");
            IBMRemoteUtilities.getLog().throwing("System", "loadLibrary", throwable);
            try {
                System.load("C:\\IBMRemote.dll");
            }
            catch (Throwable throwable2) {
                LINK_ERROR = true;
                IBMRemoteUtilities.getLog().warning("Error loading C:\\IBMRemote.dll");
                IBMRemoteUtilities.getLog().throwing("System", "load", throwable);
            }
        }
    }

    private static class CallHomeModemThread
    extends Thread {
        static final int TIMER_INTERVAL = 30000;
        private int numCycles = 20;
        private long connectionID;
        private IBMRemoteClient client;

        public CallHomeModemThread(IBMRemoteClient iBMRemoteClient, long l) {
            this.client = iBMRemoteClient;
            this.connectionID = l;
        }

        private void shutdownModem() {
            this.numCycles = 4;
        }

        public void run() {
            while (this.numCycles > 0) {
                try {
                    Thread.sleep(30000L);
                    this.client.modemUpdateConnection(this.connectionID);
                }
                catch (Exception exception) {
                    IBMRemoteUtilities.getLog().warning("CallHomeModemThread caught Exception in loop:\n" + exception);
                }
                --this.numCycles;
            }
            try {
                this.client.modemExpireConnection(this.connectionID);
            }
            catch (Exception exception) {
                IBMRemoteUtilities.getLog().warning("CallHomeModemThread caught expire exception:\n" + exception);
            }
        }
    }
}

