/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa.remotevpn;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Result {
    public static final int UNKNOWN_RESULT = -1;
    public static final int INFO_RESULT = 0;
    public static final int WARNING_RESULT = 1;
    public static final int ERROR_RESULT = 2;
    public static final String INFO_SUFFIX = "I";
    public static final String WARNING_SUFFIX = "W";
    public static final String ERROR_SUFFIX = "E";
    private String msgKey = null;
    private String[] inserts = null;
    private int resultType = 0;

    public Result() {
    }

    public Result(String string, String[] stringArray) {
        this.setMsgKey(string);
        this.setInserts(stringArray);
    }

    public final void setMsgKey(String string) {
        this.msgKey = string;
        this.setResultType();
    }

    public final String getMsgKey() {
        return this.msgKey;
    }

    public final void setInserts(String[] stringArray) {
        this.inserts = stringArray;
    }

    public final String[] getInserts() {
        return this.inserts;
    }

    public final void setResultType() {
        if (this.msgKey != null) {
            this.resultType = this.msgKey.endsWith(INFO_SUFFIX) ? 0 : (this.msgKey.endsWith(WARNING_SUFFIX) ? 1 : (this.msgKey.endsWith(ERROR_SUFFIX) ? 2 : -1));
        }
    }

    public final void setResultType(int n) {
        this.resultType = n;
    }

    public final int getResultType() {
        return this.resultType;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        ResourceBundle resourceBundle = null;
        if (!string.equals("")) {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
                bl = true;
            }
            catch (MissingResourceException missingResourceException) {
                stringBuffer.append("Error accessing resource bundle: Message text cannot be printed");
            }
        }
        if (this.getMsgKey() != null) {
            if (bl) {
                try {
                    stringBuffer.append(MessageFormat.format(resourceBundle.getString(this.getMsgKey()), this.getInserts()));
                }
                catch (MissingResourceException missingResourceException) {
                    stringBuffer.append("MsgKey = " + this.getMsgKey() + " Inserts = " + this.getInsertString());
                }
            } else {
                stringBuffer.append("MsgKey = " + this.getMsgKey() + " Inserts = " + this.getInsertString());
            }
        }
        return stringBuffer.toString();
    }

    private String getInsertString() {
        String string = new String();
        string = "[";
        boolean bl = true;
        String[] stringArray = this.getInserts();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!bl) {
                    string = string + ",";
                }
                string = string + stringArray[n];
                bl = false;
                ++n;
            }
        }
        string = string + "]";
        return string;
    }

    public String toString() {
        return this.toString("");
    }
}

