/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIUserGroup;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.resource.NIUserGroupImpl;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseImplementation;
import com.ibm.storage.ess.ni.security.NISecurityFileImplementation;
import com.ibm.storage.ess.ni.security.common.NISecurityDefault;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class NISecurityDatabaseManager {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NISecurityDatabaseManager == null ? (class$com$ibm$storage$ess$ni$security$NISecurityDatabaseManager = NISecurityDatabaseManager.class$("com.ibm.storage.ess.ni.security.NISecurityDatabaseManager")) : class$com$ibm$storage$ess$ni$security$NISecurityDatabaseManager);
    private final String DATABASE_DRIVER = "com.ibm.db2j.jdbc.DB2jDriver";
    private final String DATABASE_URL = "jdbc:db2j:";
    private static final String SECURITY_DATABASE = "$_SECURITY_DB_$";
    public static final String BASE_SECURITY_DIR = System.getProperty("db2j.system.home") + "/";
    public static final String SECURITY_DATABASE_DIR = BASE_SECURITY_DIR + "$_SECURITY_DB_$" + "/";
    public final String DATABASE_NOT_FOUND = "XJ004";
    private static NISecurityDatabaseHelper dbHelper = null;
    private static final long SLEEP_TIME = 120000L;
    private static NISecurityDatabaseManager databaseManager = null;
    private static boolean alive = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NISecurityDatabaseManager;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$resource$NIUserGroup;

    private NISecurityDatabaseManager() throws Exception {
        Class.forName("com.ibm.db2j.jdbc.DB2jDriver").newInstance();
        dbHelper = this.openRepository();
        logger.debug_general("Security repository is ready for use");
    }

    public static NISecurityDatabaseManager getDatabaseManager() {
        block2: {
            if (databaseManager != null) break block2;
            try {
                databaseManager = new NISecurityDatabaseManager();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                databaseManager = null;
            }
        }
        return databaseManager;
    }

    public static NISecurityDatabaseHelper getDatabaseHelper() {
        if (dbHelper == null) {
            NISecurityDatabaseManager.getDatabaseManager();
        }
        return dbHelper;
    }

    private NISecurityDatabaseHelper openRepository() {
        NISecurityDatabaseHelper nISecurityDatabaseHelper = this.openDatabaseImplementation();
        if (nISecurityDatabaseHelper != null) {
            logger.debug_general("Cloudscape database present.");
            logger.debug_general("Obtaining accounts, group and settings from database.");
            Vector vector = nISecurityDatabaseHelper.getAllUserAccounts();
            Vector vector2 = nISecurityDatabaseHelper.getAllUserGroups();
            NISecurityTableEntry nISecurityTableEntry = nISecurityDatabaseHelper.getSecurityEntry();
            logger.debug_general("Closing database connection, then shutting down database and remove it.");
            ((NISecurityDatabaseImplementation)nISecurityDatabaseHelper).close();
            this.shutdownDatabaseImplementation();
            this.removeDatabaseImplementation(new File(SECURITY_DATABASE_DIR));
            logger.debug_general("Storing information retrieved from database to file format.");
            nISecurityDatabaseHelper = NISecurityFileImplementation.getSecurityFileImplementation();
            nISecurityDatabaseHelper.storeAccounts(vector);
            nISecurityDatabaseHelper.storeGroups(vector2);
            nISecurityDatabaseHelper.storeSecuritySettings(nISecurityTableEntry);
            this.updateUserGroupMethodsAllowed(nISecurityDatabaseHelper);
        } else {
            logger.debug_general("No cloudscape database present, so using file format");
            nISecurityDatabaseHelper = this.openFileImplementation();
        }
        return nISecurityDatabaseHelper;
    }

    /*
     * Unable to fully structure code
     */
    private NISecurityDatabaseHelper openDatabaseImplementation() {
        var1_1 = null;
        var2_2 = new Properties();
        var2_2.put("databaseName", "$_SECURITY_DB_$");
        var3_3 = null;
        try {
            var3_3 = DriverManager.getConnection("jdbc:db2j:", var2_2);
        }
        catch (SQLException var4_4) {
            ** while ((var4_5 = var4_5.getNextException()) != null)
        }
lbl-1000:
        // 1 sources

        {
            NISecurityDatabaseManager.logger.throwable((Throwable)var4_5);
            continue;
        }
lbl13:
        // 2 sources

        if (var3_3 != null) {
            var1_1 = new NISecurityDatabaseImplementation(var3_3);
            var1_1.prepareAllStatements();
        }
        return var1_1;
    }

    private NISecurityDatabaseHelper openFileImplementation() {
        NISecurityFileImplementation nISecurityFileImplementation = NISecurityFileImplementation.getSecurityFileImplementation();
        if (!this.populateSecurityRepository(nISecurityFileImplementation)) {
            this.updateUserGroupMethodsAllowed(nISecurityFileImplementation);
        }
        logger.debug_general("Respositores out of sync flag = " + ((NISecurityDatabaseHelper)nISecurityFileImplementation).getSecurityEntry().getOutOfSyncHMCs());
        return nISecurityFileImplementation;
    }

    private boolean populateSecurityRepository(NISecurityDatabaseHelper nISecurityDatabaseHelper) {
        int n;
        Object object;
        boolean bl = true;
        if (nISecurityDatabaseHelper.getSecurityEntry() == null) {
            logger.debug_general("Populating the Security repository with the default security settings.");
            bl = false;
            object = new NISecurityTableEntry(3, 365, true, true, null);
            n = nISecurityDatabaseHelper.insertSecurityEntry((NISecurityTableEntry)object);
            if (n != 0) {
                logger.error("Failed to create default Security settings: " + Integer.toHexString(n));
            }
        }
        if (nISecurityDatabaseHelper.getNumUserGroups() < (class$com$ibm$storage$ess$ni$application$resource$NIUserGroup == null ? (class$com$ibm$storage$ess$ni$application$resource$NIUserGroup = NISecurityDatabaseManager.class$("com.ibm.storage.ess.ni.application.resource.NIUserGroup")) : class$com$ibm$storage$ess$ni$application$resource$NIUserGroup).getFields().length) {
            logger.debug_general("Populating the Security repository with the user groups supported.");
            bl = false;
            object = new NIUserGroupImpl("Administrator", "Administrator user group.  This group has access to all ESSNI Service methods and all ESS Resources.", NISecurityDefault.getMethodsForUserGroup("Administrator"));
            n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)object);
            if (n != 0) {
                logger.error("Failed to create Admin user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("OperatorPhysicalConf", "Physical Configuration operator user group.  This group has access to ESSNI Service methods and Resources relating to Physical Configuration, including Storage Plex, Storage Facility, Storage Facility Image, arrays, ranks, and extent pool objects.  In addition, this user group inherits all the authority of OP_LOG_CONFIG_USER_GROUP, OP_COPY_SERVICES_USER_GROUP, OP_SERVICE_GROUP_DESC, and MONITOR_USER_GROUP, excluding security related methods.", NISecurityDefault.getMethodsForUserGroup("OperatorPhysicalConf"))))) != 0) {
                logger.error("Failed to create Physical Config user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("OperatorLogicalConf", "Logical Configuration operator user group.  This group has access to ESSNI Service methods and Resources relating to Logical Volumes, Hosts, Host Ports, Logical Subsystems, Logical Volumes, and Volume Groups, excluding security related methods.  In addition, this user group inherits  all authority of MONITOR_USER_GROUP.", NISecurityDefault.getMethodsForUserGroup("OperatorLogicalConf"))))) != 0) {
                logger.error("Failed to create Logical Config user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("OperatorCopyServices", "Copy Services operator user group.  This group has access to all Copy Services related ESSNI Service methods and Resources, excluding security related methods.  In addition, this user group inherits all authority of MONITOR_USER_GROUP.", NISecurityDefault.getMethodsForUserGroup("OperatorCopyServices"))))) != 0) {
                logger.error("Failed to create Copy Services user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("OperatorServiceFunctions", "Service functions user group.  This group has access to all Service related ESSNI Service methods and resources, i.e., peforming a code load, retrieving problem logs, etc.  In addition, this user group inherits all authority of MONITOR_USER_GROUP.", NISecurityDefault.getMethodsForUserGroup("OperatorServiceFunctions"))))) != 0) {
                logger.error("Failed to create Service Functions user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("Monitor", "Monitor user group.  This group has access to all read-only, non-security related ESSNI Service methods and all ESS Resources.", NISecurityDefault.getMethodsForUserGroup("Monitor"))))) != 0) {
                logger.error("Failed to create Monitor user group: " + Integer.toHexString(n));
            }
            if ((n = nISecurityDatabaseHelper.insertUserGroup((NIUserGroup)(object = new NIUserGroupImpl("Default", "Default user group.  This group has no access to any ESSNI Service methods or ESS Resources.  This is the ESSNI User Group assigned to a user account in the ESSNI Security Repository that is not associated with any other user group.", NISecurityDefault.getMethodsForUserGroup("Default"))))) != 0) {
                logger.error("Failed to create Default user group: " + Integer.toHexString(n));
            }
        }
        if (nISecurityDatabaseHelper.getNumUserAccounts() == 0 && !bl) {
            logger.debug_general("Populating the Security repository with the default account.");
            object = new String[]{"Administrator"};
            NIUserAccountImpl nIUserAccountImpl = new NIUserAccountImpl("admin", "admin", (String[])object);
            n = nISecurityDatabaseHelper.insertUserAccount(nIUserAccountImpl);
            if (n != 0) {
                logger.error("Failed to create default Admin account: " + Integer.toHexString(n));
            }
        }
        return !bl;
    }

    private void updateUserGroupMethodsAllowed(NISecurityDatabaseHelper nISecurityDatabaseHelper) {
        logger.debug_general("Updating allowed methods of user groups.");
        Vector vector = nISecurityDatabaseHelper.getAllUserGroupNames();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.get(n);
            NIUserGroupImpl nIUserGroupImpl = (NIUserGroupImpl)nISecurityDatabaseHelper.getUserGroup(string);
            if (nIUserGroupImpl != null) {
                nIUserGroupImpl.setAllowedMethods(NISecurityDefault.getMethodsForUserGroup(string));
                int n2 = nISecurityDatabaseHelper.updateUserGroup(nIUserGroupImpl);
                if (n2 != 0) {
                    logger.error("Failed to update group " + string + ": " + Integer.toHexString(n2));
                }
            } else {
                logger.error("Failed to query group: " + string);
            }
            ++n;
        }
    }

    private void shutdownDatabaseImplementation() {
        Properties properties = new Properties();
        properties.put("databaseName", SECURITY_DATABASE);
        properties.put("shutdown", "true");
        try {
            DriverManager.getConnection("jdbc:db2j:", properties);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    private void removeDatabaseImplementation(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    this.removeDatabaseImplementation(fileArray[n]);
                    ++n;
                }
                if (!file.getAbsolutePath().endsWith(SECURITY_DATABASE) && !file.delete()) {
                    logger.error("Failed to delete database dir: " + file.getAbsolutePath());
                }
            } else if (!file.delete()) {
                logger.error("Failed to delete security database file: " + file.getAbsolutePath());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

