/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.application.resource.NIUserGroup;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.resource.NIUserGroupImpl;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class NISecurityFileImplementation
extends NISecurityDatabaseHelper {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation == null ? (class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation = NISecurityFileImplementation.class$("com.ibm.storage.ess.ni.security.NISecurityFileImplementation")) : class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation);
    private static final String ACCOUNTS_FILE = NISecurityDatabaseManager.SECURITY_DATABASE_DIR + "userAccounts";
    private static final String GROUPS_FILE = NISecurityDatabaseManager.SECURITY_DATABASE_DIR + "userGroups";
    private static final String SETTINGS_FILE = NISecurityDatabaseManager.SECURITY_DATABASE_DIR + "securitySettings";
    private Vector accountsList;
    private Vector groupsList;
    private NISecurityTableEntry settingsEntry;
    private static NISecurityFileImplementation singletonInstance;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation;

    private NISecurityFileImplementation() {
        this.createSecurityDirectory();
        this.populateAccountsList();
        this.populateGroupsList();
        this.populateSettingsEntry();
    }

    public static NISecurityFileImplementation getSecurityFileImplementation() {
        if (singletonInstance == null) {
            singletonInstance = new NISecurityFileImplementation();
        }
        return singletonInstance;
    }

    protected synchronized boolean storeAccounts(Vector vector) {
        boolean bl = true;
        Vector vector2 = this.accountsList;
        this.accountsList = vector;
        this.clearSetMethods(this.accountsList);
        Collections.sort(this.accountsList);
        if (this.updateFile(new File(ACCOUNTS_FILE), this.accountsList)) {
            logger.debug_general("Successfully stored user accounts passed in.");
        } else {
            bl = false;
            this.accountsList = vector2;
            logger.error("Failed to store user accounts.");
        }
        return bl;
    }

    protected synchronized boolean storeGroups(Vector vector) {
        boolean bl = true;
        Vector vector2 = this.groupsList;
        this.groupsList = vector;
        this.clearSetMethods(this.groupsList);
        Collections.sort(this.groupsList);
        if (this.updateFile(new File(GROUPS_FILE), this.groupsList)) {
            logger.debug_general("Successfully stored user groups passed in.");
        } else {
            bl = false;
            this.groupsList = vector2;
            logger.error("Failed to store user groups.");
        }
        return bl;
    }

    protected synchronized boolean storeSecuritySettings(NISecurityTableEntry nISecurityTableEntry) {
        boolean bl = true;
        NISecurityTableEntry nISecurityTableEntry2 = this.settingsEntry;
        this.settingsEntry = nISecurityTableEntry;
        if (this.updateFile(new File(SETTINGS_FILE), this.settingsEntry)) {
            logger.debug_general("Successfully stored security settings passed in.");
        } else {
            bl = false;
            this.settingsEntry = nISecurityTableEntry2;
            logger.error("Failed to store security settings.");
        }
        return bl;
    }

    private void clearSetMethods(Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((NIResourceImpl)iterator.next()).clearSetMethods();
        }
    }

    private void createSecurityDirectory() {
        File file = new File(NISecurityDatabaseManager.SECURITY_DATABASE_DIR);
        if (!file.exists()) {
            logger.debug_general("Security directory does not exist. Creating it.");
            if (!file.mkdir()) {
                logger.error("Failed to create security dir: " + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAccountsList() {
        block6: {
            this.accountsList = new Vector(200);
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(Channels.newInputStream(new FileInputStream(ACCOUNTS_FILE).getChannel()));
                    this.accountsList = (Vector)objectInputStream.readObject();
                    Collections.sort(this.accountsList);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.debug_general("User accounts file does not exist");
                    this.useBackupFile(new File(ACCOUNTS_FILE), new File(ACCOUNTS_FILE + ".bak"));
                    Object var6_3 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                    this.closeStream(objectInputStream);
                    this.useBackupFile(new File(ACCOUNTS_FILE), new File(ACCOUNTS_FILE + ".bak"));
                    Object var6_4 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.throwable((Throwable)classNotFoundException);
                    Object var6_5 = null;
                    this.closeStream(objectInputStream);
                }
                Object var6_2 = null;
                this.closeStream(objectInputStream);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.closeStream(objectInputStream);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGroupsList() {
        block6: {
            this.groupsList = new Vector(20);
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(Channels.newInputStream(new FileInputStream(GROUPS_FILE).getChannel()));
                    this.groupsList = (Vector)objectInputStream.readObject();
                    Collections.sort(this.groupsList);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.debug_general("User groups file does not exist");
                    this.useBackupFile(new File(GROUPS_FILE), new File(GROUPS_FILE + ".bak"));
                    Object var6_3 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                    this.closeStream(objectInputStream);
                    this.useBackupFile(new File(GROUPS_FILE), new File(GROUPS_FILE + ".bak"));
                    Object var6_4 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.throwable((Throwable)classNotFoundException);
                    Object var6_5 = null;
                    this.closeStream(objectInputStream);
                }
                Object var6_2 = null;
                this.closeStream(objectInputStream);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.closeStream(objectInputStream);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettingsEntry() {
        block6: {
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(Channels.newInputStream(new FileInputStream(SETTINGS_FILE).getChannel()));
                    this.settingsEntry = (NISecurityTableEntry)objectInputStream.readObject();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.debug_general("Security settings file does not exist");
                    this.useBackupFile(new File(SETTINGS_FILE), new File(SETTINGS_FILE + ".bak"));
                    Object var6_3 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                    this.closeStream(objectInputStream);
                    this.useBackupFile(new File(SETTINGS_FILE), new File(SETTINGS_FILE + ".bak"));
                    Object var6_4 = null;
                    this.closeStream(objectInputStream);
                    break block6;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.throwable((Throwable)classNotFoundException);
                    Object var6_5 = null;
                    this.closeStream(objectInputStream);
                }
                Object var6_2 = null;
                this.closeStream(objectInputStream);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.closeStream(objectInputStream);
                throw throwable;
            }
        }
    }

    private void closeStream(ObjectInputStream objectInputStream) {
        block2: {
            if (objectInputStream == null) break block2;
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
            }
        }
    }

    private void useBackupFile(File file, File file2) {
        file.delete();
        if (file2.exists()) {
            logger.debug_general("Using backup file " + file2.getName());
            if (file2.renameTo(file)) {
                StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
                try {
                    Method method = (class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation == null ? (class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation = NISecurityFileImplementation.class$("com.ibm.storage.ess.ni.security.NISecurityFileImplementation")) : class$com$ibm$storage$ess$ni$security$NISecurityFileImplementation).getDeclaredMethod(stackTraceElementArray[1].getMethodName(), null);
                    method.invoke((Object)this, null);
                }
                catch (SecurityException securityException) {
                    logger.throwable((Throwable)securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.throwable((Throwable)noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.throwable((Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.throwable((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.throwable((Throwable)invocationTargetException);
                }
            } else {
                logger.error("Couldn't rename file!");
            }
        } else {
            logger.error("No backup file " + file2.getName());
        }
    }

    private boolean updateFile(File file, Object object) {
        boolean bl = true;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(Channels.newOutputStream(new FileOutputStream(file.getAbsolutePath()).getChannel()));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            objectOutputStream = null;
            this.backupFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.throwable((Throwable)fileNotFoundException);
            bl = false;
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            bl = false;
        }
        return bl;
    }

    private boolean backupFile(File file) {
        boolean bl;
        block2: {
            bl = false;
            if (!file.exists()) break block2;
            String string = file.getAbsolutePath() + ".bak";
            try {
                NISecurityFileImplementation.copyFile(file, new File(string));
                bl = true;
            }
            catch (IOException iOException) {
                logger.error("Failed to copy " + file.getName());
                logger.throwable((Throwable)iOException);
            }
        }
        return bl;
    }

    private boolean addToList(Vector vector, Object object) {
        boolean bl = true;
        int n = Collections.binarySearch(vector, object);
        if (n < 0) {
            int n2 = Math.abs(n + 1);
            ((NIResourceImpl)object).clearSetMethods();
            vector.add(n2, object);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean updateList(Vector vector, Object object) {
        boolean bl = true;
        int n = Collections.binarySearch(vector, object);
        if (n >= 0) {
            ((NIResourceImpl)object).clearSetMethods();
            vector.set(n, object);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean removeFromList(Vector vector, Object object) {
        boolean bl = true;
        int n = Collections.binarySearch(vector, object);
        if (n >= 0) {
            vector.remove(n);
        } else {
            bl = false;
        }
        return bl;
    }

    protected synchronized int insertUserAccount(NIUserAccount nIUserAccount) {
        int n = 0;
        if (this.accountsList.size() < 100) {
            if (this.addToList(this.accountsList, nIUserAccount)) {
                if (!this.updateFile(new File(ACCOUNTS_FILE), this.accountsList)) {
                    this.removeFromList(this.accountsList, nIUserAccount);
                    n = -1099689594;
                }
            } else {
                n = -1099689598;
            }
        } else {
            n = -1099689593;
        }
        return n;
    }

    protected synchronized int deleteUserAccount(String string) {
        int n = 0;
        NIUserAccount nIUserAccount = this.getUserAccount(string);
        if (this.removeFromList(this.accountsList, nIUserAccount)) {
            if (!this.updateFile(new File(ACCOUNTS_FILE), this.accountsList)) {
                this.addToList(this.accountsList, nIUserAccount);
                n = -1099689594;
            }
        } else {
            n = -1099689600;
        }
        return n;
    }

    protected synchronized int updateUserAccount(String string, NIUserAccount nIUserAccount) {
        int n = 0;
        NIUserAccount nIUserAccount2 = this.getUserAccount(nIUserAccount.getName());
        if (this.updateList(this.accountsList, nIUserAccount)) {
            if (!this.updateFile(new File(ACCOUNTS_FILE), this.accountsList)) {
                this.updateList(this.accountsList, nIUserAccount2);
                n = -1099689594;
            }
        } else {
            n = -1099689600;
        }
        return n;
    }

    public synchronized NIUserAccount getUserAccount(String string) {
        NIUserAccount nIUserAccount = null;
        int n = Collections.binarySearch(this.accountsList, new NIUserAccountImpl(string, ""));
        if (n >= 0) {
            nIUserAccount = (NIUserAccount)((NIUserAccountImpl)this.accountsList.get(n)).clone();
        }
        return nIUserAccount;
    }

    public synchronized Vector getAllUserAccounts() {
        Vector<Object> vector = new Vector<Object>(this.accountsList.size());
        Iterator iterator = this.accountsList.iterator();
        while (iterator.hasNext()) {
            vector.add(((NIUserAccountImpl)iterator.next()).clone());
        }
        return vector;
    }

    public synchronized Vector getAllUserAccountNames() {
        Vector<String> vector = new Vector<String>(this.accountsList.size());
        int n = 0;
        while (n < this.accountsList.size()) {
            vector.add(((NIUserAccount)this.accountsList.get(n)).getName());
            ++n;
        }
        return vector;
    }

    public synchronized int getNumUserAccounts() {
        return this.accountsList.size();
    }

    protected synchronized int insertUserGroup(NIUserGroup nIUserGroup) {
        int n = 0;
        if (this.addToList(this.groupsList, nIUserGroup)) {
            if (!this.updateFile(new File(GROUPS_FILE), this.groupsList)) {
                this.removeFromList(this.groupsList, nIUserGroup);
                n = -1099689594;
            }
        } else {
            n = -1099689591;
        }
        return n;
    }

    protected synchronized int deleteUserGroup(String string) {
        int n = 0;
        NIUserGroup nIUserGroup = this.getUserGroup(string);
        if (this.removeFromList(this.groupsList, nIUserGroup)) {
            if (!this.updateFile(new File(GROUPS_FILE), this.groupsList)) {
                this.addToList(this.groupsList, nIUserGroup);
                n = -1099689594;
            }
        } else {
            n = -1099689599;
        }
        return n;
    }

    protected synchronized int updateUserGroup(NIUserGroup nIUserGroup) {
        int n = 0;
        NIUserGroup nIUserGroup2 = this.getUserGroup(nIUserGroup.getName());
        if (this.updateList(this.groupsList, nIUserGroup)) {
            if (!this.updateFile(new File(GROUPS_FILE), this.groupsList)) {
                this.updateList(this.groupsList, nIUserGroup2);
                n = -1099689594;
            }
        } else {
            n = -1099689599;
        }
        return n;
    }

    public synchronized NIUserGroup getUserGroup(String string) {
        NIUserGroup nIUserGroup = null;
        int n = Collections.binarySearch(this.groupsList, new NIUserGroupImpl(string, "", new String[0]));
        if (n >= 0) {
            nIUserGroup = (NIUserGroup)((NIUserGroupImpl)this.groupsList.get(n)).clone();
        }
        return nIUserGroup;
    }

    public synchronized Vector getAllUserGroups() {
        Vector<Object> vector = new Vector<Object>(this.groupsList.size());
        Iterator iterator = this.groupsList.iterator();
        while (iterator.hasNext()) {
            vector.add(((NIUserGroupImpl)iterator.next()).clone());
        }
        return vector;
    }

    public synchronized Vector getAllUserGroupNames() {
        Vector<String> vector = new Vector<String>(this.groupsList.size());
        int n = 0;
        while (n < this.groupsList.size()) {
            vector.add(((NIUserGroup)this.groupsList.get(n)).getName());
            ++n;
        }
        return vector;
    }

    public synchronized int getNumUserGroups() {
        return this.groupsList.size();
    }

    protected synchronized int insertSecurityEntry(NISecurityTableEntry nISecurityTableEntry) {
        int n = 0;
        NISecurityTableEntry nISecurityTableEntry2 = this.settingsEntry;
        this.settingsEntry = nISecurityTableEntry;
        if (!this.updateFile(new File(SETTINGS_FILE), this.settingsEntry)) {
            this.settingsEntry = nISecurityTableEntry2;
            n = -1099689594;
        }
        return n;
    }

    protected synchronized int deleteSecurityEntry() {
        int n = 0;
        NISecurityTableEntry nISecurityTableEntry = this.settingsEntry;
        this.settingsEntry = null;
        if (!this.updateFile(new File(SETTINGS_FILE), this.settingsEntry)) {
            this.settingsEntry = nISecurityTableEntry;
            n = -1099689594;
        }
        return n;
    }

    protected synchronized int updateSecurityEntry(NISecurityTableEntry nISecurityTableEntry) {
        int n = 0;
        NISecurityTableEntry nISecurityTableEntry2 = this.settingsEntry;
        this.settingsEntry = nISecurityTableEntry;
        if (!this.updateFile(new File(SETTINGS_FILE), this.settingsEntry)) {
            this.settingsEntry = nISecurityTableEntry2;
            n = -1099689594;
        }
        return n;
    }

    public synchronized NISecurityTableEntry getSecurityEntry() {
        NISecurityTableEntry nISecurityTableEntry = null;
        if (this.settingsEntry != null) {
            nISecurityTableEntry = (NISecurityTableEntry)this.settingsEntry.clone();
        }
        return nISecurityTableEntry;
    }

    private static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        fileChannel.close();
        fileChannel2.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

