/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;

public class NICircularObjectBuffer {
    public static final int UNSPECIFIED_SIZE = -1;
    private static final int DEFAULT_SIZE = 1024;
    protected Object[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected boolean blockingWrite = false;
    protected boolean bufferClosed = false;
    protected volatile boolean fixedSize = true;

    public NICircularObjectBuffer() {
        this(1024, true);
    }

    public NICircularObjectBuffer(int n) {
        this(n, true);
    }

    public NICircularObjectBuffer(boolean bl) {
        this(1024, bl);
    }

    public NICircularObjectBuffer(int n, boolean bl) {
        if (n == -1) {
            this.buffer = new Object[1024];
            this.fixedSize = false;
        } else {
            this.buffer = new Object[n];
            this.fixedSize = true;
        }
        this.blockingWrite = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        NICircularObjectBuffer nICircularObjectBuffer = this;
        synchronized (nICircularObjectBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.bufferClosed = false;
        }
    }

    public int writeLimit() {
        if (this.writePosition < this.readPosition) {
            return this.readPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.readPosition);
    }

    public int readLimit() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        NICircularObjectBuffer nICircularObjectBuffer = this;
        synchronized (nICircularObjectBuffer) {
            return this.buffer.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws InterruptedException {
        while (true) {
            NICircularObjectBuffer nICircularObjectBuffer = this;
            synchronized (nICircularObjectBuffer) {
                int n = this.readLimit();
                if (n > 0) {
                    Object object = this.buffer[this.readPosition];
                    this.buffer[this.readPosition] = null;
                    ++this.readPosition;
                    if (this.readPosition == this.buffer.length) {
                        this.readPosition = 0;
                    }
                    return object;
                }
                if (this.bufferClosed) {
                    return null;
                }
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        NICircularObjectBuffer nICircularObjectBuffer = this;
        synchronized (nICircularObjectBuffer) {
            this.bufferClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        NICircularObjectBuffer nICircularObjectBuffer = this;
        synchronized (nICircularObjectBuffer) {
            this.bufferClosed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) throws NICircularBufferOverflowException, IllegalStateException, InterruptedException {
        boolean bl = false;
        while (!bl) {
            NICircularObjectBuffer nICircularObjectBuffer = this;
            synchronized (nICircularObjectBuffer) {
                if (this.bufferClosed) {
                    throw new IllegalStateException("NICircularObjectBuffer closed.");
                }
                int n = this.writeLimit();
                while (!this.fixedSize && n < 1) {
                    this.resize();
                    n = this.writeLimit();
                }
                if (!this.blockingWrite && n < 1) {
                    throw new NICircularBufferOverflowException("NICircularObjectBuffer is full.");
                }
                if (n > 0) {
                    this.buffer[this.writePosition] = object;
                    ++this.writePosition;
                    if (this.writePosition == this.buffer.length) {
                        this.writePosition = 0;
                    }
                    bl = true;
                }
            }
            if (bl) continue;
            Thread.sleep(100L);
        }
    }

    private void resize() {
        Object[] objectArray = new Object[this.buffer.length * 2];
        int n = this.readLimit();
        if (this.readPosition <= this.writePosition) {
            int n2 = this.writePosition - this.readPosition;
            System.arraycopy(this.buffer, this.readPosition, objectArray, 0, n2);
        } else {
            int n3 = this.buffer.length - this.readPosition;
            System.arraycopy(this.buffer, this.readPosition, objectArray, 0, n3);
            int n4 = this.writePosition;
            System.arraycopy(this.buffer, 0, objectArray, n3, n4);
        }
        this.buffer = objectArray;
        this.readPosition = 0;
        this.writePosition = n;
    }
}

