/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class NIMtmsParser {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$util$NIMtmsParser == null ? (class$com$ibm$storage$ess$ni$util$NIMtmsParser = NIMtmsParser.class$("com.ibm.storage.ess.ni.util.NIMtmsParser")) : class$com$ibm$storage$ess$ni$util$NIMtmsParser);
    private static String COMPANY = "IBM";
    public static final String UNKNOWN = "Unknown";
    private static int SERIAL_LENGTH = 5;
    private String mtms;
    private String type;
    private String model;
    private String sequence;
    private String manufactureplant;
    private int imageNumber;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$util$NIMtmsParser;

    public NIMtmsParser(String string, String string2) {
        this(string);
        this.model = string2;
    }

    public NIMtmsParser(String string) {
        int n = -1;
        this.mtms = string;
        try {
            n = string.indexOf(COMPANY);
        }
        catch (NullPointerException nullPointerException) {
            int n2;
            logger.warning("WARNING - COMPANY is " + COMPANY);
            if (string == null) {
                logger.warning("WARNING - mtms is NULL!!");
                n2 = -1;
            } else {
                n2 = string.length();
            }
            logger.warning("WARNING - NIMtmsParser constructor encountered NullPointerException");
            logger.warning("WARNING - The length of the mtms is " + n2);
            logger.warning("WARNING - mtms contents: \"" + string + "\"");
            logger.throwable((Throwable)nullPointerException);
            logger.warning("WARNING - Attempting workaround (successful if no exceptions follow)...");
            char[] cArray = string.toCharArray();
            if (cArray[0] == COMPANY.charAt(0) && cArray[1] == COMPANY.charAt(1) && cArray[2] == COMPANY.charAt(2)) {
                n = 0;
            }
            logger.warning("WARNING - Workaround succeeded (index=" + n + ")!!");
        }
        if (n != -1) {
            if (string.length() == 17) {
                this.parseSmMtms(string);
            } else {
                this.parseEssniMts(string);
            }
        } else {
            this.parseRasMtms(string);
        }
    }

    private void parseSmMtms(String string) {
        try {
            this.type = string.substring(3, 7);
            this.model = string.substring(7, 10);
            this.manufactureplant = string.substring(10, 12);
            this.sequence = string.substring(12);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.type = UNKNOWN;
            this.model = UNKNOWN;
            this.manufactureplant = UNKNOWN;
            this.sequence = UNKNOWN;
            this.imageNumber = 0;
        }
    }

    private void parseRasMtms(String string) {
        try {
            this.type = string.substring(0, 4);
            this.model = string.substring(5, 8);
            this.manufactureplant = string.substring(9, 11);
            this.sequence = string.substring(11);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.type = UNKNOWN;
            this.model = UNKNOWN;
            this.manufactureplant = UNKNOWN;
            this.sequence = UNKNOWN;
            this.imageNumber = 0;
        }
    }

    private void parseEssniMts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".-");
        try {
            stringTokenizer.nextToken();
            this.type = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            this.manufactureplant = string2.substring(0, 2);
            this.sequence = string2.substring(2);
            try {
                this.imageNumber = Integer.parseInt(string2.substring(6), 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.imageNumber = 0;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.type = UNKNOWN;
            this.model = UNKNOWN;
            this.manufactureplant = UNKNOWN;
            this.sequence = UNKNOWN;
            this.imageNumber = 0;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.type = UNKNOWN;
            this.model = UNKNOWN;
            this.manufactureplant = UNKNOWN;
            this.sequence = UNKNOWN;
            this.imageNumber = 0;
            return;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    public String getManufacturePlant() {
        return this.manufactureplant;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public String getSmString() {
        return "IBM" + this.type + (this.model != null ? this.model : "%%%") + this.manufactureplant + this.sequence;
    }

    public String getRASString() {
        return this.type + "-" + (this.model != null ? this.model : "%%%") + "*" + this.manufactureplant + this.sequence;
    }

    public String getESSNIString() {
        return "IBM." + this.type + "-" + this.manufactureplant + this.sequence;
    }

    public String toString() {
        return this.getESSNIString();
    }

    public static String convertEssSequenceToSFSequence(String string) {
        String string2 = "";
        string2 = string.substring(0, string.length() - 1);
        string2 = string2 + "0";
        return string2;
    }

    public static String convertSFSequenceToEssSequence(String string, int n) {
        String string2;
        if (string == null) {
            string2 = null;
        } else {
            string2 = string.substring(0, string.length() - 1);
            string2 = string2 + Integer.toHexString(n).toUpperCase();
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

