/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.pf;

import com.ibm.storage.ess.pf.PF;
import com.ibm.storage.ess.pf.PFCommand;
import com.ibm.storage.ess.pf.PFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class PFDaemon
extends Thread {
    public static int PF_DAEMON_PORT = 5678;
    private boolean running = true;
    private ServerSocket serverSocket;
    private int portNumber = PF_DAEMON_PORT;
    private Vector forwarders = new Vector();
    private boolean verbose = false;

    public PFDaemon(boolean bl) {
        super("PFDaemon");
        this.verbose = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block46: {
            var1_1 = null;
            var5_2 = false;
            try {
                if (this.verbose) {
                    System.out.println("creating server socket");
                }
                this.serverSocket = new ServerSocket(this.portNumber);
            }
            catch (IOException var6_3) {
                System.out.println("[ERROR]PFDaemon: unable to open socket on port" + this.portNumber + " exiting.");
                System.exit(0);
            }
            catch (Exception var7_8) {
                if (!this.verbose) break block46;
                var7_8.printStackTrace();
            }
        }
        block35: while (this.running) {
            try {
                if (this.verbose) {
                    System.out.println("accepting server socket");
                }
                var1_1 = this.serverSocket.accept();
                var3_16 = new ObjectInputStream(var1_1.getInputStream());
                var2_15 = (PFCommand)var3_16.readObject();
                switch (var2_15.type) {
                    case 0: {
                        if (!this.verbose) ** break;
                        System.out.println("PFDaemon: Stop command not yet supported");
                        ** break;
lbl28:
                        // 1 sources

                        continue block35;
                    }
                    case 1: {
                        if (this.verbose) {
                            System.out.println("PFDaemon: received forward command");
                        }
                        var6_4 = this.forwarders.iterator();
                        var5_2 = false;
                        while (var6_4.hasNext()) {
                            var4_17 = (PF)var6_4.next();
                            if (this.verbose) {
                                System.out.println("looking for a match, forwarder is using port [" + var4_17.getLocalPort() + "]");
                                System.out.println("we are trying to use port [" + var2_15.localPort + "]");
                            }
                            if (var4_17.getLocalPort().compareTo(var2_15.localPort) != 0) continue;
                            var5_2 = true;
                            try {
                                var4_17.modify(var2_15.remoteIP, var2_15.remotePort, this.verbose, var2_15.allowedHosts);
                            }
                            catch (PFException var7_10) {
                                System.out.println("Exception thrown when trying to modify forward:");
                                var7_10.printStackTrace();
                            }
                        }
                        if (var5_2) ** break;
                        try {
                            var4_17 = new PF(var2_15.localPort, var2_15.remoteIP, var2_15.remotePort, this.verbose, var2_15.allowedHosts);
                            this.forwarders.add(var4_17);
                            var4_17.start();
                            ** break;
lbl55:
                            // 1 sources

                        }
                        catch (PFException var7_11) {
                            System.out.println("Exception thrown when trying to create forward:");
                            var7_11.printStackTrace();
                            ** break;
                        }
lbl60:
                        // 1 sources

                        continue block35;
                    }
                    case 2: {
                        if (this.verbose) {
                            System.out.println("PFDaemon: received close command");
                        }
                        this.running = false;
                        var6_4 = this.forwarders.iterator();
                        while (var6_4.hasNext()) {
                            var4_17 = (PF)var6_4.next();
                            var4_17.terminate();
                        }
                        continue block35;
                    }
                    ** default:
lbl72:
                    // 1 sources

                    continue block35;
                }
            }
            catch (IOException var6_6) {
                System.out.println("[ERROR]PFDaemon: Caught IOException while reading from stream... closing socket");
                if (this.verbose) {
                    var6_6.printStackTrace();
                }
                if (var1_1 == null) continue;
                try {
                    var1_1.close();
                }
                catch (IOException var7_12) {
                    if (!this.verbose) continue;
                    var7_12.printStackTrace();
                }
            }
            catch (ClassNotFoundException var7_14) {
                System.out.println("[ERROR]PFDaemon: Deserialization error... either bad jar or uncooperative client. Exiting.");
                if (this.verbose) {
                    var7_14.printStackTrace();
                }
                System.exit(0);
            }
            catch (Exception var8_20) {
                if (!this.verbose) continue;
                var8_20.printStackTrace();
            }
            finally {
                block47: {
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var7_13) {
                            if (!this.verbose) break block47;
                            var7_13.printStackTrace();
                        }
                    }
                }
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException var6_7) {
            System.out.println("IOException received when closing server socket");
            var6_7.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage:  ");
        System.out.println("to run the PFDaemon:");
        System.out.println("   java PFDaemon run [-verbose]");
        System.out.println("to forward a port (the -allow option restricts the sources that are allowed to connect to the given IPs):");
        System.out.println("   java PFDaemon forward <local port> <remote host> <remote port> [-allow <host 1> ... <host n>]");
        System.out.println("to shutdown the PFDaemon (and stop forwarding any ports):");
        System.out.println("   java PFDaemon stop");
    }

    public static void main(String[] stringArray) {
        block11: {
            PFCommand pFCommand;
            block12: {
                block10: {
                    pFCommand = null;
                    if (stringArray.length >= 1) break block10;
                    PFDaemon.printUsage();
                    break block11;
                }
                if (stringArray[0].compareTo("run") != 0 && stringArray[0].compareTo("-run") != 0) break block12;
                boolean bl = false;
                if (stringArray.length == 2 && (stringArray[1].compareTo("-verbose") == 0 || stringArray[1].compareTo("verbose") == 0)) {
                    bl = true;
                }
                PFDaemon pFDaemon = new PFDaemon(bl);
                pFDaemon.start();
                System.out.println("*****PFDaemon started*****");
                break block11;
            }
            if (stringArray[0].compareTo("forward") == 0 || stringArray[0].compareTo("-forward") == 0) {
                if (stringArray.length > 4 && (stringArray[4].compareTo("allow") == 0 || stringArray[4].compareTo("-allow") == 0)) {
                    String[] stringArray2 = new String[stringArray.length - 5];
                    System.arraycopy(stringArray, 5, stringArray2, 0, stringArray2.length);
                    pFCommand = new PFCommand(1, stringArray[1], stringArray[2], stringArray[3], stringArray2);
                } else if (stringArray.length == 4) {
                    pFCommand = new PFCommand(1, stringArray[1], stringArray[2], stringArray[3], null);
                } else {
                    PFDaemon.printUsage();
                }
            } else if (stringArray[0].compareTo("kill") == 0 || stringArray[0].compareTo("-kill") == 0 || stringArray[0].compareTo("stop") == 0 || stringArray[0].compareTo("-stop") == 0) {
                pFCommand = new PFCommand(2, null, null, null, null);
            }
            if (pFCommand == null) break block11;
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), PF_DAEMON_PORT);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                objectOutputStream.writeObject(pFCommand);
                objectOutputStream.flush();
                objectOutputStream.close();
                socket.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: could not connect, PFDaemon is probably not running");
                System.out.println("Try starting the PFDaemon (using the run command) and trying again.");
                iOException.printStackTrace();
                System.exit(0);
            }
        }
    }
}

