/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.clientImpl;

public class CircularBuffer {
    Object[] m_elements = new Object[256];
    int m_pos;
    int m_end;

    private void grow() {
        Object[] objectArray = this.m_elements;
        this.m_elements = new Object[2 * this.m_elements.length];
        if (this.m_pos <= this.m_end) {
            int n = this.m_pos;
            while (n < this.m_end) {
                this.m_elements[n] = objectArray[n];
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_end) {
                this.m_elements[n] = objectArray[n];
                ++n;
            }
            n = this.m_pos;
            while (n < objectArray.length) {
                this.m_elements[n + objectArray.length] = objectArray[n];
                ++n;
            }
            this.m_pos += objectArray.length;
        }
    }

    public synchronized void push(Object object) {
        if (this.m_end == this.m_elements.length) {
            if (this.m_pos == 0) {
                this.grow();
            } else {
                this.m_end = 0;
            }
            this.m_elements[this.m_end++] = object;
            return;
        }
        if (this.m_pos <= this.m_end) {
            this.m_elements[this.m_end++] = object;
            return;
        }
        if (this.m_end == this.m_pos - 1) {
            this.grow();
        }
        this.m_elements[this.m_end++] = object;
    }

    public boolean isEmpty() {
        return this.m_pos == this.m_end;
    }

    public Object pop() {
        if (this.m_pos == this.m_end) {
            return null;
        }
        Object object = this.m_elements[this.m_pos++];
        if (this.m_pos == this.m_elements.length && this.m_pos != this.m_end) {
            this.m_pos = 0;
        }
        return object;
    }
}

