/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.meta;

import com.ibm.bsf.debug.jsdi.JsCallbacks;
import com.ibm.bsf.debug.jsdi.JsContext;
import com.ibm.bsf.debug.jsdi.JsEngine;
import com.ibm.bsf.debug.jsdi.JsObject;
import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.Dispatcher;
import com.ibm.bsf.debug.util.ResultCell;
import com.ibm.bsf.debug.util.SocketConnection;

public class JsEngineDispatcher
extends Dispatcher {
    public JsEngineDispatcher(SocketConnection socketConnection) {
        super(socketConnection);
    }

    public void dispatch(ResultCell resultCell) throws Exception {
        JsEngine jsEngine = (JsEngine)((Object)resultCell.selfSkel);
        switch (resultCell.methodId) {
            case 900: {
                resultCell.booleanResult(true);
                break;
            }
            case 411: {
                JsCallbacks jsCallbacks = (JsCallbacks)resultCell.readObject();
                jsEngine.setDebugger(jsCallbacks);
                resultCell.voidResult();
                break;
            }
            case 401: {
                int n = resultCell.readInt();
                DebugLog.stdoutPrintln("\tdepth=" + n, 3);
                JsContext jsContext = jsEngine.getContext(n);
                DebugLog.stdoutPrintln("\tcx=" + jsContext, 3);
                resultCell.objectResult(jsContext);
                break;
            }
            case 402: {
                int n = jsEngine.getContextCount();
                resultCell.intResult(n);
                break;
            }
            case 412: {
                String string = jsEngine.getThread();
                resultCell.objectResult(string);
                break;
            }
            case 413: {
                String string = jsEngine.getThreadGroup();
                resultCell.objectResult(string);
                break;
            }
            case 404: {
                jsEngine.run();
                resultCell.voidResult();
                break;
            }
            case 405: {
                jsEngine.stepIn();
                resultCell.voidResult();
                break;
            }
            case 406: {
                jsEngine.stepOut();
                resultCell.voidResult();
                break;
            }
            case 407: {
                jsEngine.stepOver();
                resultCell.voidResult();
                break;
            }
            case 409: {
                JsObject jsObject = jsEngine.getGlobalObject();
                resultCell.objectResult(jsObject);
                break;
            }
            case 410: {
                JsObject jsObject = jsEngine.getUndefinedValue();
                resultCell.objectResult(jsObject);
            }
        }
    }
}

