/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.serverImpl;

import com.ibm.bsf.debug.meta.DebugManagerDispatcher;
import com.ibm.bsf.debug.meta.JsContextDispatcher;
import com.ibm.bsf.debug.meta.JsEngineDispatcher;
import com.ibm.bsf.debug.meta.JsObjectDispatcher;
import com.ibm.bsf.debug.serverImpl.GatedListener;
import com.ibm.bsf.debug.serverImpl.ServerStubTable;
import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.Dispatcher;
import com.ibm.bsf.debug.util.ResultCell;
import com.ibm.bsf.debug.util.SocketConnection;
import com.ibm.bsf.util.BSFDebugManagerImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ObjectServer
extends SocketConnection
implements Runnable {
    public Dispatcher[] fDispatchers;
    private BSFDebugManagerImpl fDebugManager;
    private Thread m_thread;
    private boolean m_outStreamLocked = false;
    private boolean m_ready = false;
    private Object m_outStreamLock = new Object();
    private Object m_readyLock = new Object();
    private static GatedListener m_listener;

    public ObjectServer(BSFDebugManagerImpl bSFDebugManagerImpl, int n) {
        this.fDebugManager = bSFDebugManagerImpl;
        this.exportSkeleton(bSFDebugManagerImpl);
        if (n <= 0) {
            n = 4444;
        }
        this.m_thread = new Thread((Runnable)this, "JSDI Server Thread");
        this.m_thread.start();
        if (m_listener != null) {
            DebugLog.stdoutPrintln("BSF Debug Listener instantiated already.", 1);
        } else {
            m_listener = new GatedListener(this, n);
        }
    }

    public BSFDebugManagerImpl getDebugManager() {
        return this.fDebugManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.fDispatchers = new Dispatcher[4];
        this.fDispatchers[0] = new DebugManagerDispatcher(this);
        this.fDispatchers[1] = new JsEngineDispatcher(this);
        this.fDispatchers[2] = new JsContextDispatcher(this);
        this.fDispatchers[3] = new JsObjectDispatcher(this);
        this.fStubs = new ServerStubTable(this);
        this.exportSkeleton(this.fDebugManager);
        while (true) {
            Object object = this.m_readyLock;
            synchronized (object) {
                block6: {
                    try {
                        if (this.m_ready) break block6;
                        this.m_readyLock.wait();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                this.m_ready = false;
            }
            this.listen();
            m_listener.awake();
        }
    }

    protected void setIOStreams(InputStream inputStream, OutputStream outputStream, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        this.fInputStream = inputStream;
        this.fOutputStream = outputStream;
        this.fDataInputStream = dataInputStream;
        this.fDataOutputStream = dataOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awake() {
        Object object = this.m_readyLock;
        synchronized (object) {
            this.m_ready = true;
            this.m_readyLock.notify();
        }
    }

    protected void dispatchInvocation(ResultCell resultCell) throws Exception {
        switch (resultCell.classId) {
            case 104: {
                this.fDispatchers[0].dispatch(resultCell);
                break;
            }
            case 105: {
                this.fDispatchers[1].dispatch(resultCell);
                break;
            }
            case 106: {
                this.fDispatchers[2].dispatch(resultCell);
                break;
            }
            case 107: {
                this.fDispatchers[3].dispatch(resultCell);
                break;
            }
            default: {
                throw new Error("Wire Protocol Format Error");
            }
        }
    }
}

