/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.util;

import com.ibm.bsf.debug.jsdi.JsEngine;
import com.ibm.bsf.debug.util.DebugConstants;
import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.Skeleton;
import com.ibm.bsf.debug.util.SocketConnection;
import com.ibm.bsf.debug.util.Stub;
import com.ibm.bsf.debug.util.ThreadCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public class ResultCell {
    public int val32;
    public long val64;
    public float fval;
    public double dval;
    public Object oval;
    public boolean bool;
    private Exception exception;
    private byte[] stackTraceBytes;
    public int tid;
    public int uid;
    public int classId;
    public int methodId;
    public int cmdId;
    public int waitingForCode;
    public ThreadCell thread;
    public ResultCell parent;
    public JsEngine engine;
    public Stub selfStub;
    public Skeleton selfSkel;
    public boolean done;
    public boolean disconnected;
    private SocketConnection m_con;
    private DataOutputStream fDataOutputStream;
    private DataInputStream fDataInputStream;
    private ByteArrayInputStream fInPacket;
    private ByteArrayOutputStream fOutPacket;

    public void print() {
        DebugLog.stdoutPrintln("ResultCell...", 3);
        DebugLog.stdoutPrintln("\ttid=" + DebugConstants.getConstantName(this.tid), 3);
        DebugLog.stdoutPrintln("\tclassId [" + this.classId + "] =" + DebugConstants.getConstantName(this.classId), 3);
        DebugLog.stdoutPrintln("\tmethodId [" + this.methodId + "] =" + DebugConstants.getConstantName(this.methodId), 3);
        DebugLog.stdoutPrintln("\tbool=" + this.bool, 3);
        DebugLog.stdoutPrintln("\tval32=" + this.val32, 3);
        DebugLog.stdoutPrintln("\tval64=" + this.val64, 3);
        DebugLog.stdoutPrintln("\tfval=" + this.fval, 3);
        DebugLog.stdoutPrintln("\tdval=" + this.dval, 3);
        DebugLog.stdoutPrintln("\toval=" + this.oval, 3);
        DebugLog.stdoutPrintln("\texception=" + this.exception, 3);
        DebugLog.stdoutPrintln("\t\tmessage=" + this.exception.getMessage(), 3);
        DebugLog.stdoutPrintln("\t\tstack trace:", 3);
        DebugLog.stdoutPrintln(new String(this.stackTraceBytes), 3);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println(exception.getMessage());
        exception.printStackTrace(printStream);
        this.stackTraceBytes = byteArrayOutputStream.toByteArray();
    }

    public void writeException() throws IOException {
        this.writeObject(this.exception);
        this.writeObject(this.stackTraceBytes);
    }

    public void readException() throws IOException {
        this.exception = (Exception)this.readObject();
        this.stackTraceBytes = (byte[])this.readObject();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ResultCell...\n");
        stringBuffer.append("\ttid=" + DebugConstants.getConstantName(this.tid) + "\n");
        stringBuffer.append("\tclassId [" + this.classId + "] =" + DebugConstants.getConstantName(this.classId) + "\n");
        stringBuffer.append("\tmethodId [" + this.methodId + "] =" + DebugConstants.getConstantName(this.methodId) + "\n");
        stringBuffer.append("\tbool=" + this.bool + "\n");
        stringBuffer.append("\tval32=" + this.val32 + "\n");
        stringBuffer.append("\tval64=" + this.val64 + "\n");
        stringBuffer.append("\tfval=" + this.fval + "\n");
        stringBuffer.append("\tdval=" + this.dval + "\n");
        stringBuffer.append("\toval=" + this.oval + "\n");
        stringBuffer.append("\texception=" + this.exception + "\n");
        stringBuffer.append("\t\tmessage=" + this.exception.getMessage() + "\n");
        return stringBuffer.toString();
    }

    ResultCell(SocketConnection socketConnection) throws IOException {
        this.m_con = socketConnection;
    }

    void outgoingInvocation(int n, int n2, int n3, Stub stub) throws IOException {
        this.done = false;
        this.cmdId = n;
        this.classId = n2;
        this.methodId = n3;
        this.selfStub = stub;
        this.fOutPacket = new ByteArrayOutputStream();
        this.fDataOutputStream = new DataOutputStream(this.fOutPacket);
        this.fInPacket = null;
        this.fDataInputStream = null;
        this.writeId(n2);
        this.writeId(n3);
        this.writeObject(stub);
    }

    void incomingInvocation(int n, byte[] byArray) throws IOException {
        this.done = false;
        this.cmdId = n;
        this.fInPacket = new ByteArrayInputStream(byArray);
        this.fDataInputStream = new DataInputStream(this.fInPacket);
        this.fOutPacket = new ByteArrayOutputStream();
        this.fDataOutputStream = new DataOutputStream(this.fOutPacket);
        this.classId = this.readId();
        this.methodId = this.readId();
        this.selfSkel = (Skeleton)this.readObject();
        DebugLog.stdoutPrintln("\t" + DebugConstants.getConstantName(this.classId) + "::" + DebugConstants.getConstantName(this.methodId), 3);
        DebugLog.stdoutPrintln("\ton " + this.selfSkel, 3);
    }

    public void setPacketBytes(byte[] byArray) {
        this.fInPacket = new ByteArrayInputStream(byArray);
        this.fDataInputStream = new DataInputStream(this.fInPacket);
        this.fOutPacket = new ByteArrayOutputStream();
        this.fDataOutputStream = new DataOutputStream(this.fOutPacket);
    }

    public void completionNotify() {
        if (this.thread != null) {
            this.thread.completionNotify(this);
        }
    }

    public void parseResult() {
        try {
            this._parseResult();
        }
        catch (Exception exception) {
            this.m_con.wireExceptionNotify(exception);
        }
    }

    public void sendResult() {
        try {
            this._sendResult();
        }
        catch (Exception exception) {
            this.m_con.wireExceptionNotify(exception);
        }
    }

    private void _parseResult() throws Exception {
        switch (this.waitingForCode) {
            case 50: {
                break;
            }
            case 51: {
                this.bool = this.readBoolean();
                break;
            }
            case 52: {
                this.val32 = this.readInt();
                break;
            }
            case 53: {
                this.val64 = this.readLong();
                break;
            }
            case 54: {
                this.fval = this.readFloat();
                break;
            }
            case 55: {
                double d = this.readDouble();
                break;
            }
            case 56: {
                this.oval = this.readObject();
                break;
            }
            default: {
                throw new Error("Error in the request/answer protocol");
            }
        }
    }

    private void _sendResult() throws Exception {
        if (this.exception != null) {
            DebugLog.stdoutPrintln("\n**** Exception occurred while invoking...", 0);
            DebugLog.stdoutPrintln("\tmessage is " + this.exception.getMessage(), 0);
            this.exception.printStackTrace();
            this.fOutPacket = new ByteArrayOutputStream();
            this.fDataOutputStream = new DataOutputStream(this.fOutPacket);
            this.writeException();
            byte[] byArray = this.fOutPacket.toByteArray();
            this.m_con.sendPacket(this.thread.getThId(), this.cmdId, true, byArray, true);
            DebugLog.stdoutPrintln("\tException has been sent back...", 0);
            return;
        }
        switch (this.waitingForCode) {
            case 50: {
                break;
            }
            case 51: {
                this.writeBoolean(this.bool);
                break;
            }
            case 52: {
                this.writeInt(this.val32);
                break;
            }
            case 53: {
                this.writeLong(this.val64);
                break;
            }
            case 54: {
                this.writeFloat(this.fval);
                break;
            }
            case 55: {
                this.writeDouble(this.dval);
                break;
            }
            case 56: {
                this.writeObject(this.oval);
                break;
            }
            default: {
                throw new Error("Error in the request/answer protocol");
            }
        }
        byte[] byArray = this.fOutPacket.toByteArray();
        this.m_con.sendPacket(this.thread.getThId(), this.cmdId, true, byArray, false);
    }

    public void sendInvocation() throws Exception {
        byte[] byArray = this.fOutPacket.toByteArray();
        this.m_con.sendPacket(this.thread.getThId(), this.cmdId, false, byArray, false);
    }

    public void voidResult() {
        this.waitingForCode = 50;
    }

    public void booleanResult(boolean bl) {
        this.bool = bl;
        this.waitingForCode = 51;
    }

    public void intResult(int n) {
        this.val32 = n;
        this.waitingForCode = 52;
    }

    public void longResult(long l) {
        this.val64 = l;
        this.waitingForCode = 53;
    }

    public void floatResult(float f) {
        this.fval = f;
        this.waitingForCode = 54;
    }

    public void doubleResult(double d) {
        this.dval = d;
        this.waitingForCode = 55;
    }

    public void objectResult(Object object) {
        this.oval = object;
        this.waitingForCode = 56;
    }

    public void writeBoolean(boolean bl) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling bool" + bl, 3);
        this.fDataOutputStream.writeBoolean(bl);
    }

    public void writeId(int n) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling id=" + DebugConstants.getConstantName(n), 3);
        this.fDataOutputStream.writeInt(n);
    }

    public void writeInt(int n) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling int " + n, 3);
        this.fDataOutputStream.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling long " + l, 3);
        this.fDataOutputStream.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling float " + f, 3);
        this.fDataOutputStream.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        DebugLog.stdoutPrintln("\tmarshalling double " + d, 3);
        this.fDataOutputStream.writeDouble(d);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            DebugLog.stdoutPrintln("\tmarshalling null object ", 3);
            this.fDataOutputStream.writeInt(99);
        } else if (object instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)object;
            this.m_con.exportSkeleton(skeleton);
            DebugLog.stdoutPrintln("\tmarshalling (iid=" + skeleton.getTid() + ";uid=" + skeleton.getUid() + " skeleton= " + skeleton, 3);
            this.fDataOutputStream.writeInt(102);
            this.fDataOutputStream.writeInt(skeleton.getTid());
            this.fDataOutputStream.writeInt(skeleton.getUid());
        } else if (object instanceof Stub) {
            Stub stub = (Stub)object;
            DebugLog.stdoutPrintln("\tmarshalling (tid=" + this.tid + ";uid=" + stub.getUid() + " stub= " + stub, 3);
            this.fDataOutputStream.writeInt(101);
            this.fDataOutputStream.writeInt(stub.getUid());
        } else {
            DebugLog.stdoutPrintln("Connection marshalling value object " + object, 3);
            this.fDataOutputStream.writeInt(100);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.fOutPacket);
            objectOutputStream.writeObject(object);
        }
    }

    public boolean readBoolean() throws IOException {
        boolean bl = this.fDataInputStream.readBoolean();
        DebugLog.stdoutPrintln("Connection marshalling boolean " + bl, 3);
        return bl;
    }

    public int readId() throws IOException {
        int n = this.fDataInputStream.readInt();
        DebugLog.stdoutPrintln("\tUnmarshalling id=[" + DebugConstants.getConstantName(n) + " (" + n + ")", 3);
        return n;
    }

    public int readInt() throws IOException {
        int n = this.fDataInputStream.readInt();
        DebugLog.stdoutPrintln("\tUnmarshalling int " + n, 3);
        return n;
    }

    public long readLong() throws IOException {
        long l = this.fDataInputStream.readLong();
        DebugLog.stdoutPrintln("\tUnmarshalling long " + l, 3);
        return l;
    }

    public float readFloat() throws IOException {
        float f = this.fDataInputStream.readFloat();
        DebugLog.stdoutPrintln("\tUnmarshalling float " + f, 3);
        return f;
    }

    public double readDouble() throws IOException {
        double d = this.fDataInputStream.readDouble();
        DebugLog.stdoutPrintln("\tUnmarshalling double " + d, 3);
        return d;
    }

    public Object readObject() throws IOException {
        Object object = null;
        DebugLog.stdoutPrintln("\tUnmarshalling an object...", 3);
        int n = this.fDataInputStream.readInt();
        switch (n) {
            case 99: {
                object = null;
                DebugLog.stdoutPrintln("\t\tnull object", 3);
                break;
            }
            case 100: {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.fInPacket);
                    object = objectInputStream.readObject();
                    DebugLog.stdoutPrintln("\t\tvalue object= " + object, 3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = null;
                }
                break;
            }
            case 101: {
                int n2 = this.fDataInputStream.readInt();
                object = this.m_con.getSkeleton(n2);
                DebugLog.stdoutPrintln("\t\tLocal skel object= " + object + "(uid=" + n2 + ")", 3);
                break;
            }
            case 102: {
                int n3 = this.fDataInputStream.readInt();
                int n4 = this.fDataInputStream.readInt();
                object = this.m_con.getStub(n3, n4);
                DebugLog.stdoutPrintln("\t\tLocal stub object= " + object + "(tid=" + n3 + "; uid=" + n4 + ")", 3);
                break;
            }
            default: {
                throw new Error("Wire Protocol Error: unknown object format.");
            }
        }
        return object;
    }

    public Object waitForValueObject() throws Exception {
        this.waitingForCode = 56;
        this.thread.waitOnCompletion(this);
        return this.oval;
    }

    public boolean waitForBooleanValue() throws Exception {
        this.waitingForCode = 51;
        this.thread.waitOnCompletion(this);
        return this.bool;
    }

    public int waitForIntValue() throws Exception {
        this.waitingForCode = 52;
        this.thread.waitOnCompletion(this);
        return this.val32;
    }

    public long waitForLongValue() throws Exception {
        this.waitingForCode = 53;
        this.thread.waitOnCompletion(this);
        return this.val64;
    }

    public float waitForFloatValue() throws Exception {
        this.waitingForCode = 54;
        this.thread.waitOnCompletion(this);
        return this.fval;
    }

    public double waitForDoubleValue() throws Exception {
        this.waitingForCode = 55;
        this.thread.waitOnCompletion(this);
        return this.dval;
    }

    public void waitForCompletion() throws Exception {
        this.waitingForCode = 50;
        this.thread.waitOnCompletion(this);
    }

    public Object waitForObject() throws Exception {
        this.waitingForCode = 56;
        this.thread.waitOnCompletion(this);
        return this.oval;
    }
}

