/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.util;

import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.RemoteService;
import com.ibm.bsf.debug.util.RemoteServiceListener;
import com.ibm.bsf.debug.util.SocketConnection;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class Stub
implements RemoteService {
    public static Stub UNDEFINED;
    public static Stub NOT_FOUND;
    protected int m_tid;
    protected int m_uid;
    protected boolean m_revoked;
    protected SocketConnection m_con;
    private Vector m_listeners;
    private static Object m_futureLock;
    private Vector m_futureCells = new Vector();

    public static void Init(SocketConnection socketConnection) {
        UNDEFINED = new Stub(socketConnection, 5, 7);
        NOT_FOUND = new Stub(socketConnection, 5, 6);
    }

    public Stub(SocketConnection socketConnection, int n, int n2) {
        this.m_con = socketConnection;
        this.m_tid = n;
        this.m_uid = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Stub) {
            return this.m_uid == ((Stub)object).m_uid;
        }
        return false;
    }

    public int getTid() {
        return this.m_tid;
    }

    public int getUid() {
        return this.m_uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoked() {
        DebugLog.stdoutPrintln("Revoking a stub " + this, 3);
        this.m_revoked = true;
        if (this.m_listeners == null) {
            return;
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            RemoteServiceListener remoteServiceListener = (RemoteServiceListener)enumeration.nextElement();
            remoteServiceListener.revokedNotify(this);
        }
        FutureCell futureCell = null;
        RemoteException remoteException = new RemoteException("Lost connection... stub revoked");
        DebugLog.stdoutPrintln("\trevoking futures...", 3);
        Object object = m_futureLock;
        synchronized (object) {
            enumeration = this.m_futureCells.elements();
            while (enumeration.hasMoreElements()) {
                futureCell = (FutureCell)enumeration.nextElement();
                DebugLog.stdoutPrintln("\t\trevoking for requester " + futureCell.requester, 3);
                futureCell.resume = true;
                futureCell.ex = remoteException;
                m_futureLock.notifyAll();
            }
            DebugLog.stdoutPrintln("\tDone with futures.", 3);
            this.m_futureCells = new Vector();
        }
    }

    public SocketConnection getConnection() {
        return this.m_con;
    }

    public Stub swizzle(int n, int n2) {
        return this.m_con.swizzle(n, n2);
    }

    public void addListener(RemoteServiceListener remoteServiceListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        this.m_listeners.addElement(remoteServiceListener);
    }

    public void removeListener(RemoteServiceListener remoteServiceListener) {
        if (this.m_listeners != null) {
            this.m_listeners.removeElement(remoteServiceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFuture(Object object) throws RemoteException {
        DebugLog.stdoutPrintln("Creating future for requester " + object + " on " + this, 3);
        try {
            Object object2 = m_futureLock;
            synchronized (object2) {
                FutureCell futureCell;
                Enumeration enumeration = this.m_futureCells.elements();
                while (enumeration.hasMoreElements()) {
                    futureCell = (FutureCell)enumeration.nextElement();
                    if (futureCell.requester != object) continue;
                    throw new Exception("Can't create multiple future on same requester.");
                }
                futureCell = new FutureCell();
                futureCell.requester = object;
                futureCell.thread = Thread.currentThread();
                futureCell.resume = false;
                this.m_futureCells.addElement(futureCell);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Error in future management", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendFuture(Object object) throws RemoteException {
        FutureCell futureCell = null;
        DebugLog.stdoutPrintln("Suspending on future for requester " + object + " on " + this, 3);
        try {
            Object object2 = m_futureLock;
            synchronized (object2) {
                futureCell = this.findFuture(object);
                DebugLog.stdoutPrintln("Suspending future for " + futureCell.requester + " on thread " + futureCell.thread + " on " + this, 3);
                if (!futureCell.resume & !this.m_revoked) {
                    while (true) {
                        try {
                            do {
                                m_futureLock.wait(1000L);
                            } while (!futureCell.resume && !this.m_revoked);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                this.m_futureCells.removeElement(futureCell);
                if (futureCell.ex != null) {
                    DebugLog.stdoutPrintln("Future for " + futureCell.requester + " on thread " + futureCell.thread + " throwing Exception " + futureCell.ex, 3);
                    throw futureCell.ex;
                }
                DebugLog.stdoutPrintln("Future for " + futureCell.requester + " on thread " + futureCell.thread + " resuming...", 3);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Error in future management", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFuture(Object object) throws RemoteException {
        FutureCell futureCell = null;
        DebugLog.stdoutPrintln("Completing future for requester " + object + " on " + this, 3);
        try {
            Object object2 = m_futureLock;
            synchronized (object2) {
                futureCell = this.findFuture(object);
                DebugLog.stdoutPrintln("Waking up future for requester " + object + " on " + this, 3);
                futureCell.resume = true;
                m_futureLock.notifyAll();
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Error in future management", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeFuture(Object object, Exception exception) throws Exception {
        FutureCell futureCell = null;
        DebugLog.stdoutPrintln("revoking future for requester " + object + " on " + this, 3);
        try {
            Object object2 = m_futureLock;
            synchronized (object2) {
                futureCell = this.findFuture(object);
                DebugLog.stdoutPrintln("Waking up future for requester " + object + " on " + this, 3);
                futureCell.resume = true;
                futureCell.ex = exception;
                m_futureLock.notifyAll();
            }
        }
        catch (Exception exception2) {
            throw new RemoteException("Error in future management", exception2);
        }
    }

    private FutureCell findFuture(Object object) throws Exception {
        FutureCell futureCell = null;
        DebugLog.stdoutPrintln("finding future for requester " + object + " on " + this, 3);
        Enumeration enumeration = this.m_futureCells.elements();
        while (enumeration.hasMoreElements()) {
            futureCell = (FutureCell)enumeration.nextElement();
            if (futureCell.requester != object) continue;
            return futureCell;
        }
        DebugLog.stdoutPrintln("Non-existant future for requester " + object, 2);
        throw new Exception("Non-existant future for requester " + object);
    }

    static {
        m_futureLock = new Object();
    }

    class FutureCell {
        Object requester;
        Thread thread;
        boolean resume;
        Exception ex;

        FutureCell() {
        }
    }
}

