/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.util;

import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.IntHashtable;
import com.ibm.bsf.debug.util.SocketConnection;
import com.ibm.bsf.debug.util.Stub;
import java.util.Enumeration;

public abstract class StubTable {
    protected IntHashtable m_stubs;
    protected SocketConnection m_con;

    public StubTable(SocketConnection socketConnection) {
        this.m_con = socketConnection;
        this.m_stubs = new IntHashtable();
    }

    public void disconnectNotify() {
        DebugLog.stdoutPrintln("Revoking stubs...", 3);
        Enumeration enumeration = this.m_stubs.elements();
        while (enumeration.hasMoreElements()) {
            Stub stub = (Stub)enumeration.nextElement();
            stub.revoked();
        }
        this.m_stubs = new IntHashtable();
    }

    protected abstract Stub factory(int var1, int var2);

    public synchronized Stub swizzle(int n, int n2) {
        Stub stub = null;
        if (n2 == 6) {
            return Stub.NOT_FOUND;
        }
        if (n2 == 7) {
            return Stub.UNDEFINED;
        }
        stub = (Stub)this.m_stubs.get(n2);
        if (stub == null) {
            stub = this.factory(n, n2);
            this.m_stubs.put(n2, stub);
        }
        return stub;
    }
}

