/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.debug.util;

import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.debug.util.ResultCell;
import com.ibm.bsf.debug.util.SocketConnection;

public class ThreadCell
implements Runnable {
    private static int ThreadIdGenerator = 0;
    static boolean isServer;
    Thread m_thread;
    Object m_streamLock = new Object();
    Object m_waitLock = new Object();
    ResultCell m_stack;
    int m_thid;
    boolean m_loopback;
    SocketConnection m_con;
    boolean m_started;

    ThreadCell(SocketConnection socketConnection, Thread thread) {
        this.m_con = socketConnection;
        this.m_thid = isServer ? ++ThreadIdGenerator : --ThreadIdGenerator;
        this.m_thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ThreadCell(SocketConnection socketConnection, int n) {
        this.m_thread = new Thread((Runnable)this, "BSF Thread " + n);
        this.m_started = false;
        this.m_thread.start();
        Object object = this.m_waitLock;
        synchronized (object) {
            while (!this.m_started) {
                try {
                    this.m_waitLock.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.m_con = socketConnection;
        this.m_thid = n;
        this.m_stack = null;
    }

    int getThId() {
        return this.m_thid;
    }

    Thread getThread() {
        return this.m_thread;
    }

    public synchronized void run() {
        boolean bl = true;
        this.m_started = true;
        while (bl) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                continue;
            }
            if (!this.m_loopback) continue;
            this.m_loopback = false;
            this.execTopStack();
            try {
                this.popInvocation(null, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void execTopStack() {
        try {
            this.m_con.dispatchInvocation(this.m_stack);
        }
        catch (Exception exception) {
            DebugLog.stderrPrintln("\nException Raised in loopback...", 3);
            this.m_stack.setException(exception);
        }
        this.m_stack.sendResult();
    }

    public synchronized void waitOnCompletion(ResultCell resultCell) throws Exception {
        if (resultCell != this.m_stack) {
            throw new Error("About to wait for completion, but not on the top of the stack...");
        }
        resultCell.sendInvocation();
        while (!resultCell.done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_loopback) {
                this.m_loopback = false;
                this.execTopStack();
                this.popInvocation(this.m_stack, true);
                continue;
            }
            if (this.m_stack.done) break;
        }
        this.popInvocation(resultCell, false);
    }

    public synchronized void completionNotify(ResultCell resultCell) {
        resultCell.done = true;
        if (resultCell.disconnected) {
            this.m_thread.interrupt();
        }
        this.notify();
    }

    public synchronized void pushLoopback(ResultCell resultCell) {
        this.pushInvocation(resultCell);
        this.m_loopback = true;
        this.notify();
    }

    public synchronized void pushInvocation(ResultCell resultCell) {
        resultCell.thread = this;
        resultCell.parent = this.m_stack;
        this.m_stack = resultCell;
    }

    private synchronized ResultCell popInvocation(ResultCell resultCell, boolean bl) throws Exception {
        Exception exception;
        if (this.m_stack == null) {
            throw new Error("***** Unpaired Push/Pop.");
        }
        if (resultCell == null) {
            if (this.m_stack.parent != null) {
                throw new Error("***** Not popping last frame...");
            }
            resultCell = this.m_stack;
            this.m_stack = null;
        } else {
            if (this.m_stack != resultCell) {
                throw new Error("***** Popping but not top of stack.");
            }
            this.m_stack = resultCell.parent;
        }
        if (!bl && (exception = resultCell.getException()) != null) {
            throw exception;
        }
        return resultCell;
    }

    static {
        ThreadIdGenerator = (int)System.currentTimeMillis();
        isServer = Boolean.getBoolean("com.ibm.bsf.isServer");
    }
}

