/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.jacl;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.engines.jacl.BSFCommand;
import com.ibm.bsf.util.BSFEngineImpl;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class JaclEngine
extends BSFEngineImpl {
    private Interp interp;

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(" ");
                stringBuffer.append(objectArray[n].toString());
                ++n;
            }
        }
        return this.eval("<function call>", 0, 0, stringBuffer.toString());
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        String string = "set " + bSFDeclaredBean.name + " [bsf lookupBean \"" + bSFDeclaredBean.name + "\"]";
        this.eval("<declare bean>", 0, 0, string);
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        try {
            this.interp.eval(string2);
            TclObject tclObject = this.interp.getResult();
            InternalRep internalRep = tclObject.getInternalRep();
            if (internalRep instanceof ReflectObject) {
                return ReflectObject.get((Interp)this.interp, (TclObject)tclObject);
            }
            if (internalRep instanceof TclString) {
                return tclObject.toString();
            }
            if (internalRep instanceof TclDouble) {
                return new Double(TclDouble.get((Interp)this.interp, (TclObject)tclObject));
            }
            if (internalRep instanceof TclInteger) {
                return new Integer(TclInteger.get((Interp)this.interp, (TclObject)tclObject));
            }
            return tclObject;
        }
        catch (TclException tclException) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "error while eval'ing Jacl expression: " + this.interp.getResult(), tclException);
        }
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.interp = new Interp();
        this.interp.createCommand("bsf", (Command)new BSFCommand(bSFManager, this));
        try {
            this.interp.eval("jaclloadjava");
        }
        catch (TclException tclException) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "error while loading java package: " + this.interp.getResult(), tclException);
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.declareBean((BSFDeclaredBean)vector.elementAt(n2));
            ++n2;
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.eval("<undeclare bean>", 0, 0, "set " + bSFDeclaredBean.name + " \"\"");
    }
}

