/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.javascript;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.engines.javascript.BreakPoint;
import com.ibm.bsf.engines.javascript.CompilationUnit;
import com.ibm.bsf.engines.javascript.DocumentCell;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public class FnOrScript {
    protected DocumentCell m_cell;
    protected boolean m_lineDefined;
    protected int m_startLine;
    protected int m_lineCount;
    protected int m_column;
    protected int m_offset;
    protected int m_charCount;
    protected Vector m_breakpoints;
    protected StringBuffer m_text;
    protected Vector m_units;
    protected Script m_script;
    protected Hashtable m_functionMap;

    public FnOrScript(DocumentCell documentCell) {
        this.m_cell = documentCell;
        this.m_lineDefined = true;
        this.m_startLine = -1;
        this.m_column = -1;
        this.m_lineCount = 0;
        this.m_breakpoints = new Vector();
        this.m_text = new StringBuffer();
        this.m_units = new Vector();
        this.m_functionMap = new Hashtable();
    }

    private BreakPoint _addBreakpoint(BreakPoint breakPoint) {
        breakPoint = this.createBreakpoint(breakPoint);
        this.m_breakpoints.addElement(breakPoint);
        return breakPoint;
    }

    public BreakPoint addBreakpoint(BreakPoint breakPoint) {
        this.m_breakpoints.addElement(breakPoint);
        Enumeration enumeration = this.m_units.elements();
        while (enumeration.hasMoreElements()) {
            CompilationUnit compilationUnit = (CompilationUnit)enumeration.nextElement();
            if (!compilationUnit.contains(breakPoint)) continue;
            breakPoint.setUnit(compilationUnit);
            breakPoint.propagate();
            break;
        }
        return breakPoint;
    }

    private BreakPoint _removeBreakpoint(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getId()) continue;
            this.m_breakpoints.removeElement(breakPoint);
            return breakPoint;
        }
        return null;
    }

    public BreakPoint removeBreakpoint(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getId()) continue;
            this.m_breakpoints.removeElement(breakPoint);
            breakPoint.unpropagate();
            return breakPoint;
        }
        return null;
    }

    boolean contains(BreakPoint breakPoint) throws BSFException {
        if (this.m_lineDefined) {
            int n = breakPoint.getLineNo();
            return this.m_startLine <= n && n < this.m_startLine + this.m_lineCount;
        }
        int n = breakPoint.getOffset();
        return this.m_offset <= n && n < this.m_offset + this.m_charCount;
    }

    protected BreakPoint createBreakpoint(BreakPoint breakPoint) {
        return breakPoint;
    }

    public BreakPoint findBreakpointAtLine(int n) throws BSFException {
        if (!this.m_lineDefined) {
            throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
        }
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getLineNo()) continue;
            return breakPoint;
        }
        return null;
    }

    public BreakPoint findBreakpointAtOffset(int n) throws BSFException {
        if (this.m_lineDefined) {
            throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with lines, offsets are not supported.");
        }
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getOffset()) continue;
            return breakPoint;
        }
        return null;
    }

    public int getCharCount() throws BSFException {
        if (!this.m_lineDefined) {
            return this.m_charCount;
        }
        throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
    }

    public DocumentCell getDocument() {
        return this.m_cell;
    }

    public int getFirstLine() throws BSFException {
        if (this.m_lineDefined) {
            return this.m_startLine;
        }
        throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
    }

    public int getColumn() throws BSFException {
        if (this.m_lineDefined) {
            return this.m_column;
        }
        throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
    }

    public StringBuffer getFnOrScriptAsStringBuffer() {
        return this.m_text;
    }

    public int getLineCount() throws BSFException {
        if (this.m_lineDefined) {
            return this.m_lineCount;
        }
        throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
    }

    public int getOffset() throws BSFException {
        if (!this.m_lineDefined) {
            return this.m_offset;
        }
        throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Function or Script is defined with ranges, lines are not supported.");
    }

    private void readChars(Reader reader) {
        char[] cArray = new char[256];
        int n = 0;
        int n2 = 0;
        try {
            while ((n2 = reader.read(cArray, 0, 256)) != -1) {
                this.m_text.append(cArray, 0, n2);
                n += n2;
            }
            this.m_charCount = n;
        }
        catch (IOException iOException) {}
    }

    private void readLines(Reader reader) {
        String string;
        char[] cArray = new char[256];
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= cArray.length) {
                char[] cArray2 = cArray;
                cArray = new char[2 * cArray.length];
                System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            }
            try {
                n3 = reader.read();
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) break;
            char c = (char)n3;
            cArray[n2++] = c;
            if (c != '\n') continue;
            string = new String(cArray, 0, n2);
            this.m_text.append(string);
            n2 = 0;
            ++n;
        }
        if (n2 != 0) {
            string = new String(cArray, 0, n2);
            this.m_text.append(string);
            ++n;
        }
        this.m_lineCount = n;
    }

    public void specifyLinesPos(Reader reader, int n, int n2) throws BSFException, IOException {
        this.m_startLine = n;
        this.m_column = n2;
        this.m_lineCount = -1;
        this.m_charCount = -1;
        this.m_offset = -1;
        this.m_lineDefined = true;
        this.readLines(reader);
    }

    public void specifyRange(Reader reader, int n) throws BSFException, IOException {
        this.m_offset = n;
        this.m_charCount = -1;
        this.m_startLine = -1;
        this.m_lineCount = -1;
        this.m_lineDefined = false;
        this.readChars(reader);
    }

    public void addCompilationUnit(Context context, DebuggableScript debuggableScript, StringBuffer stringBuffer) {
        CompilationUnit compilationUnit = new CompilationUnit(this, debuggableScript);
        this.m_units.addElement(compilationUnit);
        if (compilationUnit.m_fnName != null) {
            this.m_functionMap.put(compilationUnit.m_fnName, compilationUnit);
        }
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (!compilationUnit.contains(breakPoint)) continue;
            breakPoint.setUnit(compilationUnit);
        }
        this.propagateAll();
    }

    public void compile(Context context, Scriptable scriptable) throws BSFException, IOException {
        StringReader stringReader = new StringReader(this.m_text.toString());
        this.m_script = context.compileReader(scriptable, (Reader)stringReader, this.m_cell.getName(), this.m_startLine, null);
        if (this.m_script == null) {
            throw new BSFException("Compilation of the script " + this.m_cell.getName() + " failed at line " + this.m_startLine);
        }
    }

    boolean contains(CompilationUnit compilationUnit) {
        return this.m_startLine <= compilationUnit.m_firstLine && compilationUnit.m_firstLine + compilationUnit.m_lineCount <= this.m_startLine + this.m_lineCount;
    }

    public Script getScript() {
        return this.m_script;
    }

    private void propagateAll() {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            breakPoint.propagate();
        }
    }
}

