/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.javascript;

import com.ibm.bsf.engines.javascript.JsContextStub;
import com.ibm.bsf.engines.javascript.RhinoEngineDebugger;
import java.rmi.RemoteException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableEngine;

public class RhinoContextProxy {
    RhinoEngineDebugger m_reDbg;
    Context m_context;
    JsContextStub m_contextStub;
    DebuggableEngine m_engine;
    boolean m_atBreakpoint;
    int m_frameCount;
    JsContextStub[] m_frames;
    private static final int NO_STEP = 0;
    private static final int STEP_IN = 1;
    private static final int STEP_OVER = 2;
    private static final int STEP_OUT = 3;
    private static final int STOP_ENGINE = 4;
    private static final int RUNNING = 5;
    private int m_stepCmd;
    private int m_stepDepth;

    RhinoContextProxy(RhinoEngineDebugger rhinoEngineDebugger, Context context) {
        this.m_reDbg = rhinoEngineDebugger;
        this.m_context = context;
        this.m_engine = context.getDebuggableEngine();
    }

    public void cancelStepping() {
        this.m_stepCmd = 0;
        this.m_stepDepth = -1;
        this.m_engine.setBreakNextLine(false);
    }

    public JsContextStub getContext(int n) {
        return this.m_frames[n];
    }

    public int getContextCount() {
        return this.m_frameCount;
    }

    public JsContextStub getFrame(int n) {
        if (n < 0 || n > this.m_frameCount) {
            return null;
        }
        if (n == this.m_frameCount) {
            return this.m_contextStub;
        }
        return this.m_frames[n];
    }

    public int getLineNumber() {
        DebugFrame debugFrame = this.m_engine.getFrame(0);
        return debugFrame.getLineNumber();
    }

    public RhinoEngineDebugger getRhinoEngineDebugger() {
        return this.m_reDbg;
    }

    String getSourceName() {
        DebugFrame debugFrame = this.m_engine.getFrame(0);
        return debugFrame.getSourceName();
    }

    public JsContextStub hitBreakpoint() throws RemoteException {
        this.cancelStepping();
        this.updateStack();
        return this.m_frames[0];
    }

    public JsContextStub exceptionThrown() throws RemoteException {
        this.cancelStepping();
        this.updateStack();
        return this.m_frames[0];
    }

    public void resumed() {
        this.m_atBreakpoint = false;
        int n = 0;
        while (n < this.m_frameCount) {
            JsContextStub jsContextStub = this.m_frames[n];
            jsContextStub.atBreakpoint(false);
            ++n;
        }
    }

    public void run() {
        this.m_engine.setBreakNextLine(false);
        this.m_stepCmd = 5;
        this.m_stepDepth = -1;
    }

    public void stepIn() {
        this.m_engine.setBreakNextLine(true);
        this.m_stepCmd = 1;
        this.m_stepDepth = this.m_frameCount;
    }

    public void stepOut() {
        this.m_engine.setBreakNextLine(true);
        this.m_stepCmd = 3;
        this.m_stepDepth = this.m_frameCount;
    }

    public void stepOver() {
        this.m_engine.setBreakNextLine(true);
        this.m_stepCmd = 2;
        this.m_stepDepth = this.m_frameCount;
    }

    public JsContextStub entry_exit_mode() throws RemoteException {
        this.cancelStepping();
        this.updateStack();
        return this.m_frames[0];
    }

    public JsContextStub stepping() {
        int n = this.m_engine.getFrameCount();
        try {
            switch (this.m_stepCmd) {
                case 0: {
                    this.cancelStepping();
                    break;
                }
                case 4: {
                    this.updateStack();
                    this.cancelStepping();
                    return this.m_frames[0];
                }
                case 1: {
                    this.updateStack();
                    this.cancelStepping();
                    return this.m_frames[0];
                }
                case 2: {
                    if (n <= this.m_stepDepth) {
                        this.updateStack();
                        this.cancelStepping();
                        return this.m_frames[0];
                    }
                    break;
                }
                case 3: {
                    if (n < this.m_stepDepth) {
                        this.updateStack();
                        this.cancelStepping();
                        return this.m_frames[0];
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown command.");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.cancelStepping();
        }
        return null;
    }

    public void stopEngine() {
        this.m_engine.setBreakNextLine(true);
        this.m_stepCmd = 4;
        this.m_stepDepth = -1;
    }

    public void updateStack() throws RemoteException {
        DebugFrame debugFrame;
        int n = this.m_engine.getFrameCount();
        JsContextStub[] jsContextStubArray = new JsContextStub[n];
        this.m_atBreakpoint = true;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && n3 < this.m_frameCount) {
            debugFrame = this.m_engine.getFrame(n2);
            if (debugFrame != this.m_frames[n3].m_frame) break;
            jsContextStubArray[n2] = this.m_frames[n3];
            ++n2;
            ++n3;
        }
        while (n3 < this.m_frameCount) {
            this.m_reDbg.dropStub(this.m_frames[n3].m_frame);
            this.m_frames[n3].invalidate();
            ++n3;
        }
        while (n2 < n) {
            debugFrame = this.m_engine.getFrame(n2);
            jsContextStubArray[n2] = new JsContextStub(this, debugFrame, n2);
            ++n2;
        }
        this.m_frames = jsContextStubArray;
        this.m_frameCount = n;
    }
}

