/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.javascript;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.debug.jsdi.JsCallbacks;
import com.ibm.bsf.debug.jsdi.JsContext;
import com.ibm.bsf.debug.jsdi.JsObject;
import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.engines.javascript.BreakPoint;
import com.ibm.bsf.engines.javascript.DocumentCell;
import com.ibm.bsf.engines.javascript.FnOrScript;
import com.ibm.bsf.engines.javascript.JavaScriptEngine;
import com.ibm.bsf.engines.javascript.JsContextStub;
import com.ibm.bsf.engines.javascript.JsEngineStub;
import com.ibm.bsf.engines.javascript.JsObjectStub;
import com.ibm.bsf.engines.javascript.RhinoContextProxy;
import com.ibm.bsf.util.BSFDebugManagerImpl;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoEngineDebugger
implements Debugger {
    private Scriptable global;
    private JsObject globalstub;
    private RhinoContextProxy m_rcp;
    private Scriptable undefined;
    private JsObject undefinedStub;
    private Hashtable stubs;
    private JsCallbacks m_callbacks;
    private JsEngineStub engineStub;
    private FnOrScript m_compilingFnOrScript;
    private JavaScriptEngine m_eng;
    private Thread m_thread = Thread.currentThread();
    private Hashtable m_documents;
    BSFDebugManagerImpl dbgmgr;

    public RhinoEngineDebugger(JavaScriptEngine javaScriptEngine) throws RemoteException {
        this.m_eng = javaScriptEngine;
        this.dbgmgr = javaScriptEngine.getDebugManager();
        this.m_documents = new Hashtable();
        this.stubs = new Hashtable();
        this.m_callbacks = null;
        this.engineStub = new JsEngineStub(this);
    }

    public void disconnectedDebuggerNotify() {
        this.m_callbacks = null;
    }

    void addStub(Context context, RhinoContextProxy rhinoContextProxy) {
        this.stubs.put(context, rhinoContextProxy);
    }

    void addStub(DebugFrame debugFrame, JsContextStub jsContextStub) {
        this.stubs.put(debugFrame, jsContextStub);
    }

    void addStub(Scriptable scriptable, JsObject jsObject) {
        this.stubs.put(scriptable, jsObject);
    }

    void dropStub(Object object) {
        this.stubs.remove(object);
    }

    public synchronized DocumentCell getDocumentCell(String string) {
        return (DocumentCell)this.m_documents.get(string);
    }

    public synchronized DocumentCell loadDocumentNotify(String string) {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        if (documentCell == null) {
            documentCell = new DocumentCell(this, string);
            this.m_documents.put(string, documentCell);
            if (this.dbgmgr != null) {
                this.dbgmgr.loadDocumentNotify(this.m_eng, string);
            }
        }
        return documentCell;
    }

    public synchronized void placeBreakpointAtLine(int n, String string, int n2) {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        documentCell.addBreakpointAtLine(n, n2);
    }

    public synchronized void placeBreakpointAtOffset(int n, String string, int n2) {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        documentCell.addBreakpointAtOffset(n, n2);
    }

    public void removeBreakpoint(String string, int n) throws BSFException {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        documentCell.removeBreakpoint(n);
    }

    public void setEntryExit(String string, boolean bl) throws BSFException {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        documentCell.setEntryExit(bl);
    }

    public Object eval(String string, String string2, int n) throws RemoteException {
        try {
            Object object = this.m_eng.eval(string, n, -1, string2);
            return this.marshallProperty(object);
        }
        catch (BSFException bSFException) {
            throw new RemoteException("Failed eval", bSFException);
        }
    }

    public JsContext getContext(int n) {
        if (this.m_rcp != null) {
            return this.m_rcp.getContext(n);
        }
        return null;
    }

    public int getContextCount() {
        if (this.m_rcp != null) {
            return this.m_rcp.getContextCount();
        }
        return -1;
    }

    public JsCallbacks getDebugger() {
        return this.m_callbacks;
    }

    public Object getDebugInterface() {
        return this.engineStub;
    }

    public JsObject getGlobalObject() {
        return this.globalstub;
    }

    public RhinoContextProxy getRhinoContextProxy() {
        return this.m_rcp;
    }

    RhinoContextProxy getStub(Context context) {
        return (RhinoContextProxy)this.stubs.get(context);
    }

    JsContextStub getStub(DebugFrame debugFrame) {
        return (JsContextStub)this.stubs.get(debugFrame);
    }

    JsObject getStub(Scriptable scriptable) {
        return (JsObject)this.stubs.get(scriptable);
    }

    public JsObject getUndefinedValue() {
        return this.undefinedStub;
    }

    public String getThread() {
        String string;
        block2: {
            string = "";
            if (this.m_thread == null) break block2;
            try {
                String string2;
                string = string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return RhinoEngineDebugger.this.m_thread.getName();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                string = "Security Exception triggered. Thread info unavailable";
            }
        }
        return string;
    }

    public String getThreadGroup() {
        String string;
        block2: {
            string = "";
            if (this.m_thread == null) break block2;
            try {
                String string2;
                string = string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return RhinoEngineDebugger.this.m_thread.getThreadGroup().getName();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                string = "Security Exception triggered. ThreadGroup info unavailable";
            }
        }
        return string;
    }

    public void handleBreakpointHit(Context context) {
        boolean bl = false;
        boolean bl2 = false;
        this.m_thread = Thread.currentThread();
        DebugLog.stdoutPrintln("**** Handling a breakpoint hit...", 3);
        this.m_rcp = this.getStub(context);
        if (this.m_rcp == null) {
            this.m_rcp = new RhinoContextProxy(this, context);
            this.addStub(context, this.m_rcp);
        }
        if (this.m_callbacks == null) {
            DebugLog.stdoutPrintln("\tNo callbacks, resuming...", 3);
            this.m_rcp.run();
        } else {
            String string = this.m_rcp.getSourceName();
            int n = this.m_rcp.getLineNumber();
            DebugLog.stdoutPrintln("\tin " + string + " at " + n, 3);
            DocumentCell documentCell = this.getDocumentCell(string);
            if (documentCell != null) {
                this._handleBreakpointHit(documentCell, n);
            }
        }
        this.m_rcp = null;
    }

    public void _handleBreakpointHit(DocumentCell documentCell, int n) {
        block15: {
            BreakPoint breakPoint;
            JsContextStub jsContextStub = null;
            boolean bl = false;
            boolean bl2 = false;
            try {
                breakPoint = documentCell.findBreakpointAtLine(n);
            }
            catch (BSFException bSFException) {
                breakPoint = null;
            }
            if (breakPoint != null) {
                bl = true;
                try {
                    jsContextStub = this.m_rcp.hitBreakpoint();
                    DebugLog.stdoutPrintln("\tbreakpoint callback...", 3);
                    this.m_callbacks.createFuture(this.m_rcp);
                    this.m_callbacks.handleBreakpointHit(jsContextStub);
                    bl2 = true;
                }
                catch (RemoteException remoteException) {
                    DebugLog.stderrPrintln("\tEXCEPTION OCCURED DURING BREAKPOINT CALLBACK", 0);
                    DebugLog.stderrPrintln(remoteException.getMessage(), 0);
                    remoteException.printStackTrace();
                    bl2 = false;
                }
            } else {
                DebugLog.stdoutPrintln("\tdidn't find a breakpoint...", 3);
                bl = false;
            }
            if (!bl) {
                try {
                    jsContextStub = this.m_rcp.stepping();
                    FnOrScript fnOrScript = documentCell.findFnOrScriptContaining(n);
                    if (jsContextStub != null) {
                        documentCell.setLastFnOrScript(fnOrScript);
                        DebugLog.stdoutPrintln("\tstepping-done callback...", 3);
                        this.m_callbacks.createFuture(this.m_rcp);
                        this.m_callbacks.handleSteppingDone(jsContextStub);
                        bl2 = true;
                    } else if (documentCell.getEntryExit() && fnOrScript != documentCell.getLastFnOrScript() && this.m_rcp.getContextCount() == 0) {
                        documentCell.setLastFnOrScript(fnOrScript);
                        jsContextStub = this.m_rcp.entry_exit_mode();
                        DebugLog.stdoutPrintln("    entry/exit mode...", 3);
                        this.m_callbacks.createFuture(this.m_rcp);
                        this.m_callbacks.handleSteppingDone(jsContextStub);
                        bl2 = true;
                    } else {
                        DebugLog.stdoutPrintln("\tNo reason to suspend execution.", 3);
                        bl2 = false;
                    }
                }
                catch (RemoteException remoteException) {
                    DebugLog.stderrPrintln("\tEXCEPTION OCCURED DURING STEPPING-DONE CALLBACK", 0);
                    DebugLog.stderrPrintln(remoteException.getMessage(), 0);
                    remoteException.printStackTrace();
                    bl2 = false;
                }
            }
            if (!bl2) break block15;
            try {
                this.m_callbacks.suspendFuture(this.m_rcp);
            }
            catch (Exception exception) {
                DebugLog.stdoutPrintln("Future creation failed... releasing the engine", 3);
                this.m_rcp.run();
            }
        }
    }

    public void run(JsEngineStub jsEngineStub) throws Exception {
        DebugLog.stdoutPrintln("RhinoEngineDebugger::run()...", 3);
        this.m_rcp.run();
        this.m_callbacks.completeFuture(this.m_rcp);
    }

    public void stepIn(JsEngineStub jsEngineStub) throws Exception {
        DebugLog.stdoutPrintln("RhinoEngineDebugger::stepIn()...", 3);
        this.m_rcp.stepIn();
        this.m_callbacks.completeFuture(this.m_rcp);
    }

    public void stepOut(JsEngineStub jsEngineStub) throws Exception {
        DebugLog.stdoutPrintln("RhinoEngineDebugger::stepOut()...", 3);
        this.m_rcp.stepOut();
        this.m_callbacks.completeFuture(this.m_rcp);
    }

    public void stepOver(JsEngineStub jsEngineStub) throws Exception {
        DebugLog.stdoutPrintln("RhinoEngineDebugger::stepOver()...", 3);
        this.m_rcp.stepOver();
        this.m_callbacks.completeFuture(this.m_rcp);
    }

    public void handleCompilationDone(Context context, DebuggableScript debuggableScript, StringBuffer stringBuffer) {
        this.m_thread = Thread.currentThread();
        this.m_compilingFnOrScript.addCompilationUnit(context, debuggableScript, stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleExceptionThrown(Context context, Object object) {
        block10: {
            block9: {
                this.m_thread = Thread.currentThread();
                this.m_rcp = this.getStub(context);
                if (this.m_rcp == null) {
                    this.m_rcp = new RhinoContextProxy(this, context);
                    this.addStub(context, this.m_rcp);
                }
                try {
                    String string;
                    if (this.m_callbacks == null) {
                        this.m_rcp.run();
                        Object var15_3 = null;
                        this.m_rcp = null;
                        return;
                    }
                    String string2 = this.m_rcp.getSourceName();
                    int n = this.m_rcp.getLineNumber();
                    try {
                        NativeError nativeError = (NativeError)object;
                        string = nativeError.getName() + ": " + nativeError.getMessage();
                    }
                    catch (ClassCastException classCastException) {
                        string = "Unknown JavaScript Exception";
                    }
                    Exception exception = new Exception(string);
                    DocumentCell documentCell = this.getDocumentCell(string2);
                    if (documentCell == null) {
                        break block9;
                    }
                    try {
                        JsContextStub jsContextStub = this.m_rcp.exceptionThrown();
                        this.m_callbacks.createFuture(this.m_rcp);
                        this.m_callbacks.handleExceptionThrown(jsContextStub, exception);
                        this.m_callbacks.suspendFuture(this.m_rcp);
                    }
                    catch (Exception exception2) {
                        this.m_rcp.run();
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var15_6 = null;
                    this.m_rcp = null;
                    throw throwable;
                }
            }
            Object var15_4 = null;
            this.m_rcp = null;
            return;
        }
        Object var15_5 = null;
        this.m_rcp = null;
    }

    Object marshallProperty(Object object) throws RemoteException {
        if (object == null) {
            return null;
        }
        if (object == Scriptable.NOT_FOUND) {
            return null;
        }
        if (object == Context.getUndefinedValue()) {
            return this.undefinedStub;
        }
        if (object instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object;
            JsObject jsObject = this.getStub(scriptable);
            if (jsObject == null) {
                jsObject = new JsObjectStub(this, scriptable);
                this.addStub(scriptable, jsObject);
            }
            return jsObject;
        }
        return object;
    }

    JsObject marshallScriptable(Scriptable scriptable) throws RemoteException {
        if (scriptable == null) {
            return null;
        }
        if (scriptable == Scriptable.NOT_FOUND) {
            return null;
        }
        if (scriptable == Context.getUndefinedValue()) {
            return this.undefinedStub;
        }
        Scriptable scriptable2 = scriptable;
        JsObject jsObject = this.getStub(scriptable2);
        if (jsObject == null) {
            jsObject = new JsObjectStub(this, scriptable2);
            this.addStub(scriptable2, jsObject);
        }
        return jsObject;
    }

    public void setBreakNextLine(JsContext jsContext, boolean bl) {
    }

    void setCompilingFnOrScript(FnOrScript fnOrScript) {
        this.m_compilingFnOrScript = fnOrScript;
    }

    public void setDebugger(JsCallbacks jsCallbacks) {
        this.m_callbacks = jsCallbacks;
    }
}

