/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletResponse;

public class ConnectionStream
implements Runnable {
    protected Thread running;
    protected InputStream input;
    protected OutputStream output;
    protected byte[] buf = new byte[2048];
    protected ServletResponse response;
    protected boolean busy = true;

    public ConnectionStream(InputStream inputStream, OutputStream outputStream) {
        this.input = inputStream;
        this.output = outputStream;
        this.start();
    }

    public ConnectionStream(InputStream inputStream, OutputStream outputStream, ServletResponse servletResponse) {
        this.response = servletResponse;
        this.input = inputStream;
        this.output = outputStream;
        this.start();
    }

    public void setClientInput(InputStream inputStream) {
        this.input = inputStream;
    }

    public void setClientOutput(OutputStream outputStream, ServletResponse servletResponse) {
        this.output = outputStream;
        this.response = servletResponse;
    }

    public void start() {
        if (this.running == null) {
            this.running = new Thread(this);
            this.running.start();
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (this.busy) {
            this.readBuffer();
        }
        this.running.stop();
    }

    public void stop() {
        this.busy = false;
    }

    protected void readBuffer() {
        try {
            int n;
            int n2 = 0;
            int n3 = this.input.available();
            while (n3 <= 0 && this.busy) {
                Thread.sleep(n2);
                if (n2 < 10) {
                    ++n2;
                }
                n3 = this.input.available();
            }
            this.buf = new byte[n3];
            if (!this.busy) {
                return;
            }
            int n4 = this.input.read(this.buf, 0, this.buf.length);
            int n5 = n = n4 <= 0 ? 0 : n4;
            if (this.response != null) {
                this.response.setContentLength(n);
            }
            this.output.write(this.buf, 0, n);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.CORBA.services.redirector.ConnectionStream.readBuffer", (String)"114", (Object)this);
            this.stop();
        }
    }
}

