/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.ConnectionStream;
import com.ibm.CORBA.services.redirector.RedirectorController;
import com.ibm.rmi.iiop.Message;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class Redirector {
    protected InputStream inFromServer;
    protected OutputStream outToServer;
    protected InputStream inFromClient;
    protected OutputStream outToClient;
    protected Socket inputSocket;
    protected Socket outputSocket;
    protected byte[] buf;
    public String my_id;
    public boolean busy;
    protected String outServerName;
    protected int outPort;
    protected ConnectionStream requestConnection;
    protected ConnectionStream replyConnection;
    protected ServletRequest request;
    protected ServletResponse response;
    protected RedirectorController controller;
    public static final int GIOPBigEndian = 0;
    public static final int GIOPLittleEndian = 1;

    public Redirector() {
        this.buf = new byte[2048];
        this.busy = false;
    }

    public Redirector(String string, int n) throws IOException {
        this.buf = new byte[2048];
        this.busy = false;
        this.setupServerConnection(string, n);
    }

    public Redirector(String string) throws IOException {
        ORB oRB;
        block3: {
            this.buf = new byte[2048];
            this.busy = false;
            String[] stringArray = null;
            Properties properties = null;
            oRB = null;
            oRB = GlobalORBFactory.globalORB();
            if (oRB == null) {
                try {
                    oRB = GlobalORBFactory.init(stringArray, properties);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.CORBA.services.redirector.Redirector.Redirector", (String)"98", (Object)this);
                    if (!ORBRas.isMsgLogging) break block3;
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "Redirector.ctor", MessageUtility.getMessage("Redirector.Exception", exception.toString()), (String)null, (Object)exception);
                }
            }
        }
        IOR iOR = ORB.createIOR((ORB)oRB, (String)string);
        Profile profile = iOR.getProfile(0);
        this.setupServerConnection(profile.getHost(), profile.getPort());
    }

    public void setupServerConnection(String string, int n) throws IOException {
        this.outServerName = string;
        this.outPort = n;
        this.outputSocket = new Socket(this.outServerName, this.outPort);
        this.outToServer = this.outputSocket.getOutputStream();
        this.inFromServer = this.outputSocket.getInputStream();
        this.busy = false;
    }

    public void reconnect() throws IOException {
        if (this.requestConnection != null) {
            this.outputSocket.close();
            this.setupServerConnection(this.outServerName, this.outPort);
            this.requestConnection.stop();
            if (this.replyConnection != null) {
                // empty if block
            }
            this.replyConnection.stop();
            this.requestConnection = null;
            this.replyConnection = null;
        }
    }

    public void handle(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.busy = true;
        this.inFromClient = inputStream;
        this.outToClient = outputStream;
        this.requestConnection = new ConnectionStream(this.inFromClient, this.outToServer);
        this.replyConnection = new ConnectionStream(this.inFromServer, this.outToClient);
        this.busy = false;
    }

    public synchronized void handle(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        this.busy = true;
        this.request = servletRequest;
        this.response = servletResponse;
        this.inFromClient = servletRequest.getInputStream();
        this.outToClient = servletResponse.getOutputStream();
        this.handleRequest(this.inFromClient, this.outToServer);
        this.handleReply(this.inFromServer, this.outToClient, servletResponse);
        this.busy = false;
    }

    protected void handleRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n = 0;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                int n2 = n <= 0 ? 0 : n;
                try {
                    outputStream.write(byArray, 0, n2);
                }
                catch (SocketException socketException) {
                    FFDCFilter.processException((Throwable)socketException, (String)"com.ibm.CORBA.services.redirector.Redirector.handleRequest", (String)"191", (Object)this);
                    this.outputSocket.close();
                    this.setupServerConnection(this.outServerName, this.outPort);
                    this.controller.addRedirector(this.controller.buildID(this.outServerName, this.outPort), this);
                    outputStream = this.outToServer;
                    outputStream.write(byArray, 0, n2);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.CORBA.services.redirector.Redirector.handleRequest", (String)"201", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.RequestIOException", iOException.toString()), (String)null, (Object)iOException);
            }
            throw iOException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.CORBA.services.redirector.Redirector.handleRequest", (String)"216", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.Throwable", throwable.toString()), (String)null, (Object)throwable);
            }
            throw new IOException("Throwable exception caught t=" + throwable.toString());
        }
    }

    protected void handleReply(InputStream inputStream, OutputStream outputStream, ServletResponse servletResponse) throws IOException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            byte[] byArray = new byte[12];
            Message.readFully((InputStream)inputStream, (byte[])byArray, (int)0, (int)12);
            byte by = (byte)(byArray[6] & 1);
            if (by == 0) {
                n4 = byArray[8] << 24 & 0xFF000000;
                n3 = byArray[9] << 16 & 0xFF0000;
                n2 = byArray[10] << 8 & 0xFF00;
                n = byArray[11] << 0 & 0xFF;
            } else {
                n4 = byArray[11] << 24 & 0xFF000000;
                n3 = byArray[10] << 16 & 0xFF0000;
                n2 = byArray[9] << 8 & 0xFF00;
                n = byArray[8] << 0 & 0xFF;
            }
            int n5 = (n4 | n3 | n2 | n) + 12;
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, 12);
            Message.readFully((InputStream)inputStream, (byte[])byArray2, (int)12, (int)(n5 - 12));
            if (servletResponse != null) {
                servletResponse.setContentLength(n5);
            }
            outputStream.write(byArray2, 0, n5);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.CORBA.services.redirector.Redirector.handleReply", (String)"291", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.ReplyIOException", iOException.toString()), (String)null, (Object)iOException);
            }
            throw iOException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.CORBA.services.redirector.Redirector.handleReply", (String)"305", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.Throwable", throwable.toString()), (String)null, (Object)throwable);
            }
            throw new IOException("Throwable exception caught t=" + throwable.toString());
        }
    }

    public void handle(Socket socket) throws IOException {
        this.busy = true;
        this.inputSocket = socket;
        try {
            this.inFromClient = this.inputSocket.getInputStream();
            this.outToClient = this.inputSocket.getOutputStream();
            this.requestConnection = new ConnectionStream(this.inFromClient, this.outToServer);
            this.replyConnection = new ConnectionStream(this.inFromServer, this.outToClient);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.CORBA.services.redirector.Redirector.handle", (String)"330", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handle", MessageUtility.getMessage("Redirector.Throwable", throwable.toString()), (String)null, (Object)throwable);
            }
            this.busy = false;
        }
        this.busy = false;
    }

    public void setController(RedirectorController redirectorController) {
        this.controller = redirectorController;
    }

    public void setID(String string) {
        this.my_id = string;
    }

    public void finalize() {
        if (this.requestConnection != null) {
            this.requestConnection.stop();
        }
        if (this.replyConnection != null) {
            this.replyConnection.stop();
        }
        this.busy = false;
    }
}

