/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;

public class IORPrototype {
    private ORB orb;
    private IOR ior;
    private byte[] objectKey = null;
    private String typeId = null;

    public IORPrototype(ORB oRB, int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "IORPrototype(ORB orb, int port)");
        }
        this.orb = oRB;
        int n2 = n;
        Profile profile = oRB.getTransportProfile();
        String string = oRB.getLocalHost();
        if (null == string) {
            string = profile.getHost();
        }
        if (0 == n2) {
            n2 = profile.getPort();
        }
        this.ior = ORB.createIOR((ORB)oRB, (String)"", (String)string, (int)n2, (byte[])new byte[0]);
        if (ORBRas.isTrcLogging) {
            Object[] objectArray = new String[]{string, Integer.toString(n2), this.ior.stringify()};
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "IORPrototype(ORB orb, int port)", "Host, Port, and IORPrototype", objectArray);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (Object)this, "IORPrototype(ORB orb, int port)");
        }
    }

    public IORPrototype(ORB oRB, IOR iOR) {
        this.ior = iOR;
        this.orb = oRB;
    }

    public IOR asIOR() {
        if (null == this.objectKey && null == this.typeId) {
            return this.ior;
        }
        return this.asIOR(this.getObjectKey(), this.getTypeId());
    }

    public IOR asIOR(byte[] byArray, String string) {
        IOR iOR;
        block6: {
            iOR = null;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "asIOR(byte[] objectKey, String typeId)");
            }
            try {
                Profile profile = this.ior.getProfile();
                iOR = ORB.createIOR((ORB)this.orb, (String)string, (Profile)profile, (byte[])byArray);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.orbimpl.services.lsd.IORPrototype.asIOR", (String)"143", (Object)this);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4104L, (Object)this, "asIOR(byte[] objectKey, String typeId)", "Caught Throwable ", (Object)throwable);
                }
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "asIOR(byte[] objectKey, String typeId)", "ObjectKey length is " + Integer.toString(byArray.length), (Object)("IOR is " + (null != iOR ? iOR.stringify() : "")));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (Object)this, "asIOR(byte[] objectKey, String typeId)");
        }
        return iOR;
    }

    public void setObjectKey(ObjectKey objectKey) {
        this.objectKey = objectKey.getObjectKey();
    }

    public void setTypeId(String string) {
        this.typeId = string;
    }

    public byte[] getObjectKey() {
        if (null == this.objectKey) {
            return new byte[0];
        }
        return this.objectKey;
    }

    public String getTypeId() {
        if (null == this.typeId) {
            return new String("");
        }
        return this.typeId;
    }
}

