/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.LSDPlugin;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.iiop.WLMPlugin;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.services.lsd.DPAFirewall;
import com.ibm.ws.orb.services.lsd.FirewallCallback;
import com.ibm.ws.orb.services.lsd.FirewallInformation;
import com.ibm.ws.orb.services.lsd.NetAddress;
import com.ibm.ws.orbimpl.services.lsd.FirewallCallbackImpl;
import com.ibm.ws.orbimpl.services.lsd.FirewallInformationImpl;
import com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl;
import com.ibm.ws.orbimpl.services.lsd.NetAddressImpl;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;

public class LocationServiceDaemon
implements LSDPlugin {
    private LocationServiceImpl locationService = null;
    private WLMPlugin wlmPlugin = null;
    private boolean wlmPluginInitialized = false;
    private PMIPlugin pmiServer = null;
    private DPAFirewall firewall = null;
    private FirewallCallback firewallCallback = null;
    private int firewallTimeout = 0;
    private ORB orb = null;
    private final String defaultLSDPort = "9000";

    public void init(ORB oRB) {
        block4: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "init()");
            }
            this.orb = oRB;
            this.pmiInit();
            try {
                this.locationService = new LocationServiceImpl(oRB);
                oRB.connect((Object)this.locationService);
                oRB.register_initial_reference("LocationService", (Object)this.locationService);
                this.createListener();
                this.locationService.init();
                this.initFirewall();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.init", (String)"98", (java.lang.Object)this);
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "init()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "init()");
        }
    }

    private void pmiInit() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "pmiInit()");
        }
        this.pmiServer = this.orb.getPMIServer();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "pmiInit()");
        }
    }

    public IOR getDirectIOR(byte[] byArray, String string, int n) {
        IOR iOR = null;
        ObjectKey objectKey = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)");
        }
        try {
            objectKey = new ObjectKey(byArray);
            if (null != objectKey && this.orb.getTransientServerId() != objectKey.getServerId()) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)", "TransientServerId is " + this.orb.getTransientServerId(), (java.lang.Object)("ObjectKey ServerId is " + objectKey.getServerId()));
                }
                if (null != this.pmiServer) {
                    this.pmiServer.lsdLookupRequired();
                }
                if (null != this.getWLMPlugin()) {
                    iOR = this.wlmPlugin.getNextTarget(byArray);
                    if (iOR == null) {
                        iOR = this.locationService.getNextTarget(byArray);
                    }
                } else {
                    iOR = this.locationService.getNextTarget(byArray);
                }
            }
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            FFDCFilter.processException((Throwable)nO_IMPLEMENT, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.getDirectIOR", (String)"233", (java.lang.Object)this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)", (Exception)((java.lang.Object)nO_IMPLEMENT));
            }
            throw nO_IMPLEMENT;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.getDirectIOR", (String)"244", (java.lang.Object)this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)", exception);
            }
            return null;
        }
        if (null != iOR) {
            iOR = this.addFirewallMapping(iOR, string, n);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)", "Returned IOR is " + iOR.stringify());
            }
        } else if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)", "IOR not returned");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "getDirectIOR(byte[] objectKey, String clientHost, int clientPort)");
        }
        return iOR;
    }

    private WLMPlugin getWLMPlugin() {
        if (!this.wlmPluginInitialized && null == this.wlmPlugin) {
            this.wlmPluginInitialized = true;
            this.wlmPlugin = this.orb.getWLMPlugin();
        }
        return this.wlmPlugin;
    }

    private IOR addFirewallMapping(IOR iOR, String string, int n) {
        block7: {
            FirewallInformation firewallInformation = null;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "addFirewallMapping(IOR ior, String clientHost, int clientPort)");
            }
            try {
                NetAddress netAddress;
                if (null != this.firewall && null != (netAddress = (firewallInformation = this.firewall.addDynamicMapping(this.createFirewallInfo(iOR, string, n), this.firewallCallback, this.orb.getTransientServerId())).firewall())) {
                    String string2 = netAddress.hostName();
                    int n2 = netAddress.portNum();
                    if (null != string2 && 0 != n2) {
                        Profile profile = iOR.getProfile();
                        profile.setHost(string2);
                        profile.setPort(n2);
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addFirewallMapping(IOR ior, String clientHost, int clientPort)", "Firewall Host is " + string2, (java.lang.Object)("Firewall Port is " + n2));
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.addFirewallMapping", (String)"371", (java.lang.Object)this);
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "addFirewallMapping(IOR ior, String clientHost, int clientPort)", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "addFirewallMapping(IOR ior, String clientHost, int clientPort)");
        }
        return iOR;
    }

    private void initFirewall() {
        block9: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "initFirewall()");
            }
            if (null == this.firewall) {
                try {
                    String string = this.orb.getProperty("com.ibm.ws.orb.services.lsd.FirewallAuthorizationPlugIn");
                    if (null != string) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "initFirewall()", "FirewallClassName is " + string);
                        }
                        Class clazz = Util.loadClass((String)string, null, null);
                        this.firewall = (DPAFirewall)clazz.newInstance();
                        this.firewall.init(this.orb);
                        this.getFirewallCallback();
                        String string2 = this.orb.getProperty("com.ibm.ws.orb.services.lsd.FirewallAuthorizationPlugInTimeout");
                        if (null != string2) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "initFirewall()", "FirewallTimeout value is " + string2);
                            }
                            this.firewallTimeout = Integer.parseInt(string2);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.initFirewall", (String)"448", (java.lang.Object)this);
                    if (!ORBRas.isTrcLogging) break block9;
                    ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "initFirewall()", exception);
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "initFirewall()");
        }
    }

    private FirewallCallback getFirewallCallback() {
        if (null == this.firewallCallback) {
            this.firewallCallback = new FirewallCallbackImpl();
            this.orb.connect((Object)this.firewallCallback);
        }
        return this.firewallCallback;
    }

    private FirewallInformation createFirewallInfo(IOR iOR, String string, int n) {
        Profile profile = iOR.getProfile();
        String string2 = profile.getHost();
        int n2 = profile.getPort();
        NetAddressImpl netAddressImpl = new NetAddressImpl(string, n);
        NetAddressImpl netAddressImpl2 = new NetAddressImpl(string2, n2);
        FirewallInformationImpl firewallInformationImpl = new FirewallInformationImpl(netAddressImpl, netAddressImpl2, null, this.firewallTimeout, 0);
        this.orb.connect((Object)netAddressImpl);
        this.orb.connect((Object)netAddressImpl2);
        this.orb.connect((Object)firewallInformationImpl);
        return firewallInformationImpl;
    }

    private void createListener() {
        block7: {
            String string = this.orb.getProperty("com.ibm.ws.orb.services.lsd.LSDListenerPort");
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "createListener()");
            }
            if (null == string) {
                string = "9000";
                this.orb.setProperty("com.ibm.ws.orb.services.lsd.LSDListenerPort", string);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "createListener()", "LSDListenerPort is " + string);
            }
            try {
                int n = Integer.parseInt(string);
                if (n != this.orb.getListenerPort()) {
                    this.orb.createListener(n);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.services.lsd.LocationServiceDaemon.createListener", (String)"572", (java.lang.Object)this);
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "createListener()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "createListener()");
        }
    }
}

