/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.MessageUtility;
import com.ibm.ws.orbimpl.transport.JNIReaderPoolBase;
import com.ibm.ws.orbimpl.transport.JNIReaderThread;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class JNIReaderPoolImpl
extends JNIReaderPoolBase {
    private int numReaders;
    private int nextReader = 0;
    private JNIReaderThread[] readers;
    private Hashtable readerMap = new Hashtable();
    private ORB theORB = null;
    private static final int DEFAULT_NUMBER_OR_READERS = 2;
    private static final String NUMBER_OF_READERS_PROPERTY_NAME = "com.ibm.CORBA.numJNIReaders";
    private static final String LOCAL_HOST_PROPERTY_NAME = "com.ibm.CORBA.LocalHost";
    private static final String USE_MULTIHOME_PROPERTY_NAME = "com.ibm.ws.orb.transport.useSingleNIC";

    public void init(ORB oRB) {
        String string;
        boolean bl;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"Constructor)");
        }
        this.theORB = oRB;
        int n = oRB.getSocketQueueDepth();
        String string2 = oRB.getProperty("LOCAL_HOST_PROPERTY_NAME");
        String string3 = oRB.getProperty("USE_MULTIHOME_PROPERTY");
        boolean bl2 = bl = string2 != null && string3 != null && string3.equalsIgnoreCase("false");
        if (bl && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "constructor - init(...)", "Bind To A Specific NIC Card Flag Is Set To = " + bl);
        }
        if ((string = oRB.getProperty(NUMBER_OF_READERS_PROPERTY_NAME)) == null) {
            this.numReaders = 2;
        } else {
            try {
                this.numReaders = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.init", (String)"836", (Object)this);
                Object[] objectArray = new String[]{NUMBER_OF_READERS_PROPERTY_NAME, string, String.valueOf(2)};
                ORBRas.orbMsgLogger.msg(2L, (Object)this, "constructor", MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, objectArray);
                this.numReaders = 2;
            }
            if (this.numReaders <= 0) {
                Object[] objectArray = new String[]{NUMBER_OF_READERS_PROPERTY_NAME, string, String.valueOf(2)};
                ORBRas.orbMsgLogger.msg(2L, (Object)this, "constructor", MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, objectArray);
                this.numReaders = 2;
            }
        }
        this.readers = new JNIReaderThread[this.numReaders];
        for (int i = 0; i < this.numReaders; ++i) {
            this.readers[i] = new JNIReaderThread(n, string2, bl);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addConnection(ORBConnection oRBConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"addConnection)");
        }
        int n = 0;
        JNIReaderPoolImpl jNIReaderPoolImpl = this;
        synchronized (jNIReaderPoolImpl) {
            boolean bl = false;
            for (int i = 0; i < this.readers.length; ++i) {
                ++this.nextReader;
                if (this.nextReader >= this.numReaders) {
                    this.nextReader = 0;
                }
                if (this.readerMap.size() >= this.readers[n].getQueueSize()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                String string = MessageUtility.getMessage("JNIReaderManager.noNonFullNativeReaders");
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "addConnection()", MessageUtility.getMessage("JNIReaderManager.noNonFullNativeReaders"), (String)null, (Object[])null);
                throw new COMM_FAILURE(string, 1229127170, CompletionStatus.COMPLETED_NO);
            }
        }
        this.readers[n].addConnection(oRBConnection);
        this.readerMap.put(oRBConnection, this.readers[n]);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"addConnection");
        }
        return this.readers[n];
    }

    public void removeConnection(ORBConnection oRBConnection, Object object) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"removeConection");
        }
        JNIReaderThread jNIReaderThread = (JNIReaderThread)this.readerMap.get(oRBConnection);
        this.readerMap.remove(oRBConnection);
        jNIReaderThread.removeConnection(oRBConnection);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"removeConection");
        }
    }
}

