/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.Connection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import org.omg.CORBA.INTERNAL;

final class JNIReaderThread
extends Thread {
    protected int queueDepth = 0;
    protected String localHost = null;
    protected boolean useSingleNIC = false;
    private Hashtable fdConnectionMap = new Hashtable();
    private Hashtable fdConnectionReverseMap = new Hashtable();
    private long self;
    public int thisInstanceNumber;
    public static int instanceCounter = 0;
    private int nativeCodeQueueSize;
    private SocketPair theSocketPair;
    private static boolean libraryHasBeenLoaded = false;

    private static native void load0();

    private native void run0();

    private native int init0(Socket var1, Socket var2);

    private native void addConnection0(FileDescriptor var1);

    private native void removeConnection0(FileDescriptor var1);

    private native FileDescriptor getSSLSocketFD0(SSLSocket var1);

    public void run() {
        block4: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"run)");
            }
            try {
                this.run0();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.run", (String)"165", (Object)this);
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "run", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"run)");
        }
    }

    JNIReaderThread() {
        super("JNIReaderThread");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"Constructor");
        }
        if (!libraryHasBeenLoaded) {
            System.loadLibrary("Selector");
            JNIReaderThread.load0();
            libraryHasBeenLoaded = true;
        }
    }

    public JNIReaderThread(int n, String string, boolean bl) {
        this();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb <init>(int, String", (Object)"Constructor");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(int, String", "queueDepth is " + n + " LocalHost is " + string + " Bind To Single NIC Card is " + bl);
        }
        this.queueDepth = n;
        this.localHost = string;
        this.useSingleNIC = bl;
        this.thisInstanceNumber = instanceCounter++;
        SocketPairFactory socketPairFactory = new SocketPairFactory(n, string, bl);
        this.theSocketPair = socketPairFactory.createSocketPair();
        this.nativeCodeQueueSize = this.init0(this.theSocketPair.getReadSocket(), this.theSocketPair.getWriteSocket());
        this.setDaemon(true);
        this.start();
    }

    void addConnection(ORBConnection oRBConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"addConnection)");
        }
        FileDescriptor fileDescriptor = null;
        try {
            fileDescriptor = ((FileInputStream)((Connection)oRBConnection).getInputStream()).getFD();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.addConnection", (String)"298", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "addConnection Exception =" + iOException, MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, (Object[])null);
            }
            throw new INTERNAL(iOException.toString());
        }
        this.fdConnectionMap.put(fileDescriptor, oRBConnection);
        this.fdConnectionReverseMap.put(oRBConnection, fileDescriptor);
        if (ORBRas.isTrcLogging) {
            String[] stringArray = new String[]{this.fdConnectionMap.toString(), fileDescriptor.toString()};
            String string = MessageUtility.getMessage("JNIReaderThread.showfdConnectionMap", stringArray);
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "addConnection", string);
        }
        try {
            this.addConnection0(fileDescriptor);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.addConnection", (String)"339", (Object)this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "addConnection", exception);
            }
            if (fileDescriptor != null) {
                this.fdConnectionMap.remove(fileDescriptor);
                this.fdConnectionReverseMap.remove(oRBConnection);
            }
            throw new INTERNAL(exception.toString());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"addConnection)");
        }
    }

    void removeConnection(ORBConnection oRBConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"removeConnection)");
        }
        FileDescriptor fileDescriptor = (FileDescriptor)this.fdConnectionReverseMap.get(oRBConnection);
        try {
            this.removeConnection0(fileDescriptor);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.removeConnection", (String)"390", (Object)this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "removeConnection Exception = " + exception, MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, (Object[])null);
            }
            throw new INTERNAL(exception.toString());
        }
        this.fdConnectionMap.remove(fileDescriptor);
        this.fdConnectionReverseMap.remove(oRBConnection);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"removeConnection");
        }
    }

    private void doConnectionRead(FileDescriptor fileDescriptor) {
        block6: {
            ORBConnection oRBConnection = (ORBConnection)this.fdConnectionMap.get(fileDescriptor);
            if (ORBRas.isTrcLogging) {
                String[] stringArray = new String[]{fileDescriptor.toString(), oRBConnection.toString(), this.fdConnectionMap.toString()};
                String string = MessageUtility.getMessage("JNIReaderThread.fdConnectionMap.get", stringArray);
                ORBRas.orbTrcLogger.trace(16L, (Object)this, "doConnectionRead", string);
            }
            if (oRBConnection == null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8L, (Object)this, "doConnectionRead", "c==null");
                }
                return;
            }
            try {
                oRBConnection.doReaderWorkOnce();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.doConnectionRead", (String)"483", (Object)this);
                if (!ORBRas.isTrcLogging) break block6;
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "doConnectionRead", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"doConnectionRead)");
        }
    }

    public String toString() {
        String string = super.toString();
        String string2 = "[JNIReaderThread: " + string;
        string2 = string2 + " fdConnectionMap contains: " + this.fdConnectionMap;
        string2 = string2 + " fdConnectionReverseMap contains: " + this.fdConnectionReverseMap;
        string2 = string2 + "]";
        return string2;
    }

    public int getQueueSize() {
        return this.nativeCodeQueueSize;
    }

    public class SocketPairFactory
    extends Thread {
        private ServerSocket theServerSocket = null;
        private Socket acceptedSocket = null;
        private int queueDepth = 0;
        private String localHost = null;
        private boolean useSingleNIC = false;

        public SocketPairFactory() {
            super("SocketPairFactory");
        }

        public SocketPairFactory(int n, String string, boolean bl) {
            this();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(int, String)", "queueDepth is " + n + " localHost is " + string + " useSingleNIC is " + bl);
            }
            this.queueDepth = n;
            this.localHost = string;
            this.useSingleNIC = bl;
        }

        public SocketPair createSocketPair() {
            Socket socket = null;
            try {
                if (this.useSingleNIC) {
                    this.theServerSocket = new ServerSocket(0, this.queueDepth, InetAddress.getByName(this.localHost));
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocketPair", "ServerSocketQueueDepth is set to " + this.queueDepth, (Object)("useSingleNIC is set to " + this.useSingleNIC));
                    }
                } else {
                    this.theServerSocket = new ServerSocket(0, this.queueDepth);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocketPair", "ServerSocketQueueDepth is set to " + this.queueDepth);
                    }
                }
                this.start();
                while (true) {
                    try {
                        if (this.useSingleNIC) {
                            socket = new Socket(InetAddress.getLocalHost(), this.theServerSocket.getLocalPort(), InetAddress.getByName(this.localHost), 0);
                            break;
                        }
                        socket = new Socket(InetAddress.getLocalHost(), this.theServerSocket.getLocalPort());
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.createSocketPair", (String)"682", (Object)this);
                        continue;
                    }
                    break;
                }
                return new SocketPair(socket, this.getAcceptedSocket());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.createSocketPair", (String)"665", (Object)this);
                throw new INTERNAL(iOException.toString());
            }
        }

        public synchronized void run() {
            try {
                this.acceptedSocket = null;
                this.acceptedSocket = this.theServerSocket.accept();
                this.notifyAll();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.run", (String)"718", (Object)this);
                throw new INTERNAL(iOException.toString());
            }
        }

        private synchronized Socket getAcceptedSocket() {
            while (this.acceptedSocket == null) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.getAcceptedSocket", (String)"741", (Object)this);
                    continue;
                }
                break;
            }
            return this.acceptedSocket;
        }
    }

    public class SocketPair {
        final Socket readSocket;
        final Socket writeSocket;

        public SocketPair(Socket socket, Socket socket2) {
            this.readSocket = socket;
            this.writeSocket = socket2;
        }

        public Socket getReadSocket() {
            return this.readSocket;
        }

        public Socket getWriteSocket() {
            return this.writeSocket;
        }
    }
}

