/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Plugin;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ListenerThread;
import com.ibm.CORBA.transport.Transport;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.DefaultConnectionInterceptor;
import com.ibm.ws.orb.transport.DummyObjectImpl;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orb.transport.WSSSLServerSocketFactory;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.ws.orbimpl.transport.SSLConnectionKey;
import com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection;
import com.ibm.ws.orbimpl.transport.WSSSLTransportConnection;
import com.ibm.ws.orbimpl.transport.WSTCPTransportConnection;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.Delegate;

public class WSTransport
extends TransportBase
implements Transport,
Plugin {
    public static final int SSL_TAGGED_COMPONENT_ID = 20;
    protected ORB fORB;
    protected ConnectionTable fConnectionTable;
    protected ORBForTransports fORBForTransports;
    protected long globalCounter = 0L;
    protected Profile serverProfile = null;
    protected static ConnectionInterceptor connectionInterceptor = null;
    protected Map tableOfListeners = Collections.synchronizedMap(new HashMap());
    protected int acceptTimeout = 5000;
    private String forceTunnel = "whenrequired";
    private boolean forceTunnelVarSet = false;
    static WSSSLServerSocketFactory sslFactory = null;
    private static WSSSLClientSocketFactory sslClientFactory = null;

    public void init(ORB oRB) {
        this.fORB = oRB;
        this.fConnectionTable = ORB.createConnectionTable((ORB)this.fORB, (Transport)this);
        this.fORBForTransports = this.fORB.getORBForTransports();
        String string = oRB.getProperty("com.ibm.ws.orb.transport.ConnectionInterceptorName");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "init(ORB)", "The value of the property \"com.ibm.ws.orb.transport.ConnectionInterceptorName\" is " + string);
        }
        if (string == null) {
            connectionInterceptor = new DefaultConnectionInterceptor();
            connectionInterceptor.init(oRB);
        } else {
            try {
                connectionInterceptor = (ConnectionInterceptor)Class.forName(string).newInstance();
                connectionInterceptor.init(oRB);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.init", (String)"162", (java.lang.Object)((java.lang.Object)this));
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "init(ORB)", "Invalid ConnectionInterceptor name. The invalid name is: " + string);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(4112L, (java.lang.Object)this, "init(ORB)", exception);
                }
                throw new INTERNAL("CONNECTIONINTERCEPTOR_INVALID_CLASSNAME", 1229066331, CompletionStatus.COMPLETED_NO);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "init(ORB)", "The connectionInterceptor is " + connectionInterceptor);
        }
        try {
            String string2 = this.fORB.getProperty("com.ibm.CORBA.AcceptTimeout");
            int n = string2 != null ? Integer.parseInt(string2) : 5000;
            if (n < 0 || n > 5000) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "init(ORB)", "com.ibm.CORBA.AcceptTimeout value is invalid, using default value: 5000");
                }
            } else {
                this.acceptTimeout = n;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "init(ORB)", "com.ibm.CORBA.AcceptTimeout value set to: " + this.acceptTimeout);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.init", (String)"223", (java.lang.Object)((java.lang.Object)this));
            this.acceptTimeout = 5000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ORBConnection getConnection(Profile var1_1, ClientDelegate var2_2, String var3_3) {
        if (ORBRas.isTrcLogging) {
            this.logGetConnectionParameters(var1_1, var2_2, var3_3);
        }
        var5_4 = new ConnectionDataCarrier();
        var6_5 = null;
        var7_6 = true;
        var8_7 = null;
        var9_8 = new DummyObjectImpl();
        var9_8._set_delegate((Delegate)var2_2);
        var10_9 = WSTransport.connectionInterceptor.getConnectionKey(var1_1, 0, var3_3, 0L, var5_4, (Object)var9_8);
        if (!var10_9) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate)", "getConnectionKey returned false");
            }
            throw new TRANSIENT("GETCONNECTIONKEY_RETURNED_FALSE", 1229066353, CompletionStatus.COMPLETED_NO);
        }
        var6_5 = var5_4.getConnectionData();
        if (var6_5 == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate)", "connectionDataCarrier.getConnectionData() returned null");
            }
            throw new INTERNAL("NO_CONNECTIONDATA_IN_CONNECTIONDATACARRIER", 1229066332, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate)", "the ConnectionData object returned by ConnectionInterceptor.getConnectionKey is: " + var6_5);
        }
        if ((var8_7 = this.fConnectionTable.getConnection((com.ibm.CORBA.transport.ConnectionKey)(var11_10 = this.getKeyFromConnectionData(var6_5)))) != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate)", "a connection for the following key was found in the cache, key=" + var11_10);
            }
            return var8_7;
        }
        var12_11 /* !! */  = this;
        synchronized (var12_11 /* !! */ ) {
            var8_7 = this.fConnectionTable.getConnection((com.ibm.CORBA.transport.ConnectionKey)var11_10);
            if (var8_7 != null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate)", "a connection for the following key was found in the cache, key=" + var11_10);
                }
                return var8_7;
            }
            var8_7 = this.fORBForTransports.createORBConnection();
            this.fConnectionTable.addConnection((com.ibm.CORBA.transport.ConnectionKey)var11_10, var8_7);
        }
        switch ((int)var6_5.getConnectionType()) {
            case 2: {
                if (this.getForceTunnel().equals("always")) {
                    new WSHTTPTransportConnection(this.fConnectionTable, var11_10, var8_7, this.fORB, var1_1, var6_5, WSTransport.connectionInterceptor);
                    this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)var11_10);
                } else {
                    try {
                        var12_11 /* !! */  = null;
                        var12_11 /* !! */  = new WSTCPTransportConnection(this.fORBForTransports, this.fConnectionTable, var11_10, var8_7, this.fORB.getReaderPool(), var1_1, var6_5, WSTransport.connectionInterceptor);
                        var12_11 /* !! */ .connect();
                        var6_5.setLocalHost(var12_11 /* !! */ .getLocalHost());
                        var6_5.setRemoteHost(var12_11 /* !! */ .getRemoteHost());
                        var6_5.setLocalPort(var12_11 /* !! */ .getLocalPort());
                        var6_5.setRemotePort(var12_11 /* !! */ .getRemotePort());
                    }
                    catch (SystemException var12_12) {
                        FFDCFilter.processException((Throwable)var12_12, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getConnection", (String)"413", (java.lang.Object)this);
                        if (!this.getForceTunnel().equals("never")) {
                            new WSHTTPTransportConnection(this.fConnectionTable, var11_10, var8_7, this.fORB, var1_1, var6_5, WSTransport.connectionInterceptor);
                            this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)var11_10);
                        }
                        throw var12_12;
                    }
                }
                this.fConnectionTable.checkConnectionTable();
                return var8_7;
            }
            case 1: {
                if (!this.getForceTunnel().equals("always")) ** GOTO lbl70
                new WSHTTPTransportConnection(this.fConnectionTable, var11_10, var8_7, this.fORB, var1_1, var6_5, WSTransport.connectionInterceptor);
                this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)var11_10);
                ** GOTO lbl92
lbl70:
                // 1 sources

                var13_14 /* !! */  = var12_11 /* !! */  = new WSSSLTransportConnection(this.fORBForTransports, this.fConnectionTable, var11_10, var8_7, this.fORB.getReaderPool(), var1_1, var6_5, WSTransport.connectionInterceptor);
                try {
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((TransportConnection)var13_14 /* !! */ ){
                            private final /* synthetic */ TransportConnection val$ftransportConnection;
                            {
                                this.val$ftransportConnection = transportConnection;
                            }

                            public java.lang.Object run() throws IOException {
                                this.val$ftransportConnection.connect();
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException var14_15) {
                        FFDCFilter.processException((Throwable)var14_15, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getConnection", (String)"467", (java.lang.Object)this);
                        throw (IOException)var14_15.getException();
                    }
                }
                catch (IOException var14_16) {
                    FFDCFilter.processException((Throwable)var14_16, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getConnection", (String)"473", (java.lang.Object)this);
                    var14_16.printStackTrace();
                }
                var14_17 = var12_11 /* !! */ .getSocket();
                var6_5.setLocalHost(var14_17.getLocalAddress().getHostAddress());
                var6_5.setRemoteHost(var14_17.getInetAddress().getHostAddress());
                var6_5.setLocalPort(var14_17.getLocalPort());
                var6_5.setRemotePort(var14_17.getPort());
                try {
                    var14_17.getOutputStream().flush();
                }
                catch (IOException var15_18) {
                    FFDCFilter.processException((Throwable)var15_18, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getConnection", (String)"497", (java.lang.Object)this);
                }
lbl92:
                // 3 sources

                this.fConnectionTable.checkConnectionTable();
                return var8_7;
            }
        }
        throw new INTERNAL("CLIENT_CONNECTIONDATA_IS_INVALID_TYPE", 1229066333, CompletionStatus.COMPLETED_NO);
    }

    public void initTransports() {
        ServerConnectionData[] serverConnectionDataArray = connectionInterceptor.getServerConnectionData(this.fORB);
        if (serverConnectionDataArray == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "initTransports()", "connectionInterceptor.getServerConnectionData() retuned null ");
            }
            throw new INTERNAL("GETSERVERCONNECTIONDATA_RETURNED_NULL", 1229066361, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "initTransports()", "ConnectionInterceptor.getServerConnectionData() returned the following array: " + this.serverConnectionDataArrayToString(serverConnectionDataArray));
        }
        block3: for (int i = 0; i < serverConnectionDataArray.length; ++i) {
            long l = serverConnectionDataArray[i].getConnectionType();
            switch ((int)l) {
                case 1: 
                case 2: {
                    this.createListener(serverConnectionDataArray[i], serverConnectionDataArray[i].getAddToServerProfile());
                    continue block3;
                }
                default: {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "initTransports()", l + " is an unknown connection type");
                    }
                    throw new INTERNAL("SERVER_CONNECTIONDATA_IS_INVALID_TYPE", 1229066334, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    public void createListener(int n) {
        DefaultServerConnectionDataImpl defaultServerConnectionDataImpl = new DefaultServerConnectionDataImpl();
        defaultServerConnectionDataImpl.setServerPort(n);
        defaultServerConnectionDataImpl.setConnectionType(2L);
        this.createListener(defaultServerConnectionDataImpl, false);
    }

    protected void createListener(ServerConnectionData serverConnectionData, boolean bl) {
        try {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createListener( ServerConnectionData connectionData )", "At the beginning: the ConnectionData is" + serverConnectionData);
            }
            switch ((int)serverConnectionData.getConnectionType()) {
                case 1: {
                    serverConnectionData.setServerHost(this.fORB.getProperty("com.ibm.CORBA.LocalHost"));
                    serverConnectionData.setServerQueueDepth(this.fORB.getSocketQueueDepth());
                    boolean bl2 = this.fORB.getProperty("com.ibm.CORBA.LocalHost") != null && this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome") != null && this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome").equalsIgnoreCase("false");
                    serverConnectionData.setUseSingleNIC(bl2);
                    if (!ORBRas.isTrcLogging || !ORBRas.isTrcLogging) break;
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createListener()", "Connection Type=SSL Server Side Socket, LocalHost=" + this.fORB.getProperty("com.ibm.CORBA.LocalHost") + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth() + ", Bind Server Socket To Multiple NIC cards=" + !bl2);
                    break;
                }
                case 2: {
                    break;
                }
            }
            ServerSocket serverSocket = this.startListening(serverConnectionData);
            if (bl) {
                if (this.serverProfile == null) {
                    this.serverProfile = ORB.createProfile((ORB)this.fORB, null, (int)0);
                }
                this.addProfileInfoToServerProfile(serverConnectionData, serverSocket);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.createListener", (String)"633", (java.lang.Object)((java.lang.Object)this));
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "createListener( ServerConnectionData connectionData )", exception);
            }
            throw new INTERNAL("CREATE_LISTENER_FAILED_4", 1229066326, CompletionStatus.COMPLETED_NO);
        }
    }

    protected ServerSocket startListening(ServerConnectionData serverConnectionData) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "startListening( ServerConnectionData connectionData )", "At the beginning: the ConnectionData is" + serverConnectionData);
        }
        ConnectionTable connectionTable = this.fConnectionTable;
        try {
            ServerSocket serverSocket = this.createServerSocket(serverConnectionData);
            String string = "P=" + ORB.orbLoadTime + ":" + "O=" + this.fORB.thisInstanceNumber + ":" + "port=" + serverSocket.getLocalPort();
            Thread thread = this.createListenerThread(connectionTable, serverSocket, this.acceptTimeout, string);
            thread.setDaemon(true);
            this.tableOfListeners.put(thread, serverConnectionData);
            thread.start();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "startListening( ServerConnectionData connectionData )", "a new ListenerThread has been started for " + serverSocket);
            }
            return serverSocket;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.startListening", (String)"716", (java.lang.Object)((java.lang.Object)this));
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "startListening( ServerConnectionData connectionData )", exception);
            }
            throw new INTERNAL("CREATE_LISTENER_FAILED_4", 1229066326, CompletionStatus.COMPLETED_NO);
        }
    }

    public Profile getIIOPProfile() {
        if (ORBRas.isTrcLogging) {
            if (this.serverProfile != null) {
                byte[] byArray = this.serverProfile.getTaggedComponent(20);
                String string = "";
                if (byArray != null) {
                    string = WSTransport.sslTaggedComponentToString(byArray);
                }
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getIIOPProfile()", "In the Profile returned by getIIOPPorfile, Profile.getHost()=" + this.serverProfile.getHost() + " Profile.getPort()=" + this.serverProfile.getPort() + " SSL TaggedComponent= " + string);
            } else {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getIIOPProfile()", "In the Profile returned by getIIOPPorfile, serverProfile==null");
            }
        }
        return this.serverProfile;
    }

    public TransportConnection createTransportConnection(Socket socket, Thread thread) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createTransportConnection( Socket socket, Thread listenerThread )", "the socket for this connection is: " + socket);
        }
        ConnectionData connectionData = (ConnectionData)this.tableOfListeners.get(thread);
        long l = connectionData.getConnectionType();
        WSTCPTransportConnection wSTCPTransportConnection = null;
        switch ((int)l) {
            case 2: {
                wSTCPTransportConnection = new WSTCPTransportConnection(this.fConnectionTable, socket, this.fORB.getReaderPool(), this.fORBForTransports, connectionData, connectionInterceptor, false);
                break;
            }
            case 1: {
                wSTCPTransportConnection = new WSSSLTransportConnection(this.fConnectionTable, socket, this.fORB.getReaderPool(), this.fORBForTransports, connectionData, connectionInterceptor);
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createTransportConnection( Socket socket, Thread listenerThread )", l + " is an invalid connection type");
                }
                throw new INTERNAL("INVALID_SERVER_CONNECTION_DATA_TYPE", 1229066360, CompletionStatus.COMPLETED_NO);
            }
        }
        return wSTCPTransportConnection;
    }

    private String serverConnectionDataArrayToString(ServerConnectionData[] serverConnectionDataArray) {
        String string = "\n[ ";
        for (int i = 0; i < serverConnectionDataArray.length; ++i) {
            string = string + "\n[" + serverConnectionDataArray[i] + "]";
        }
        string = string + "\n]";
        return string;
    }

    private void logGetConnectionParameters(Profile profile, ClientDelegate clientDelegate, String string) {
        if (ORBRas.isTrcLogging) {
            String string2 = profile.getHost();
            int n = profile.getPort();
            byte[] byArray = profile.getTaggedComponent(20);
            if (byArray != null) {
                String string3 = WSTransport.sslTaggedComponentToString(byArray);
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate, operationName)", " method entry: host=" + string2 + " port=" + n + " SSLTaggedCompnent=" + string3 + " clientDelegate=" + clientDelegate + " operationName=" + string);
            } else {
                ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getConnection(Profile, ClientDelegate, operationName)", " method entry: host=" + string2 + " port=" + n + " clientDelegate=" + clientDelegate + " operationName=" + string);
            }
        }
    }

    public static String sslTaggedComponentToString(byte[] byArray) {
        CDRInputStream cDRInputStream = ORB.createCDRInputStream(null, (byte[])byArray, (int)byArray.length);
        cDRInputStream.consumeEndian();
        short s = cDRInputStream.read_short();
        short s2 = cDRInputStream.read_short();
        int n = cDRInputStream.read_short() & 0xFFFF;
        return "[targetSupportsQOP=" + s + " targetRequiresQOP=" + s2 + " SSLPort=" + n + "]";
    }

    private ConnectionKey getKeyFromConnectionData(ConnectionData connectionData) {
        ConnectionKey connectionKey = null;
        String string = WSTransport.getHostFromKeyString(connectionData.getConnectionKey());
        int n = WSTransport.getPortFromKeyString(connectionData.getConnectionKey());
        switch ((int)connectionData.getConnectionType()) {
            case 2: {
                connectionKey = new ConnectionKey(string, n);
                break;
            }
            case 1: {
                short s = (short)WSTransport.getPortFromKeyString(connectionData.getConnectionKey());
                connectionKey = new SSLConnectionKey(string, n, s);
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getKeyFromConnectionoData(ConnectionData)", connectionData.getConnectionType() + " is an invalid connection type");
                }
                throw new INTERNAL("CLIENT_CONNECTIONDATA_IS_INVALID_TYPE", 1229066333, CompletionStatus.COMPLETED_NO);
            }
        }
        return connectionKey;
    }

    public static String getHostFromKeyString(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int getPortFromKeyString(String string) {
        int n = string.indexOf(":");
        int n2 = string.indexOf(":", n + 1);
        if (n2 == -1) {
            return Integer.parseInt(string.substring(n + 1));
        }
        return Integer.parseInt(string.substring(n + 1, n2));
    }

    public static int getQOPFromKeyString(String string) {
        int n = string.indexOf(":");
        int n2 = string.indexOf(":", n + 1);
        int n3 = string.indexOf(":", n2 + 1);
        return Integer.parseInt(string.substring(n3));
    }

    public final String getForceTunnel() {
        if (!this.forceTunnelVarSet) {
            this.forceTunnelVarSet = true;
            String string = this.fORB.getProperty("com.ibm.CORBA.ForceTunnel");
            if (string == null) {
                this.forceTunnel = "whenrequired";
            } else {
                this.forceTunnel = string.toLowerCase();
                if (!this.forceTunnel.equals("never") && !this.forceTunnel.equals("always")) {
                    this.forceTunnel = "whenrequired";
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "getForceTunnel", "getForceTunnel() returned " + this.forceTunnel);
        }
        return this.forceTunnel;
    }

    public static WSSSLServerSocketFactory getWSSSLServerSocketFactory(ORBForTransports oRBForTransports) {
        try {
            if (sslFactory == null) {
                String string = oRBForTransports.getProperty("com.ibm.ws.orb.transport.WSSSLServerSocketFactoryName");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", "the value of property \"com.ibm.ws.orb.transport.WSSSLServerSocketFactoryName\" is " + string);
                }
                if (string == null) {
                    string = "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl";
                }
                sslFactory = (WSSSLServerSocketFactory)Class.forName(string).newInstance();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", "the installed WSSSLServerSocketFactory implementation is " + sslFactory);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getWSSSLServerSocketFactory", (String)"1088");
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", exception);
            }
            throw new INTERNAL("COULD_NOT_INSTANTIATE_SERVER_SSL_SOCKET_FACTORY", 1229066322, CompletionStatus.COMPLETED_NO);
        }
        return sslFactory;
    }

    public static WSSSLClientSocketFactory getWSSSLClientSocketFactory(ORBForTransports oRBForTransports) {
        try {
            if (sslClientFactory == null) {
                String string = oRBForTransports.getProperty("com.ibm.ws.orb.transport.WSSSLClientSocketFactoryName");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection", "getWSSSLClientSocketFactory()", "the value of property \"com.ibm.ws.orb.transport.WSSSLClientSocketFactoryName\" is " + string);
                }
                if (string == null) {
                    throw new NullPointerException();
                }
                sslClientFactory = (WSSSLClientSocketFactory)Class.forName(string).newInstance();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.getWSSSLClientSocketFactory", (String)"1139");
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection", "getWSSSLClientSocketFactory()", exception);
            }
            throw new INTERNAL("COULD_NOT_INSTANTIATE_CLIENT_SSL_SOCKET_FACTORY", 1229066321, CompletionStatus.COMPLETED_NO);
        }
        return sslClientFactory;
    }

    protected ServerSocket createServerSocket(ServerConnectionData serverConnectionData) {
        ServerSocket serverSocket = null;
        switch ((int)serverConnectionData.getConnectionType()) {
            case 2: {
                try {
                    boolean bl;
                    String string = this.fORB.getProperty("com.ibm.CORBA.LocalHost");
                    boolean bl2 = string != null;
                    String string2 = this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome");
                    boolean bl3 = bl = string2 != null && string2.equalsIgnoreCase("false");
                    if (bl && bl2) {
                        serverSocket = new ServerSocket(serverConnectionData.getServerPort(), this.fORB.getSocketQueueDepth(), InetAddress.getByName(string));
                        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createServerSocket()", "Bind Server Socket To A Specific NIC card=" + (bl && bl2) + ", Remote Port=" + serverConnectionData.getServerPort() + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth() + ", LocalHost=" + string + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(string));
                        }
                    } else {
                        serverSocket = new ServerSocket(serverConnectionData.getServerPort(), this.fORB.getSocketQueueDepth());
                        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createServerSocket()", "Bind Server Socket To Multiple NIC cards=" + (!bl || !bl2) + ", Remote Port=" + serverConnectionData.getServerPort() + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth());
                        }
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.orbimpl.transport.WSTransport.createServerSocket", (String)"1198", (java.lang.Object)((java.lang.Object)this));
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "createServerSocket(ServerConnectionData)", (Exception)iOException);
                    }
                    throw new INTERNAL("CREATE_LISTENER_FAILED_1", 1229066323, CompletionStatus.COMPLETED_NO);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createServerSocket(ServerConnectionData)", "The ServerSocket being returned is " + serverSocket);
                }
                return serverSocket;
            }
            case 1: {
                try {
                    WSSSLServerSocketFactory wSSSLServerSocketFactory = WSTransport.getWSSSLServerSocketFactory(this.fORBForTransports);
                    serverSocket = wSSSLServerSocketFactory.createSSLServerSocket(serverConnectionData);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createServerSocket(ServerConnectionData)", "The ServerSocket being returned is " + serverSocket);
                    }
                    return serverSocket;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.orbimpl.transport.WSTransport.createServerSocket", (String)"1241", (java.lang.Object)((java.lang.Object)this));
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(4112L, (java.lang.Object)this, "createServerSocket(ServerConnectionData)", exception);
                    }
                    throw new INTERNAL("CREATE_LISTENER_FAILED_2", 1229066324, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "createServerSocket(ServerConnectionData)", "invalid ConnectionDataType=" + serverConnectionData.getConnectionType());
        }
        throw new INTERNAL("CREATE_LISTENER_FAILED_3", 1229066325, CompletionStatus.COMPLETED_NO);
    }

    protected void addProfileInfoToServerProfile(ServerConnectionData serverConnectionData, ServerSocket serverSocket) {
        this.serverProfile.setHost(this.fORB.getORBServerHost());
        serverConnectionData.setServerPort(serverSocket.getLocalPort());
        switch ((int)serverConnectionData.getConnectionType()) {
            case 2: {
                this.serverProfile.setPort(serverSocket.getLocalPort());
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (java.lang.Object)this, "addProfileInfoToServerProfile(ServerConnectionData, ServerSocket)", "invalid ConnectionDataType=" + serverConnectionData.getConnectionType());
                }
                throw new INTERNAL("WSORBMinorCodes.INVALID_CONNECTION_TYPE", 1229066328, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public static ConnectionInterceptor getConnectionInterceptor() {
        return connectionInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WSTransport wSTransport = this;
        synchronized (wSTransport) {
            Iterator iterator = this.tableOfListeners.keySet().iterator();
            while (iterator.hasNext()) {
                ListenerThread listenerThread = (ListenerThread)iterator.next();
                listenerThread.setShutdownPending(true);
            }
        }
    }
}

