/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class WSPKCSInKeyStore {
    private KeyManagerFactory kmf;
    private KeyStore ks;
    private TrustManagerFactory tmf;
    private KeyStore ts;
    private String tokenLib_key;
    private String tokenType_key;
    private String tokenLib_trust;
    private String tokenType_trust;
    private static String pkcsType = "PKCS11";
    private static String pkcsProvider = "IBMPKCS11";
    public static final int DEFAULT_SLOT = 0;
    public static final int SLOT_NOT_SPECIFIED = -1;

    public void asKeyStore(String string, String string2, String string3) throws Exception {
        try {
            if (this.tokenLib_key != null && this.tokenLib_key.compareToIgnoreCase(string2) == 0 && this.ks != null) {
                return;
            }
            if (this.tokenLib_trust != null && string2.compareTo(this.tokenLib_trust) == 0 && this.ts != null) {
                this.kmf = KeyManagerFactory.getInstance("IbmX509");
                this.ks = this.ts;
                this.kmf.init(this.ts, string3.toCharArray());
            } else {
                this.kmf = KeyManagerFactory.getInstance("IbmX509");
                this.ks = KeyStore.getInstance(pkcsType, pkcsProvider);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                this.ks.load(byteArrayInputStream, string3.toCharArray());
                this.kmf.init(this.ks, string3.toCharArray());
            }
            this.tokenLib_key = new String(string2);
            this.tokenType_key = new String(string);
        }
        catch (Exception exception) {
            String string4 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", exception.getLocalizedMessage());
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "asKeyStore", string4, (String)null);
            }
            this.kmf = null;
            this.ks = null;
            this.tokenLib_key = null;
            this.tokenType_key = null;
            throw exception;
        }
    }

    public void asTrustStore(String string, String string2, String string3) throws Exception {
        try {
            if (this.tokenLib_trust != null && this.tokenLib_trust.compareToIgnoreCase(string2) == 0 && this.ts != null) {
                return;
            }
            if (this.tokenLib_key != null && string2.compareTo(this.tokenLib_key) == 0 && this.ks != null) {
                this.tmf = TrustManagerFactory.getInstance("IbmX509");
                this.ts = this.ks;
                this.tmf.init(this.ks);
            } else {
                this.tmf = TrustManagerFactory.getInstance("IbmX509");
                this.ts = KeyStore.getInstance(pkcsType, pkcsProvider);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                this.ts.load(byteArrayInputStream, string3.toCharArray());
                this.tmf.init(this.ts);
            }
            this.tokenLib_trust = new String(string2);
            this.tokenType_trust = new String(string);
        }
        catch (Exception exception) {
            String string4 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", exception.getLocalizedMessage());
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "asTrustStore", string4, (String)null);
            }
            this.tmf = null;
            this.ts = null;
            this.tokenLib_trust = null;
            this.tokenType_trust = null;
            throw exception;
        }
    }

    public KeyManagerFactory getKMF() {
        return this.kmf;
    }

    public KeyStore getKS() {
        return this.ks;
    }

    public TrustManagerFactory getTMF() {
        return this.tmf;
    }

    public KeyStore getTS() {
        return this.ts;
    }

    public String getlibName_key() {
        return this.tokenLib_key;
    }

    public String getlibName_trust() {
        return this.tokenLib_trust;
    }

    public String gettokType_key() {
        return this.tokenType_key;
    }

    public String gettokType_trust() {
        return this.tokenType_trust;
    }
}

