/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.KeyRingFileException;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orb.transport.WSSSLServerSocketFactory;
import com.ibm.ws.security.orbssl.SSLCiphers;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStore;
import com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl;
import com.ibm.ws.security.orbssl.WSX509KeyManager;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class WSSSLServerSocketFactoryImpl
implements WSSSLServerSocketFactory {
    private static final String SCCSID = " @(#) 1.22.1.2 ws/code/orbext/src/com/ibm/ws/security/orbssl/WSSSLServerSocketFactoryImpl.java, WAS.orbext, ASV51X, a0425.05 4/1/04 15:19:55 [6/24/04 12:49:17]";
    private static String[] DEFAULT_ENABLED_CIPHERS = null;
    private static SSLContext sslContext;

    public synchronized ServerSocket createSSLServerSocket(ServerConnectionData serverConnectionData) {
        SSLServerConnectionData sSLServerConnectionData = (SSLServerConnectionData)serverConnectionData;
        SSLServerSocket sSLServerSocket = null;
        JSSEProvider jSSEProvider = null;
        boolean bl = sSLServerConnectionData.getMessageLoggingEnabled();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "\n[\n" + ((Object)sSLServerConnectionData).toString() + "\n]\n");
        }
        try {
            jSSEProvider = JSSEProviderFactory.getInstance(sSLServerConnectionData.getContextProvider());
            this.initContext(sSLServerConnectionData, jSSEProvider);
            int n = sSLServerConnectionData.getTargetSupportsQOP();
            int n2 = sSLServerConnectionData.getTargetRequiresQOP();
            String string = sSLServerConnectionData.getContextProvider();
            String[] stringArray = sslContext.getSocketFactory().getSupportedCipherSuites();
            String[] stringArray2 = new String[stringArray.length];
            if (n < 1) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that was passed to createSSLServerSocket returns a value for getTargetSupportsQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_SUPPORTS_LESS_THAN_1", 1229066355, CompletionStatus.COMPLETED_NO);
            }
            if (n2 < 1) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket returned a value from getTargetRequiresQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetRequires"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_REQUIRES_LESS_THAN_1", 1229066356, CompletionStatus.COMPLETED_NO);
            }
            if (n < n2) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket contains a TargetSupportsQOP value that is less than its  TargetRequirsQOP value.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetSupports2"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_LESS_THAN_TARGET_REQUIRES", 1229066357, CompletionStatus.COMPLETED_NO);
            }
            SSLServerSocketFactory sSLServerSocketFactory = sslContext.getServerSocketFactory();
            try {
                if (sSLServerConnectionData.getUseSingleNIC()) {
                    sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(sSLServerConnectionData.getServerPort(), sSLServerConnectionData.getServerServerQueueDepth(), InetAddress.getByName(sSLServerConnectionData.getServerHost()));
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To A Specific NIC card=" + sSLServerConnectionData.getUseSingleNIC() + ", Remote Port=" + sSLServerConnectionData.getServerPort() + ", Server Queue Depth=" + sSLServerConnectionData.getServerServerQueueDepth() + ", LocalHost=" + sSLServerConnectionData.getServerHost() + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(sSLServerConnectionData.getServerHost()));
                    }
                } else {
                    sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(sSLServerConnectionData.getServerPort(), sSLServerConnectionData.getServerServerQueueDepth());
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To Multiple NIC cards=" + !sSLServerConnectionData.getUseSingleNIC() + ", Remote Port=" + sSLServerConnectionData.getServerPort() + ", Server Queue Depth=" + sSLServerConnectionData.getServerServerQueueDepth());
                    }
                }
                if (sSLServerConnectionData.getClientAuthenticationFlag()) {
                    sSLServerSocket.setNeedClientAuth(true);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", (String)"341", (Object)this);
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)iOException);
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)iOException);
                }
                throw new INTERNAL("UNABLE_TO_CREATE_SSL_SERVER_SOCKET Exception=" + iOException, 1229066358, CompletionStatus.COMPLETED_NO);
            }
            if (DEFAULT_ENABLED_CIPHERS != null && DEFAULT_ENABLED_CIPHERS[0] != null && DEFAULT_ENABLED_CIPHERS[0] != "") {
                sSLServerSocket.setEnabledCipherSuites(DEFAULT_ENABLED_CIPHERS);
            } else {
                int n3 = 4;
                int n4 = 2;
                if ((n3 & n) == 4) {
                    n = 4;
                } else if ((n4 & n) == 2) {
                    n = 2;
                }
                if ((n3 & n2) == 4) {
                    n2 = 4;
                } else if ((n4 & n2) == 2) {
                    n2 = 2;
                }
                String[] stringArray3 = new String[stringArray.length];
                if (n >= 4 && n2 >= 4) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(1, 1, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                } else if (n >= 4 && n2 == 2) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(1, 2, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                } else if (n >= 4 && n2 != 4 && n2 != 2) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(1, 3, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                } else if (n == 2 && n2 == 2) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(2, 2, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                } else if (n == 2 && n2 != 4 && n2 != 2) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(2, 3, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                } else if (n != 4 && n != 2 && n2 != 4 && n2 != 2) {
                    stringArray3 = SSLCiphers.getCipherSuitesJoin(3, 3, false, string);
                    stringArray2 = SSLCiphers.coalesceCipherSpecs(stringArray3, stringArray);
                }
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                String string3 = "";
                for (int i = 0; i < stringArray3.length; ++i) {
                    string3 = string3 + stringArray3[i] + " ";
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImplClient", "IIOPSSLConnectionClient.createSSLSocket", "\n[\nEnabled Ciphers:" + string2 + "\n" + "CiphersSpecified:" + string3 + "\n]");
                }
                if (stringArray2[0].equals("")) {
                    if (!bl) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "\"IIOPSSLConnection.coalesceCipherSpecs(...)\" returns a null. An INTERNAL exception is thrown.\n\t Suites enabled by the SSLServerSocket are " + string2 + "\n\t Suites required by ConnectionInterceptor are " + string3);
                        }
                    } else if (ORBRas.isMsgLogging) {
                        ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object[])new String[]{string2, string3});
                    }
                    throw new INTERNAL(" NO_OVERLAP_OF_ENABLED_AND_DESIRED_CIPHER_SUITES", 1229066335, CompletionStatus.COMPLETED_NO);
                }
                sSLServerSocket.setEnabledCipherSuites(stringArray2);
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            FFDCFilter.processException((Throwable)cOMM_FAILURE, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", (String)"520", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)((Object)cOMM_FAILURE));
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)cOMM_FAILURE);
            }
            throw cOMM_FAILURE;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", (String)"554", (Object)this);
            String[] stringArray = new String[]{exception.toString()};
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", exception);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)exception);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + exception, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        if (serverConnectionData.getServerPort() == 0) {
            serverConnectionData.setServerPort(sSLServerSocket.getLocalPort());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "Setting local port = " + serverConnectionData.getServerPort());
        }
        return sSLServerSocket;
    }

    private void initContext(SSLServerConnectionData sSLServerConnectionData, JSSEProvider jSSEProvider) {
        boolean bl = sSLServerConnectionData.getMessageLoggingEnabled();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.initContext", "\n[\n" + ((Object)sSLServerConnectionData).toString() + "\n]\n");
        }
        try {
            KeyManager[] keyManagerArray;
            Object object;
            Object object2;
            String string;
            Object object3;
            KeyStore keyStore = null;
            KeyStore keyStore2 = null;
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = null;
            String string2 = null;
            String string3 = null;
            String string4 = sSLServerConnectionData.getKeyStoreType();
            String string5 = sSLServerConnectionData.getKeyRingName();
            String string6 = sSLServerConnectionData.getKeyRingPassword();
            String string7 = sSLServerConnectionData.getHardwareTokenType();
            String string8 = sSLServerConnectionData.getHardwareTokenLibraryFile();
            String string9 = sSLServerConnectionData.getHardwareTokenPassword();
            String string10 = sSLServerConnectionData.getHardwareTokenSlot();
            String string11 = sSLServerConnectionData.getServerAlias();
            String string12 = sSLServerConnectionData.getClientAlias();
            int n = -1;
            int n2 = -1;
            if (string10 != null && string10.length() != 0) {
                if (string11 != null && string11.length() != 0) {
                    n = Integer.valueOf(string10);
                }
                if (string12 != null && string12.length() != 0) {
                    n2 = Integer.valueOf(string10);
                }
            }
            if (string4 == null || string4 == "") {
                string4 = "JKS";
            }
            boolean bl2 = true;
            int n3 = 0;
            while (bl2) {
                try {
                    keyStore = jSSEProvider.getKeyStoreInstance(string4);
                    keyManagerFactory = jSSEProvider.getKeyManagerFactoryInstance();
                    if (string5 != null && string5 != "" && string6 != null && string6 != "") {
                        object3 = null;
                        string = string5;
                        try {
                            object3 = (FileInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws FileNotFoundException {
                                    return new FileInputStream(string);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"696", (Object)this);
                            throw (FileNotFoundException)privilegedActionException.getException();
                        }
                        keyStore.load((InputStream)object3, string6 == null ? null : string6.toCharArray());
                        string2 = string6;
                        keyManagerFactory.init(keyStore, string2 == null ? null : string2.toCharArray());
                        bl2 = false;
                        continue;
                    }
                    if (string7 != null && string8 != null && string9 != null && string7.length() != 0 && string8.length() != 0 && string9.length() != 0) {
                        object3 = WSSSLClientSocketFactoryImpl.getPKCSkeyStoreList().insert(string7, string8, string9, true);
                        if (object3 == null) continue;
                        keyStore = ((WSPKCSInKeyStore)object3).getKS();
                        keyManagerFactory = ((WSPKCSInKeyStore)object3).getKMF();
                        bl2 = false;
                        continue;
                    }
                    object3 = new KeyRingFileException("KeyRingFileException.missingSSLKeyRingData");
                    throw object3;
                }
                catch (IOException iOException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)iOException);
                    }
                    if (iOException.getMessage().equalsIgnoreCase("Invalid keystore format") || iOException.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", "Bad keystore format, retrying with different format.");
                        }
                        if (ORBRas.isMsgLogging) {
                            ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.InvalidKeyStoreType"), (String)null, (Object[])null);
                        }
                        if (string4.equalsIgnoreCase("JKS")) {
                            string4 = "JCEKS";
                        } else if (string4.equalsIgnoreCase("JCEKS")) {
                            string4 = "PKCS12";
                        } else if (string4.equalsIgnoreCase("PKCS12")) {
                            string4 = "JCEKS";
                        }
                        if (n3++ <= 1) continue;
                        throw iOException;
                    }
                    throw iOException;
                }
            }
            object3 = sSLServerConnectionData.getTrustFileName();
            string = sSLServerConnectionData.getTrustFilePassword();
            String string13 = sSLServerConnectionData.getTrustStoreType();
            bl2 = true;
            n3 = 0;
            while (bl2) {
                try {
                    keyStore2 = string13 != null && string13 != "" ? jSSEProvider.getKeyStoreInstance(string13) : jSSEProvider.getKeyStoreInstance("JKS");
                    trustManagerFactory = jSSEProvider.getTrustManagerFactoryInstance();
                    if (object3 != null && object3 != "" && string != null && string != "") {
                        object2 = null;
                        object = object3;
                        try {
                            object2 = (FileInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object){
                                private final /* synthetic */ String val$nametrFile;
                                {
                                    this.val$nametrFile = string;
                                }

                                public Object run() throws FileNotFoundException {
                                    return new FileInputStream(this.val$nametrFile);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"836", (Object)this);
                            throw (FileNotFoundException)privilegedActionException.getException();
                        }
                        keyStore2.load((InputStream)object2, string == null ? null : string.toCharArray());
                        string3 = string;
                        if (keyStore2 != null) {
                            trustManagerFactory.init(keyStore2);
                        }
                        bl2 = false;
                        continue;
                    }
                    if (string7 != null && string8 != null && string9 != null && string7.length() != 0 && string8.length() != 0 && string9.length() != 0) {
                        object2 = WSSSLClientSocketFactoryImpl.getPKCSkeyStoreList().insert(string7, string8, string9, false);
                        if (object2 == null) continue;
                        keyStore2 = ((WSPKCSInKeyStore)object2).getTS();
                        trustManagerFactory = ((WSPKCSInKeyStore)object2).getTMF();
                        bl2 = false;
                        continue;
                    }
                    object2 = new KeyRingFileException("KeyRingFileException.missingSSLKeyRingData");
                    throw object2;
                }
                catch (IOException iOException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)iOException);
                    }
                    if (iOException.getMessage().equalsIgnoreCase("Invalid keystore format") || iOException.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", "Bad keystore format, retrying with different format.");
                        }
                        if (ORBRas.isMsgLogging) {
                            ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.InvalidKeyStoreType"), (String)null, (Object[])null);
                        }
                        if (string13.equalsIgnoreCase("JKS")) {
                            string13 = "JCEKS";
                        } else if (string13.equalsIgnoreCase("JCEKS")) {
                            string13 = "PKCS12";
                        } else if (string13.equalsIgnoreCase("PKCS12")) {
                            string13 = "JCEKS";
                        }
                        if (n3++ <= 1) continue;
                        throw iOException;
                    }
                    throw iOException;
                }
            }
            object2 = sSLServerConnectionData.getProtocolName();
            sslContext = object2 != null && object2 != "" ? jSSEProvider.getSSLContextInstance((String)object2) : jSSEProvider.getSSLContextInstance("SSL");
            object = new WSX509KeyManager(keyStore, string2 == null ? null : string2.toCharArray(), keyManagerFactory);
            if (((WSX509KeyManager)object).getX509KeyManager() == null || (string11 == null || string11.equals("")) && (string12 == null || string12.equals(""))) {
                keyManagerArray = keyManagerFactory.getKeyManagers();
                sslContext.init(keyManagerArray, trustManagerFactory.getTrustManagers(), null);
            } else {
                if (string12 != null && !string12.equals("")) {
                    ((WSX509KeyManager)object).setClientAlias(string12, n2);
                }
                if (string11 != null && !string11.equals("")) {
                    ((WSX509KeyManager)object).setServerAlias(string11, n);
                }
                keyManagerArray = new KeyManager[]{object};
                sslContext.init(keyManagerArray, trustManagerFactory.getTrustManagers(), null);
            }
            keyManagerArray = sSLServerConnectionData.getCiphersToBeEnabled();
            if (keyManagerArray != null && keyManagerArray != "") {
                int n4 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer((String)keyManagerArray, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n4;
                }
                DEFAULT_ENABLED_CIPHERS = new String[n4];
                n4 = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)keyManagerArray, " ");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string14 = stringTokenizer2.nextToken();
                    WSSSLServerSocketFactoryImpl.DEFAULT_ENABLED_CIPHERS[n4++] = string14;
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"992", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)keyStoreException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)keyStoreException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + keyStoreException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (CertificateException certificateException) {
            FFDCFilter.processException((Throwable)certificateException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1027", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)certificateException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)certificateException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + certificateException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1063", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)noSuchAlgorithmException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)noSuchAlgorithmException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + noSuchAlgorithmException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            FFDCFilter.processException((Throwable)unrecoverableKeyException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1096", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)unrecoverableKeyException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)unrecoverableKeyException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + unrecoverableKeyException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (KeyManagementException keyManagementException) {
            FFDCFilter.processException((Throwable)keyManagementException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1131", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)keyManagementException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)keyManagementException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + keyManagementException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1166", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)iOException);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)iOException);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + iOException, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            FFDCFilter.processException((Throwable)cOMM_FAILURE, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1202", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", (Exception)((Object)cOMM_FAILURE));
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)cOMM_FAILURE);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + (Object)((Object)cOMM_FAILURE), 1229066359, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.initContext", (String)"1238", (Object)this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", exception);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "initContext", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.initContext"), (String)null, (Object)exception);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + exception, 1229066359, CompletionStatus.COMPLETED_NO);
        }
    }

    public X509Certificate[] getPeerCertificateChain(SSLSocket sSLSocket) {
        SSLSession sSLSession;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "theSocket=" + sSLSocket);
        }
        if ((sSLSession = sSLSocket.getSession()) == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "theSocket.getSession returned null");
            }
            throw new INTERNAL("GET_SSL_SESSION_RETURNED_NULL", 1229066362, CompletionStatus.COMPLETED_NO);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = sSLSession.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "Caught Exception from getPeerCertificateChain(),  returning a null for peerCertificateChain:  Exception=" + sSLPeerUnverifiedException);
            }
            x509CertificateArray = null;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "About to return peerCertificateChain=" + x509CertificateArray);
        }
        return x509CertificateArray;
    }
}

