/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.orb.transport.KeyRingFileException;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class WSX509KeyManager
implements X509KeyManager {
    private KeyStore ks = null;
    private KeyManager[] kmList = null;
    private X509KeyManager km = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private int clientslotnum = -1;
    private int serverslotnum = -1;

    public void setClientAlias(String string, int n) throws Exception {
        if (!this.ks.containsAlias(string)) {
            KeyRingFileException keyRingFileException = new KeyRingFileException("KeyRingFileException.keyStoreClientAliasNotFound");
            throw keyRingFileException;
        }
        this.clientAlias = string;
        this.clientslotnum = n;
    }

    public void setServerAlias(String string, int n) throws Exception {
        if (!this.ks.containsAlias(string)) {
            KeyRingFileException keyRingFileException = new KeyRingFileException("KeyRingFileException.keyStoreServerAliasNotFound");
            throw keyRingFileException;
        }
        this.serverAlias = string;
        this.serverslotnum = n;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseClientAlias(stringArray[0], principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseServerAlias(string, principalArray);
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] stringArray = this.km.getClientAliases(string, principalArray);
            String string2 = "";
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                    if (!this.clientAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) {
                    String string3 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ClientAliases", string2);
                    String string4 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ClientAliasChosen", this.clientAlias);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseClientAlias", string3 + ", " + string4);
                    }
                    return this.clientAlias;
                }
            }
            String string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ClientAliasMismatch", this.clientAlias + (this.clientslotnum == -1 ? "" : ":" + this.clientslotnum));
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseClientAlias", string5, (String)null);
            } else if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseClientAlias", string5);
            }
            return this.clientAlias;
        }
        String[] stringArray = new String[]{string};
        String string6 = this.km.chooseClientAlias(stringArray, principalArray, null);
        String string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ClientAliasChosen", string6);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseClientAlias", string7);
        }
        return string6;
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        if (this.serverAlias != null && !this.serverAlias.equals("")) {
            String[] stringArray = this.km.getServerAliases(string, principalArray);
            String string2 = "";
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                    if (!this.serverAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) {
                    String string3 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ServerAliases", string2);
                    String string4 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ServerAliasChosen", this.serverAlias);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseServerAlias", string3 + ", " + string4);
                    }
                    return this.serverAlias;
                }
            }
            String string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ServerAliasMismatch", this.serverAlias + (this.serverslotnum == -1 ? "" : ":" + this.serverslotnum));
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(8L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseServerAlias", string5, (String)null);
            } else if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseServerAlias", string5);
            }
            return this.serverAlias;
        }
        String string6 = this.km.chooseServerAlias(string, principalArray, null);
        String string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.ServerAliasChosen", string6);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "chooseServerAlias", string7);
        }
        return string6;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.km.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.km.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        return this.km.getPrivateKey(string);
    }

    public X509Certificate[] getCertificateChain(String string) {
        return this.km.getCertificateChain(string);
    }

    public X509KeyManager getX509KeyManager() {
        return this.km;
    }

    public WSX509KeyManager(KeyStore keyStore, char[] cArray, KeyManagerFactory keyManagerFactory) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.ks = keyStore;
        this.kmList = keyManagerFactory.getKeyManagers();
        if (this.kmList != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSX509KeyManager", "WSX509KeyManager.init", "Creating WSX509KeyManager.");
            }
            this.km = (X509KeyManager)this.kmList[0];
        }
    }
}

