/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.provider.DefaultJSSEProvider;
import com.ibm.ws.ssl.provider.IBMJSSEFIPSProvider;
import com.ibm.ws.ssl.provider.IBMJSSEProvider;
import com.ibm.ws.ssl.provider.SunJSSEProvider;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;

public class JSSEProviderFactory {
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$ssl$JSSEProviderFactory == null ? (class$com$ibm$ws$ssl$JSSEProviderFactory = JSSEProviderFactory.class$("com.ibm.ws.ssl.JSSEProviderFactory")) : class$com$ibm$ws$ssl$JSSEProviderFactory).getName(), (String)"SSL");
    private static JSSEProvider cachedProvider = null;
    private static Boolean USE_FIPS_FLAG = new Boolean(false);
    private static Hashtable providerCache = new Hashtable();
    private static String IBMJSSEFIPS_PROVIDER = "IBMJSSEFIPS";
    private static String IBMJSSE_PROVIDER = "IBMJSSE";
    private static String SUNJSSE_PROVIDER = "SunJSSE";
    private static String DEFAULT_PROVIDER = "Default";
    static /* synthetic */ Class class$com$ibm$ws$ssl$JSSEProviderFactory;

    public static JSSEProvider getInstance() {
        return JSSEProviderFactory.getInstance(DEFAULT_PROVIDER);
    }

    public static JSSEProvider getInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInstance: " + string));
        }
        if (string == null) {
            string = DEFAULT_PROVIDER;
        }
        if (string != null) {
            cachedProvider = (JSSEProvider)providerCache.get(string);
            if (cachedProvider != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getInstance returning cached provider: " + cachedProvider));
                }
                return cachedProvider;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cachedProvider is null, proceeding to determine the provider.");
            }
        }
        USE_FIPS_FLAG = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                String string = Security.getProperty("USEFIPS_ENABLED");
                if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on"))) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        });
        Provider[] providerArray = Security.getProviders();
        if (string.equalsIgnoreCase(IBMJSSEFIPS_PROVIDER)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getInstance provider = " + string));
            }
            cachedProvider = new IBMJSSEFIPSProvider();
            providerCache.put(IBMJSSEFIPS_PROVIDER, cachedProvider);
            return cachedProvider;
        }
        for (int i = 0; i < providerArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider name [" + i + "]: " + providerArray[i].getName()));
            }
            if (cachedProvider != null) continue;
            if (providerArray[i].getName().equalsIgnoreCase(IBMJSSE_PROVIDER)) {
                if (!JSSEProviderFactory.validateProvider(IBMJSSE_PROVIDER)) continue;
                cachedProvider = new IBMJSSEProvider();
                providerCache.put(IBMJSSE_PROVIDER, cachedProvider);
                providerCache.put(string, cachedProvider);
                continue;
            }
            if (!providerArray[i].getName().equalsIgnoreCase(SUNJSSE_PROVIDER) || !JSSEProviderFactory.validateProvider(SUNJSSE_PROVIDER)) continue;
            cachedProvider = new SunJSSEProvider();
            providerCache.put(SUNJSSE_PROVIDER, cachedProvider);
            providerCache.put(string, cachedProvider);
        }
        if (cachedProvider == null) {
            if (USE_FIPS_FLAG.booleanValue()) {
                Tr.warning((TraceComponent)tc, (String)"UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInstance provider = DefaultJSSEProvider");
            }
            cachedProvider = new DefaultJSSEProvider();
            providerCache.put(DEFAULT_PROVIDER, cachedProvider);
            providerCache.put(string, cachedProvider);
            return cachedProvider;
        }
        if (USE_FIPS_FLAG.booleanValue()) {
            Tr.warning((TraceComponent)tc, (String)"UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance provider = " + cachedProvider));
        }
        return cachedProvider;
    }

    private static boolean validateProvider(String string) {
        boolean bl = true;
        try {
            SSLContext sSLContext = null;
            try {
                final String string2 = string;
                sSLContext = (SSLContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                        return SSLContext.getInstance("SSL", string2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error validating provider: " + string + ", Exception: " + exception.getMessage()), (Object)new Object[]{exception});
                }
                bl = false;
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error validating provider: " + string + ", Exception: " + throwable.getMessage()), (Object)new Object[]{throwable});
            }
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

