/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class DefaultJSSEProvider
implements JSSEProvider {
    HostnameVerifier verifier = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };
    private String keyManager = "";
    private String trustManager = "";
    private String contextProvider = "";
    private String keyStoreProvider = "";
    private String socketFactory = "";
    private String protocolPackageHandler = "";
    private static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] MEDIUM_CIPHER_SUITES = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] LOW_SERVER_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] LOW_CLIENT_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    private static final String[] CONFIDENTIALITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] INTEGRITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    private static final String[] AUTHENTICITY_CIPHER_SUITES = new String[]{"SSL_NULL_WITH_NULL_NULL"};
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$ssl$provider$IBMJSSEProvider == null ? (class$com$ibm$ws$ssl$provider$IBMJSSEProvider = DefaultJSSEProvider.class$("com.ibm.ws.ssl.provider.IBMJSSEProvider")) : class$com$ibm$ws$ssl$provider$IBMJSSEProvider).getName(), (String)"SSL");
    static /* synthetic */ Class class$com$ibm$ws$ssl$provider$IBMJSSEProvider;

    public DefaultJSSEProvider() {
        HttpsURLConnection.setDefaultHostnameVerifier(this.verifier);
    }

    public String getSSLSocketFactory() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSSLSocketFactory: default");
        }
        return System.getProperty("ssl.SocketFactory.provider");
    }

    public String getSSLProtocolPackageHandler() {
        return System.getProperty("java.protocol.handler.pkgs");
    }

    public String[] getCiphersForSecurityLevel(boolean bl, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCiphersForSecurityLevel: ", (Object)new Object[]{new Boolean(bl), string});
        }
        if (string == null) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("high")) {
            return HIGH_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("medium")) {
            return MEDIUM_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("low")) {
            if (!bl) {
                return LOW_SERVER_CIPHER_SUITES;
            }
            return LOW_CLIENT_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("confidentiality")) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("integrity")) {
            return INTEGRITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("authenticity")) {
            return AUTHENTICITY_CIPHER_SUITES;
        }
        return CONFIDENTIALITY_CIPHER_SUITES;
    }

    public SSLContext getSSLContextInstance(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("return SSLContext.getInstance(" + string + ")"));
        }
        return SSLContext.getInstance(string);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.trustManager = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.TrustManagerFactory.algorithm");
            }
        });
        if (this.trustManager == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No trustManager algorithm for property ssl.TrustManagerFactory.algorithm.");
            }
            throw new NoSuchAlgorithmException("No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
        }
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("return TrustManagerFactory.getInstance(" + this.trustManager + ")"));
        }
        return TrustManagerFactory.getInstance(this.trustManager);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.keyManager = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.KeyManagerFactory.algorithm");
            }
        });
        if (this.keyManager == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
            }
            throw new NoSuchAlgorithmException("No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
        }
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("return KeyManagerFactory.getInstance(" + this.keyManager + ")"));
        }
        return KeyManagerFactory.getInstance(this.keyManager);
    }

    public KeyStore getKeyStoreInstance(String string) throws KeyStoreException, NoSuchProviderException {
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyStore.getInstance(" + string + ")"));
        }
        return KeyStore.getInstance(string);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

