/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IBMJSSEFIPSProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private String keyManager = "IbmX509";
    private String trustManager = "IbmX509";
    private String contextProvider = "IBMJSSEFIPS";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.fips.jsse.JSSESocketFactory";
    private String protocolPackageHandler = "com.ibm.fips.net.ssl.internal.www.protocol";
    private static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] MEDIUM_CIPHER_SUITES = new String[0];
    private static final String[] LOW_SERVER_CIPHER_SUITES = new String[0];
    private static final String[] LOW_CLIENT_CIPHER_SUITES = new String[0];
    private static final String[] CONFIDENTIALITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] INTEGRITY_CIPHER_SUITES = new String[0];
    private static final String[] AUTHENTICITY_CIPHER_SUITES = new String[0];
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$ssl$provider$IBMJSSEFIPSProvider == null ? (class$com$ibm$ws$ssl$provider$IBMJSSEFIPSProvider = IBMJSSEFIPSProvider.class$("com.ibm.ws.ssl.provider.IBMJSSEFIPSProvider")) : class$com$ibm$ws$ssl$provider$IBMJSSEFIPSProvider).getName(), (String)"SSL");
    static /* synthetic */ Class class$com$ibm$ws$ssl$provider$IBMJSSEFIPSProvider;

    public IBMJSSEFIPSProvider() {
        AbstractJSSEProvider.registerPackage(this.protocolPackageHandler);
        Provider provider = null;
        try {
            provider = Security.getProvider("IBMJSSE");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSE) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        Provider provider2 = null;
        try {
            provider2 = Security.getProvider("IBMJSSEFIPS");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSEFIPS) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        try {
            if (provider2 == null) {
                int n = 0;
                if (provider != null) {
                    Provider[] providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        if (providerArray[i] == null || !new String("IBMJSSE").equals(providerArray[i].getName())) continue;
                        n = i;
                        break;
                    }
                }
                provider2 = (Provider)Class.forName("com.ibm.fips.jsse.IBMJSSEFIPSProvider").newInstance();
                if (n > 0) {
                    Security.insertProviderAt(provider2, n);
                } else {
                    Security.addProvider(provider2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception caught adding IBMJSSEFIPS: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public String getSSLSocketFactory() {
        return super.getSSLSocketFactory(this.socketFactory);
    }

    public String getSSLProtocolPackageHandler() {
        return super.getSSLProtocolPackageHandler(this.protocolPackageHandler);
    }

    public String[] getCiphersForSecurityLevel(boolean bl, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCiphersForSecurityLevel: ", (Object)new Object[]{new Boolean(bl), string});
        }
        if (string == null) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("high")) {
            return HIGH_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("medium")) {
            return MEDIUM_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("low")) {
            if (!bl) {
                return LOW_SERVER_CIPHER_SUITES;
            }
            return LOW_CLIENT_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("confidentiality")) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("integrity")) {
            return INTEGRITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("authenticity")) {
            return AUTHENTICITY_CIPHER_SUITES;
        }
        return CONFIDENTIALITY_CIPHER_SUITES;
    }

    public SSLContext getSSLContextInstance(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getSSLContextInstance(string, this.contextProvider);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getTrustManagerFactoryInstance(this.trustManager, this.contextProvider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getKeyManagerFactoryInstance(this.keyManager, this.contextProvider);
    }

    public KeyStore getKeyStoreInstance(String string) throws KeyStoreException, NoSuchProviderException {
        return super.getKeyStoreInstance(string, this.keyStoreProvider);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

