/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IBMJSSEProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private String keyManager = "IbmX509";
    private String trustManager = "IbmX509";
    private String contextProvider = "IBMJSSE";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.jsse.JSSESocketFactory";
    private String protocolPackageHandler = "com.ibm.net.ssl.internal.www.protocol";
    private static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] MEDIUM_CIPHER_SUITES = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] LOW_SERVER_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] LOW_CLIENT_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    private static final String[] CONFIDENTIALITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] INTEGRITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    private static final String[] AUTHENTICITY_CIPHER_SUITES = new String[]{"SSL_NULL_WITH_NULL_NULL"};
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$ssl$provider$IBMJSSEProvider == null ? (class$com$ibm$ws$ssl$provider$IBMJSSEProvider = IBMJSSEProvider.class$("com.ibm.ws.ssl.provider.IBMJSSEProvider")) : class$com$ibm$ws$ssl$provider$IBMJSSEProvider).getName(), (String)"SSL");
    static /* synthetic */ Class class$com$ibm$ws$ssl$provider$IBMJSSEProvider;

    public IBMJSSEProvider() {
        AbstractJSSEProvider.registerPackage(this.protocolPackageHandler);
    }

    public String getSSLSocketFactory() {
        return super.getSSLSocketFactory(this.socketFactory);
    }

    public String getSSLProtocolPackageHandler() {
        return super.getSSLProtocolPackageHandler(this.protocolPackageHandler);
    }

    public String[] getCiphersForSecurityLevel(boolean bl, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCiphersForSecurityLevel: ", (Object)new Object[]{new Boolean(bl), string});
        }
        if (string == null) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("high")) {
            return HIGH_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("medium")) {
            return MEDIUM_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("low")) {
            if (!bl) {
                return LOW_SERVER_CIPHER_SUITES;
            }
            return LOW_CLIENT_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("confidentiality")) {
            return CONFIDENTIALITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("integrity")) {
            return INTEGRITY_CIPHER_SUITES;
        }
        if (string.equalsIgnoreCase("authenticity")) {
            return AUTHENTICITY_CIPHER_SUITES;
        }
        return CONFIDENTIALITY_CIPHER_SUITES;
    }

    public SSLContext getSSLContextInstance(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getSSLContextInstance(string, this.contextProvider);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getTrustManagerFactoryInstance(this.trustManager, this.contextProvider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getKeyManagerFactoryInstance(this.keyManager, this.contextProvider);
    }

    public KeyStore getKeyStoreInstance(String string) throws KeyStoreException, NoSuchProviderException {
        return super.getKeyStoreInstance(string, this.keyStoreProvider);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

