
package com.ibm.oti.vm;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2003  All Rights Reserved
 */

import java.io.File;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * BootstrapClassLoaders load classes out of the file system,
 * from the directories and jars on the system class path.
 * The system class path can be set using the command line
 * option "-scp <paths>", and can be read from the system
 * property "com.ibm.oti.system.class.path".
 *
 * @author		OTI
 * @version		initial
 */

public final class BootstrapClassLoader extends AbstractClassLoader{

	static {
		com.ibm.oti.vm.VM.initializeVM();
		Class cl = Integer.class;
	}
	private static BootstrapClassLoader singleton;
	private Hashtable packages = new Hashtable();
	private boolean defined = false;

/**
 * Prevents this class from being instantiated.
 * BootstrapClassLoaders may only be created by the VM.
 *
 * @author		OTI
 * @version		initial
 */
private BootstrapClassLoader() {
	String classPath = System.getProperty("com.ibm.oti.system.class.path");
	int count = VM.getClassPathCount();
	types = new int[count];
	cache = new Object[count];
	parsedPath = new String[count];
	VM.initializeClassLoader(this, true);
}

/**
 * Invoked by the Virtual Machine when resolving class references.
 * Equivalent to loadClass(className, false);
 *
 * @author		OTI
 * @version		initial
 *
 * @return 		java.lang.Class
 *					the Class object.
 * @param 		className String
 *					the name of the class to search for.
 * @exception	ClassNotFoundException
 *					If the class could not be found.
 */
public Class loadClass(String className) throws ClassNotFoundException {
	Class loadedClass = com.ibm.oti.vm.VM.findClassOrNull(className, this);

	if (loadedClass != null) {
		String packageName = getPackageName(loadedClass);
		if (packageName != null) {
			int index = VM.getCPIndexImpl(loadedClass);
			if (packages != null) {
				synchronized(packages) {
					if (!packages.containsKey(packageName))
						packages.put(packageName, new Integer(index));
				}
			} else
				definePackage(packageName, index);
		}
	}

	return loadedClass;
}

public static ClassLoader singleton() {
	if (singleton == null)
	 	singleton = new BootstrapClassLoader();
	 else
	 	throw new InstantiationError(com.ibm.oti.util.Msg.getString("K0084"));
 	return singleton;
}

protected Package getPackage(String name) {
	if (!defined) definePackages();
	return super.getPackage(name);
}

protected Package[] getPackages() {
	if (!defined) definePackages();
	return super.getPackages();
}

synchronized private void definePackages() {
	if (defined) return;
	defined = true;
	Hashtable toDefine = packages;
	packages = new Hashtable();
	Enumeration keys = toDefine.keys();
	while (keys.hasMoreElements()) {
		String packageName = (String)keys.nextElement();
		definePackage(packageName, ((Integer)toDefine.get(packageName)).intValue());
	}
	toDefine = packages;
	packages = null;
	keys = toDefine.keys();
	while (keys.hasMoreElements()) {
		String packageName = (String)keys.nextElement();
		definePackage(packageName, ((Integer)toDefine.get(packageName)).intValue());
	}
}

}
