package java.lang.ref;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2003  All Rights Reserved
 */

/**
 * SoftReference objects are used to detect referents which
 * are no longer visible and who's memory is to be reclaimed.
 *
 * @author		OTI
 * @version		initial
 * @since		JDK1.2
 */
public class SoftReference extends java.lang.ref.Reference {

/**
 * Constructs a new instance of this class.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		r
 *					referent to track.
 * @param		q
 *					queue to register to the reference object with.
 */
public SoftReference(Object r, ReferenceQueue q) {
	initReference(r, q);
}

/**
 * Constructs a new instance of this class.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		r
 *					 referent to track.
 */
public SoftReference(Object r) {
	initReference(r, null);
}

/**
 * Return the referent of the reference object.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		Object
 *					Referent to which reference refers,
 *					or null if object has been cleared.
 */
public Object get () {
	return super.get();
}

}
