package java.lang.ref;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2003  All Rights Reserved
 */

/**
 * WeakReference objects are used to detect referents which
 * are no longer visible.
 *
 * @author		OTI
 * @version		initial
 * @since		JDK1.2
 */
public class WeakReference extends java.lang.ref.Reference {

/**
 * Constructs a new instance of this class.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		r
 *					referent to track.
 * @param		q
 *					queue to register to the reference object with.
 */
public WeakReference(Object r, ReferenceQueue q) {
	initReference(r, q);
}

/**
 * Constructs a new instance of this class.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		r
 *					referent to track.
 */
public WeakReference(Object r) {
	initReference(r, null);
}
}
