/*
 * @(#)src/classes/sov/java/awt/datatransfer/Clipboard.java, awt-dnd, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1996-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)Clipboard.java	1.10 99/04/22
 *
 */

package java.awt.datatransfer;

/**
 * A class which implements a mechanism to transfer data using 
 * cut/copy/paste operations.
 *
 * @version 	1.10, 04/22/99
 * @author	Amy Fowler
 */
public class Clipboard {

    String name;

    protected ClipboardOwner owner;
    protected Transferable contents;

    /**
     * Creates a clipboard object.
     */
    public Clipboard(String name) {
        this.name = name;
    }

    /**
     * Returns the name of this clipboard object.
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the current contents of the clipboard to the specified
     * transferable object and registers the specified clipboard owner
     * as the owner of the new contents.  If there is an existing owner 
     * registered, that owner is notified that it no longer holds ownership
     * of the clipboard contents.
     * @param content the transferable object representing the clipboard content
     * @param owner the object which owns the clipboard content
     */
    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
	if (this.owner != null && this.owner != owner) {
	    this.owner.lostOwnership(this, this.contents);
	}
	this.owner = owner;
	this.contents = contents;
    }

    /**
     * Returns a transferable object representing the current contents
     * of the clipboard.  If the clipboard currently has no contents,
     * it returns null. The parameter Object requestor is not currently used.
     * @param requestor the object requesting the clip data  (not used)
     * @return the current transferable object on the clipboard
     */
    public synchronized Transferable getContents(Object requestor) {
        return contents;
    }

}

    

    
