/*
 * @(#)src/classes/sov/java/awt/datatransfer/UnsupportedFlavorException.java, awt-dnd, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 * 
 */
 
/*
 * @(#)UnsupportedFlavorException.java	1.12 01/02/09
 *
 */

package java.awt.datatransfer;

/**
 * Signals that the requested data is not supported in this flavor.
 * @see Transferable#getTransferData
 *
 * @version 	1.12, 02/09/01
 * @author	Amy Fowler
 */
public class UnsupportedFlavorException extends Exception {

     /*
      * JDK 1.1 serialVersionUID 
      */

     private static final long serialVersionUID = 5383814944251665601L;

    /**
     * Constructs an UnsupportedFlavorException.
     * @param flavor the flavor object which caused the exception
     * @throws NullPointerException if flavor is <code>null</code>
     */  
    public UnsupportedFlavorException(DataFlavor flavor) {
	// JCK Test UnsupportedFlavorException0002: if 'flavor' is null, throw
	// NPE
	super(flavor.getHumanPresentableName());
    }
}
