/*
 * @(#)src/classes/sov/java/awt/dnd/DragGestureListener.java, awt-dnd, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)DragGestureListener.java	1.6 99/04/22
 *
 */



package java.awt.dnd;

import java.util.EventListener;

/**
 * This interface is sourced from a <code>DragGestureRecognizer</code> 
 * and is invoked
 * when an object of that (sub)class detects a drag initiating
 * gesture.
 * <p>
 * The implementor of this interface is responsible for starting the drag
 * as a result of receiving such notification.
 *
 * @see java.awt.dnd.DragGestureRecognizer
 * @see java.awt.dnd.DragGestureEvent
 * @see java.awt.dnd.DragSource
 */

 public interface DragGestureListener extends EventListener {

    /**
     * A <code>DragGestureRecognizer</code> has detected 
     * a platform-dependent drag initiating gesture and 
     * is notifying this listener
     * in order for it to initiate the action for the user.
     * <P>
     * @param dge the <code>DragGestureEvent</code> describing 
     * the gesture that has just occurred
     */

     void dragGestureRecognized(DragGestureEvent dge);
}
