/*
 * @(#)src/classes/sov/java/awt/dnd/DragSourceEvent.java, awt-dnd, as131, 20031014 1.7.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

/*
 * @(#)DragSourceEvent.java     1.11 99/06/09
 *
 */

package java.awt.dnd;

import java.awt.dnd.DragSourceContext;

import java.util.EventObject;

/**
 * This class is the base class for
 * <code>DragSourceDragEvent</code> and
 * <code>DragSourceDropEvent</code>.
 * @since 1.2
 *
 */

public class DragSourceEvent extends EventObject {

    /**
     * Construct a <code>DragSourceEvent</code>
     * given a specified <code>DragSourceContext</code>.
     * <P>
     * @param dsc the <code>DragSourceContext</code>
     */

    public DragSourceEvent(DragSourceContext dsc) { super(dsc); }

    /**
     * This method returns the <code>DragSourceContext</code> that
     * originated the event.
     * <P>
     * @return the <code>DragSourceContext</code> that originated the event
     */

    public DragSourceContext getDragSourceContext() {
        return (DragSourceContext)getSource();
    }
}

