/*
 * @(#)src/classes/sov/java/awt/print/PrinterIOException.java, print, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)PrinterIOException.java	1.7 98/10/16 
 *
 */

package java.awt.print;

import java.io.IOException;

/**
 * The <code>PrinterIOException</code> class is a subclass of
 * {@link PrinterException} and is used to indicate that an IO error 
 * of some sort has occurred while printing.
 */

public class PrinterIOException extends PrinterException {

    /**
     * The IO error that terminated the print job.
     * @serial
     */
    private IOException mException;

    /**
     * Constructs a new <code>PrinterIOException</code>
     * with the string representation of the specified
     * {@link IOException}.
     * @param exception the specified <code>IOException</code>
     */
    public PrinterIOException(IOException exception) {
        super(exception.toString());
        mException = exception;
    }

    /**
     * Returns the <code>IOException</code> that terminated 
     * the print job.
     * @return the <code>IOException</code> that terminated
     * the print job.
     * @see java.io.IOException
     */
    public IOException getIOException() {
        return mException;
    }

}
