/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextProxy.java, bean, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)BeanContextProxy.java	1.5 99/06/24
 *
 */

package java.beans.beancontext;

/**
 * <p>
 * This interface is implemented by a JavaBean that does 
 * not directly have a BeanContext(Child) associated with 
 * it (via implementing that interface or a subinterface thereof), 
 * but has a public BeanContext(Child) delegated from it.
 * For example, a subclass of java.awt.Container may have a BeanContext 
 * associated with it that all Component children of that Container shall
 * be contained within.
 * </p>
 * <p>
 * An Object may not implement this interface and the 
 * BeanContextChild interface
 * (or any subinterfaces thereof) they are mutually exclusive.
 * </p>
 * <p>
 * Callers of this interface shall examine the return type in order to 
 * obtain a particular subinterface of BeanContextChild as follows:
 * <code>
 * BeanContextChild bcc = o.getBeanContextProxy();
 *
 * if (bcc instanceof BeanContext) {
 * 	// ...
 * }
 * </code>
 * or
 * <code>
 * BeanContextChild bcc = o.getBeanContextProxy();
 * BeanContext      bc  = null;
 *
 * try {
 *     bc = (BeanContext)bcc; 
 * } catch (ClassCastException cce) {
 *     // cast failed, bcc is not an instanceof BeanContext 
 * }
 * </code>
 * </p>
 * <p>
 * The return value is a constant for the lifetime of the implementing
 * instance
 * </p>
 * @author Laurence P. G. Cable
 * @version 1.5, 06/24/99
 * @since 1.2
 *
 * @seealso java.beans.beancontext.BeanContextChild
 * @seealso java.beans.beancontext.BeanContextChildSupport
 */

public interface BeanContextProxy {

    /**
     * Gets the <code>BeanContextChild</code> (or subinterface) 
     * associated with this object. 
     * @return the <code>BeanContextChild</code> (or subinterface) 
     * associated with this object
     */
    BeanContextChild getBeanContextProxy();
}
