/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextServiceRevokedListener.java, bean, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)BeanContextServiceRevokedListener.java	1.4 99/06/22
 *
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContextServiceRevokedEvent;

import java.util.EventListener;

/**
 *  The listener interface for receiving 
 * <code>BeanContextServiceRevokedEvent</code> objects. A class that is 
 * interested in processing a <code>BeanContextServiceRevokedEvent</code>
 * implements this interface. 
 */
public interface BeanContextServiceRevokedListener extends EventListener {

    /**
     * The service named has been revoked. getService requests for
     * this service will no longer be satisifed.
     * @param bcsre the <code>BeanContextServiceRevokedEvent</code> received 
     * by this listener. 
     */
    void serviceRevoked(BeanContextServiceRevokedEvent bcsre);
}



